/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.general;

import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.utils.NetUtils;
import com.appframework.utils.OS;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.controls.ColoredScrollPane;
import com.novell.gw.jclient.application.controls.filechoser.OptionChangesListener;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.inputverification.TcpIpPortInputVerifier;
import com.novell.gw.jclient.application.controls.inputverification.UrlInputVerifier;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableList;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButton;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.options.AbstractCloneObject;
import com.novell.gw.jclient.bl.om.options.EnvironmentOptions;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class WebOptionPane
extends AbstractOptionPanel {
    private static Logger logger = Logger.getLogger(WebOptionPane.class);
    private static Insets DEFAULT_INSETS = new Insets(5, 5, 5, 5);
    private OrientablePanel pnlAutoConfig;
    private OrientablePanel pnlManualConfig;
    private OrientablePanel pnlProtocols;
    private OrientablePanel pnlBypassAddresses;
    private OrientableCheckBox cbUseProxy;
    private OrientableRadioButton rbAutoConfig;
    private OrientableRadioButton rbManualConfig;
    private GWTextField tfAutoConfigUrl;
    private GWTextField tfProxyServerAddress;
    private GWTextField tfProxyServerPort;
    private GWTextField tfProxyBypassAddress;
    private OrientableList lstBypassAdresses;
    private ActionAddBypassAddress actionAddBypassAddress;
    private ActionModifyBypassAddress actionModifyBypassAddress;
    private ActionRemoveBypassAddress actionRemoveBypassAddress;
    private ChangeDetectorListener changeDetectorListener = new ChangeDetectorListener(false);

    public WebOptionPane(OptionChangesListener changesListener, MVCController parentController) {
        super(changesListener, parentController);
        this.setName(StringResources.WEB);
    }

    protected void build() {
        this.cbUseProxy = new OrientableCheckBox(StringResources.USE_PROXY);
        this.cbUseProxy.addItemListener(this.changeDetectorListener);
        this.cbUseProxy.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                WebOptionPane.this.handleProxyEnablement(e.getStateChange() == 1);
            }
        });
        this.rbAutoConfig = new OrientableRadioButton(StringResources.AUTOMATIC_PROXY_CONFIGURATION);
        this.rbAutoConfig.addItemListener(this.changeDetectorListener);
        this.rbAutoConfig.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                WebOptionPane.this.handleAutoConfigEnablement(e.getStateChange() == 1);
            }
        });
        this.rbManualConfig = new OrientableRadioButton(StringResources.MANUAL_PROXY_CONFIGURATION);
        this.rbManualConfig.addItemListener(this.changeDetectorListener);
        ButtonGroup bgConfigType = new ButtonGroup();
        bgConfigType.add(this.rbAutoConfig);
        bgConfigType.add(this.rbManualConfig);
        this.buildAutoConfigPanel();
        this.buildManualConfigPanel();
        this.handleProxyEnablement(this.cbUseProxy.isSelected());
        this.changeDetectorListener.setEnabled(true);
        if (OS.isNimbusLAF()) {
            this.pnlAutoConfig.setBorder(BorderFactory.createTitledBorder(StringResources.AUTOMATIC_PROXY_CONFIGURATION));
            this.pnlManualConfig.setBorder(BorderFactory.createTitledBorder(StringResources.MANUAL_PROXY_CONFIGURATION));
            this.pnlBypassAddresses.setBorder(BorderFactory.createTitledBorder(StringResources.PROXY_BYPASS_ADDRESSES));
        } else {
            this.pnlAutoConfig.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), StringResources.AUTOMATIC_PROXY_CONFIGURATION));
            this.pnlManualConfig.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), StringResources.MANUAL_PROXY_CONFIGURATION));
            this.pnlBypassAddresses.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), StringResources.PROXY_BYPASS_ADDRESSES));
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.insets = new Insets(WebOptionPane.DEFAULT_INSETS.top, WebOptionPane.DEFAULT_INSETS.left, WebOptionPane.DEFAULT_INSETS.bottom, WebOptionPane.DEFAULT_INSETS.right);
        c.weightx = 1.0;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.cbUseProxy, c);
        c.gridy = 1;
        c.insets.left = 20;
        this.add((Component)this.pnlAutoConfig, c);
        c.gridy = 2;
        c.weighty = 1.0;
        this.add((Component)this.pnlManualConfig, c);
    }

    private void buildAutoConfigPanel() {
        OrientableLabel lbAutoConfigUrl = new OrientableLabel(StringResources.URL);
        this.tfAutoConfigUrl = new GWTextField();
        this.tfAutoConfigUrl.getDocument().addDocumentListener(this.changeDetectorListener);
        this.tfAutoConfigUrl.setInputVerifier(new UrlInputVerifier());
        this.pnlAutoConfig = new OrientablePanel();
        this.pnlAutoConfig.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.insets = DEFAULT_INSETS;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 0;
        this.pnlAutoConfig.add((Component)this.rbAutoConfig, c);
        c.gridy = 1;
        c.anchor = 10;
        c.gridwidth = 1;
        this.pnlAutoConfig.add((Component)lbAutoConfigUrl, c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 2;
        this.pnlAutoConfig.add((Component)this.tfAutoConfigUrl, c);
    }

    private void buildManualConfigPanel() {
        this.buildProtocolPanel();
        this.buildBypassAddressesPanel();
        this.pnlManualConfig = new OrientablePanel();
        this.pnlManualConfig.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.insets = DEFAULT_INSETS;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        this.pnlManualConfig.add((Component)this.rbManualConfig, c);
        c.gridy = 1;
        this.pnlManualConfig.add((Component)this.pnlProtocols, c);
        c.gridy = 2;
        this.pnlManualConfig.add((Component)this.pnlBypassAddresses, c);
    }

    private void buildProtocolPanel() {
        OrientableLabel lbAddress = new OrientableLabel(StringResources.SERVER);
        OrientableLabel lbPort = new OrientableLabel(StringResources.PORT);
        this.tfProxyServerAddress = new GWTextField();
        this.tfProxyServerAddress.getDocument().addDocumentListener(this.changeDetectorListener);
        this.tfProxyServerAddress.setInputVerifier(new UrlInputVerifier());
        this.tfProxyServerPort = new GWTextField(5);
        this.tfProxyServerPort.getDocument().addDocumentListener(this.changeDetectorListener);
        this.tfProxyServerPort.setInputVerifier(new TcpIpPortInputVerifier());
        this.pnlProtocols = new OrientablePanel();
        this.pnlProtocols.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.insets = DEFAULT_INSETS;
        c.gridx = 0;
        c.gridy = 0;
        this.pnlProtocols.add((Component)lbAddress, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 0.9;
        this.pnlProtocols.add((Component)this.tfProxyServerAddress, c);
        ++c.gridx;
        c.weightx = 0.1;
        this.pnlProtocols.add(Box.createRigidArea(new Dimension(20, 0)), c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this.pnlProtocols.add((Component)lbPort, c);
        ++c.gridx;
        this.pnlProtocols.add((Component)this.tfProxyServerPort, c);
    }

    private void buildBypassAddressesPanel() {
        this.tfProxyBypassAddress = new GWTextField();
        this.tfProxyBypassAddress.getDocument().addDocumentListener(new BypassAddressDocumentListener());
        this.lstBypassAdresses = new OrientableList();
        this.lstBypassAdresses.setModel(new DefaultListModel());
        this.lstBypassAdresses.setSelectionMode(0);
        this.lstBypassAdresses.getModel().addListDataListener(this.changeDetectorListener);
        this.lstBypassAdresses.addListSelectionListener(new BypassAddressesListSelectionListener());
        ColoredScrollPane spList = new ColoredScrollPane(this.lstBypassAdresses);
        this.actionAddBypassAddress = new ActionAddBypassAddress();
        this.actionModifyBypassAddress = new ActionModifyBypassAddress();
        this.actionRemoveBypassAddress = new ActionRemoveBypassAddress();
        OrientableButton btnAdd = new OrientableButton(this.actionAddBypassAddress);
        btnAdd.setText(StringResources.ADD);
        OrientableButton btnModify = new OrientableButton(this.actionModifyBypassAddress);
        btnModify.setText(StringResources.MODIFY);
        OrientableButton btnRemove = new OrientableButton(this.actionRemoveBypassAddress);
        btnRemove.setText(StringResources.REMOVE);
        this.pnlBypassAddresses = new OrientablePanel();
        this.pnlBypassAddresses.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.insets = DEFAULT_INSETS;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        this.pnlBypassAddresses.add((Component)spList, c);
        c.gridx = 0;
        c.gridy = 1;
        this.pnlBypassAddresses.add((Component)this.tfProxyBypassAddress, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 0;
        c.weightx = 0.0;
        c.fill = 0;
        this.pnlBypassAddresses.add((Component)btnRemove, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        this.pnlBypassAddresses.add((Component)btnAdd, c);
        c.gridx = 2;
        this.pnlBypassAddresses.add((Component)btnModify, c);
    }

    public void collectValues() {
        EnvironmentOptions options = OptionManager.getInstance().getEnvironmentOptions();
        options.setProxyEnabled(this.cbUseProxy.isSelected());
        options.setProxyAutoConfigured(this.rbAutoConfig.isSelected());
        options.setProxyAutoConfigurationUrl(this.tfAutoConfigUrl.getText());
        options.setProxyManualConfigurationServer(this.tfProxyServerAddress.getText());
        options.setProxyManualConfigurationPort(Integer.parseInt(this.tfProxyServerPort.getText().trim()));
        ArrayList<String> bypassAddresses = new ArrayList<String>();
        for (Object element : ((DefaultListModel)this.lstBypassAdresses.getModel()).toArray()) {
            assert (element instanceof String) : "unexpected element type: " + (element == null ? null : element.getClass().getName());
            bypassAddresses.add((String)element);
        }
        options.setProxyBypassAddressList(bypassAddresses);
        OptionManager.getInstance().setEnvironmentOptions(options);
        Command command = new Command(1820);
        this.controller.processCommand(command);
    }

    public void fireOptionsChanged() {
        EnvironmentOptions options = OptionManager.getInstance().getEnvironmentOptions();
        this.changeDetectorListener.setEnabled(false);
        this.changesListener.setValueSaved();
        this.cbUseProxy.setSelected(options.isProxyEnabled());
        if (options.isProxyAutoConfigured()) {
            this.rbAutoConfig.setSelected(true);
        } else {
            this.rbManualConfig.setSelected(true);
        }
        this.tfAutoConfigUrl.setText(options.getProxyAutoConfigurationUrl());
        this.tfProxyServerAddress.setText(options.getProxyManualConfigurationServer());
        this.tfProxyServerPort.setText(Integer.toString(options.getProxyManualConfigurationPort()));
        ((DefaultListModel)this.lstBypassAdresses.getModel()).clear();
        List<String> bypassAddresses = options.getProxyBypassAddressList();
        for (String url : bypassAddresses) {
            if (Utils.isNullOrEmpty(url)) continue;
            ((DefaultListModel)this.lstBypassAdresses.getModel()).addElement(url);
        }
        this.changeDetectorListener.setEnabled(true);
    }

    public void setOptions(AbstractCloneObject abstractOptions) throws IllegalArgumentException {
        if (!(abstractOptions instanceof EnvironmentOptions)) {
            throw new IllegalArgumentException();
        }
        this.fireOptionsChanged();
    }

    private void handleProxyEnablement(boolean enabled) {
        this.rbAutoConfig.setEnabled(enabled && GWClient.USE_EXTERNAL_HTML_VIEWER());
        this.rbManualConfig.setEnabled(enabled);
        if (enabled) {
            this.handleAutoConfigEnablement(this.rbAutoConfig.isSelected());
        } else {
            this.updateAutoConfigPanel(false);
            this.updateManualConfigPanel(false);
        }
    }

    private void handleAutoConfigEnablement(boolean enabled) {
        this.updateAutoConfigPanel(enabled);
        this.updateManualConfigPanel(!enabled);
    }

    private void updateAutoConfigPanel(boolean enable) {
        this.tfAutoConfigUrl.setEnabled(enable && GWClient.USE_EXTERNAL_HTML_VIEWER());
    }

    private void updateManualConfigPanel(boolean enable) {
        this.tfProxyServerAddress.setEnabled(enable);
        this.tfProxyServerPort.setEnabled(enable);
        this.lstBypassAdresses.setEnabled(enable);
        this.tfProxyBypassAddress.setEnabled(enable);
        this.actionAddBypassAddress.setManualConfigEnabled(enable);
        this.actionModifyBypassAddress.setManualConfigEnabled(enable);
        this.actionRemoveBypassAddress.setManualConfigEnabled(enable);
    }

    private class BypassAddressDocumentListener
    implements DocumentListener {
        private BypassAddressDocumentListener() {
        }

        private void processUpdate(DocumentEvent e) {
            boolean textFine = this.checkText();
            WebOptionPane.this.actionModifyBypassAddress.setTextFine(textFine);
            WebOptionPane.this.actionAddBypassAddress.setTextFine(textFine);
        }

        private boolean checkText() {
            String text = WebOptionPane.this.tfProxyBypassAddress.getText().trim();
            if (text.length() == 0) {
                return false;
            }
            if (!NetUtils.isUrlValid(text) && !NetUtils.isDomainValid(text)) {
                return false;
            }
            return !((DefaultListModel)WebOptionPane.this.lstBypassAdresses.getModel()).contains(text);
        }

        public void changedUpdate(DocumentEvent e) {
            this.processUpdate(e);
        }

        public void insertUpdate(DocumentEvent e) {
            this.processUpdate(e);
        }

        public void removeUpdate(DocumentEvent e) {
            this.processUpdate(e);
        }
    }

    private class BypassAddressesListSelectionListener
    implements ListSelectionListener {
        private BypassAddressesListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                int selectedIndex = WebOptionPane.this.lstBypassAdresses.getSelectedIndex();
                WebOptionPane.this.actionAddBypassAddress.setSelectedItemIndex(selectedIndex);
                WebOptionPane.this.actionModifyBypassAddress.setSelectedItemIndex(selectedIndex);
                WebOptionPane.this.actionRemoveBypassAddress.setSelectedItemIndex(selectedIndex);
                String text = selectedIndex > -1 ? (String)WebOptionPane.this.lstBypassAdresses.getSelectedValue() : "";
                WebOptionPane.this.tfProxyBypassAddress.setText(text);
                logger.debug((Object)("selected: " + text + " (index: " + selectedIndex + ')'));
            }
        }
    }

    private abstract class AbstractActionBypassAddress
    extends AbstractAction {
        protected boolean manualConfigEnabled = false;
        protected int selectedItemIndex = -1;
        protected boolean textFine = false;

        private AbstractActionBypassAddress() {
        }

        public void setManualConfigEnabled(boolean enabled) {
            this.manualConfigEnabled = enabled;
            this.updateState();
        }

        public void setSelectedItemIndex(int index) {
            this.selectedItemIndex = index;
            this.updateState();
        }

        public void setTextFine(boolean fine) {
            this.textFine = fine;
            this.updateState();
        }

        protected abstract void updateState();
    }

    private class ActionRemoveBypassAddress
    extends AbstractActionBypassAddress {
        private ActionRemoveBypassAddress() {
        }

        public void actionPerformed(ActionEvent e) {
            logger.debug((Object)("removing element with index: " + this.selectedItemIndex));
            ((DefaultListModel)WebOptionPane.this.lstBypassAdresses.getModel()).remove(this.selectedItemIndex);
        }

        protected void updateState() {
            this.setEnabled(this.manualConfigEnabled && this.selectedItemIndex > -1);
        }
    }

    private class ActionModifyBypassAddress
    extends AbstractActionBypassAddress {
        private ActionModifyBypassAddress() {
        }

        public void actionPerformed(ActionEvent e) {
            String address = WebOptionPane.this.tfProxyBypassAddress.getText();
            assert (!Utils.isNullOrEmpty(address)) : "address is empty";
            int index = this.selectedItemIndex;
            if (logger.isDebugEnabled()) {
                String currentAddress = (String)((DefaultListModel)WebOptionPane.this.lstBypassAdresses.getModel()).get(index);
                logger.debug((Object)("modifying: " + currentAddress + " > " + address));
            }
            ((DefaultListModel)WebOptionPane.this.lstBypassAdresses.getModel()).remove(index);
            ((DefaultListModel)WebOptionPane.this.lstBypassAdresses.getModel()).add(index, address);
            WebOptionPane.this.lstBypassAdresses.setSelectedIndex(index);
        }

        protected void updateState() {
            this.setEnabled(this.manualConfigEnabled && this.selectedItemIndex > -1 && this.textFine);
        }
    }

    private class ActionAddBypassAddress
    extends AbstractActionBypassAddress {
        private ActionAddBypassAddress() {
        }

        public void actionPerformed(ActionEvent e) {
            String address = WebOptionPane.this.tfProxyBypassAddress.getText();
            assert (!Utils.isNullOrEmpty(address)) : "address is empty";
            ((DefaultListModel)WebOptionPane.this.lstBypassAdresses.getModel()).addElement(address);
            WebOptionPane.this.tfProxyBypassAddress.setText("");
        }

        protected void updateState() {
            this.setEnabled(this.manualConfigEnabled && this.textFine);
        }
    }

    private class ChangeDetectorListener
    implements ItemListener,
    ChangeListener,
    DocumentListener,
    ListDataListener {
        private boolean enabled = false;

        public ChangeDetectorListener(boolean enabled) {
            this.enabled = enabled;
        }

        private void processChange() {
            if (this.enabled) {
                WebOptionPane.this.changesListener.setValueChanged();
            }
        }

        public void stateChanged(ChangeEvent e) {
            this.processChange();
        }

        public void itemStateChanged(ItemEvent e) {
            this.processChange();
        }

        public void changedUpdate(DocumentEvent e) {
            this.processChange();
        }

        public void insertUpdate(DocumentEvent e) {
            this.processChange();
        }

        public void removeUpdate(DocumentEvent e) {
            this.processChange();
        }

        public void contentsChanged(ListDataEvent e) {
            this.processChange();
        }

        public void intervalAdded(ListDataEvent e) {
            this.processChange();
        }

        public void intervalRemoved(ListDataEvent e) {
            this.processChange();
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

