/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.printing;

import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.filechoser.OptionChangesListener;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateChangeEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateValueChangeListener;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.SingleDateSelector;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.fontchooser.FontChooserDialog;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.application.printing.printingcalendar.CalendarPrintManager;
import com.novell.gw.jclient.application.printing.printingcalendar.PrintingCalendarPanelController;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.CalendarForm;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.options.AbstractCloneObject;
import com.novell.gw.jclient.bl.om.options.PrintingOptions;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class PrintingCalendarPanel
extends AbstractOptionPanel
implements MVCView {
    private static Logger logger = Logger.getLogger(PrintingCalendarPanel.class);
    private boolean printing = false;
    private boolean changed = false;
    private JPanel pnlTop;
    private JPanel pnlContent;
    private JPanel pnlDisplay;
    public JCheckBox cbStartDayFromNewPage;
    private SingleDateSelector dsStartingDate;
    private DateValueChangeListener dateListener;
    private JSpinner spinnerDaysCount;
    private JCheckBox cbAllDayEvents;
    private JCheckBox cbAppointment;
    private JCheckBox cbAppointmentStart;
    private JCheckBox cbAppointmentEnd;
    private JCheckBox cbAppointmentFrom;
    private JCheckBox cbAppointmentPlace;
    private JCheckBox cbAppointmentMessage;
    private JCheckBox cbTask;
    private JCheckBox cbTaskStart;
    private JCheckBox cbTaskDue;
    private JCheckBox cbTaskFrom;
    private JCheckBox cbTaskPriority;
    private JCheckBox cbTaskCompletionDate;
    private JCheckBox cbTaskMessage;
    private JCheckBox cbNote;
    private JCheckBox cbNoteStart;
    private JCheckBox cbNoteFrom;
    private JCheckBox cbNoteMessage;
    private Font font;
    private OrientableLabel lbDaysCount = null;
    private OrientableCheckBox cbWeekendDays;
    private OrientableCheckBox cbPrivateCalendarItems;
    private OrientableCheckBox cbCompletedTasks;
    private ChangeDetectorListener changeDetectorListener = new ChangeDetectorListener(false);
    private PrintingOptions printingOptions;
    private int printingType = 0;
    private Calendar gcCurrDay;
    private Calendar gcCurrWeek;
    private Calendar gcCurrMonth;
    private Calendar startingDay;
    private int daysForPrinting;
    private int daysForDailyPrinting = 1;

    public PrintingCalendarPanel(OptionChangesListener theChangesListener, MVCController parentController) {
        super(theChangesListener, parentController);
        this.setName(StringResources.CALENDAR);
    }

    public PrintingCalendarPanel(MVCController parentController) {
        super(new OptionChangesListener(), parentController);
        this.setController(new PrintingCalendarPanelController(this, parentController));
        this.printing = true;
        this.initDates(GWCalendarUtils.getToday());
        this.daysForPrinting = OptionManager.getInstance().getPrintingOptions().getNumberOfDays();
        this.setOptions(OptionManager.getInstance().getPrintingOptions());
        this.build();
    }

    private void buildTopPanel() {
        this.cbStartDayFromNewPage = new ChangeReportingCheckBox(StringResources.START_DAY_FROM_NEW_PAGE);
        OrientableLabel lbStartingDate = null;
        if (this.printing) {
            assert (this.gcCurrDay != null) : "this.gcCurrDay not initialized";
            lbStartingDate = new OrientableLabel(StringResources.STARTING_DATE_C);
            this.dsStartingDate = new SingleDateSelector();
            this.dsStartingDate.setIcon(ImageResources.ICON_ACT_VIEW_CALENDAR);
            this.dsStartingDate.setDate(this.gcCurrDay);
            this.dateListener = new DateChangeListener();
            this.dsStartingDate.addDateChangeListener(this.dateListener);
        }
        this.lbDaysCount = new OrientableLabel(StringResources.NUMBER_OF_DAYS_C);
        this.spinnerDaysCount = new JSpinner(new SpinnerNumberModel(1, 1, 31, 1));
        this.spinnerDaysCount.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        this.spinnerDaysCount.setComponentOrientation(UIUtils.getComponentOrientation());
        this.spinnerDaysCount.addChangeListener(this.changeDetectorListener);
        this.spinnerDaysCount.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PrintingCalendarPanel.this.daysForPrinting = (Integer)PrintingCalendarPanel.this.spinnerDaysCount.getValue();
                PrintingCalendarPanel.this.daysForDailyPrinting = (Integer)PrintingCalendarPanel.this.spinnerDaysCount.getValue();
            }
        });
        OrientablePanel pnlBottom = new OrientablePanel();
        OrientablePanel pnlSpinner = new OrientablePanel();
        pnlSpinner.setLayout(new BoxLayout(pnlSpinner, 3));
        this.lbDaysCount.setAlignmentX(0.0f);
        this.spinnerDaysCount.setAlignmentX(0.0f);
        pnlSpinner.add(this.lbDaysCount);
        pnlSpinner.add(this.spinnerDaysCount);
        pnlSpinner.add(Box.createVerticalGlue());
        pnlBottom.setLayout(new BoxLayout(pnlBottom, 2));
        if (this.printing) {
            OrientablePanel pnlDateSelector = new OrientablePanel();
            pnlDateSelector.setLayout(new BoxLayout(pnlDateSelector, 3));
            lbStartingDate.setAlignmentX(0.0f);
            pnlDateSelector.add(lbStartingDate);
            pnlDateSelector.add(this.dsStartingDate);
            pnlBottom.add(pnlDateSelector);
            pnlBottom.add(Box.createHorizontalGlue());
        }
        pnlBottom.add(pnlSpinner);
        pnlBottom.add(Box.createHorizontalGlue());
        this.pnlTop = new OrientablePanel();
        this.pnlTop.setLayout(new BoxLayout(this.pnlTop, 3));
        this.cbStartDayFromNewPage.setAlignmentX(0.0f);
        pnlBottom.setAlignmentX(0.0f);
        this.pnlTop.add(this.cbStartDayFromNewPage);
        this.pnlTop.add(pnlBottom);
    }

    private void buildContentPanel() {
        PrintingOptions options = OptionManager.getInstance().getPrintingOptions();
        this.cbAllDayEvents = new ChangeReportingCheckBox(StringResources.ALL_DAY_EVENTS, options.isAllDayEventPrinted());
        this.cbAppointment = new ChangeReportingCheckBox();
        UIUtils.setText(this.cbAppointment, StringResources.APPOINTMENTS);
        this.cbAppointment.setSelected(options.isAppointmentPrinted());
        this.cbAppointmentStart = new ChangeReportingCheckBox(StringResources.START_TIME, options.isAppointmentStartPrinted());
        this.cbAppointmentEnd = new ChangeReportingCheckBox(StringResources.END_TIME, options.isAppointmentEndPrinted());
        this.cbAppointmentFrom = new ChangeReportingCheckBox(StringResources.FROM, options.isAppointmentFromPrinted());
        this.cbAppointmentPlace = new ChangeReportingCheckBox(StringResources.PLACE, options.isAppointmentPlacePrinted());
        this.cbAppointmentMessage = new ChangeReportingCheckBox(StringResources.MESSAGE, options.isAppointmentMessagePrinted());
        this.cbAppointment.addItemListener(new PrimaryCheckBoxListener(new Component[]{this.cbAppointmentEnd, this.cbAppointmentFrom, this.cbAppointmentMessage, this.cbAppointmentPlace, this.cbAppointmentStart}, this.cbAppointment.isSelected()));
        this.cbTask = new ChangeReportingCheckBox();
        UIUtils.setText(this.cbTask, StringResources.TASKS);
        this.cbTask.setSelected(options.isTaskPrinted());
        this.cbTaskPriority = new ChangeReportingCheckBox(StringResources.PRIORITY, options.isTaskPriorityPrinted());
        this.cbTaskStart = new ChangeReportingCheckBox(StringResources.START_DATE, options.isTaskStartPrinted());
        this.cbTaskDue = new ChangeReportingCheckBox(StringResources.DUE_DATE, options.isTaskDuePrinted());
        this.cbTaskCompletionDate = new ChangeReportingCheckBox(StringResources.COMPLETION_DATE, options.isTaskCompletionDatePrinted());
        this.cbTaskFrom = new ChangeReportingCheckBox(StringResources.FROM, options.isTaskFromPrinted());
        this.cbTaskMessage = new ChangeReportingCheckBox(StringResources.MESSAGE, options.isTaskMessagePrinted());
        this.cbTask.addItemListener(new PrimaryCheckBoxListener(new Component[]{this.cbTaskPriority, this.cbTaskStart, this.cbTaskDue, this.cbTaskCompletionDate, this.cbTaskFrom, this.cbTaskMessage}, this.cbTask.isSelected()));
        this.cbNote = new ChangeReportingCheckBox();
        UIUtils.setText(this.cbNote, StringResources.NOTES);
        this.cbNote.setSelected(options.isNotePrinted());
        this.cbNoteStart = new ChangeReportingCheckBox(StringResources.START_DATE, options.isNoteStartPrinted());
        this.cbNoteFrom = new ChangeReportingCheckBox(StringResources.FROM, options.isNoteFromPrinted());
        this.cbNoteMessage = new ChangeReportingCheckBox(StringResources.MESSAGE, options.isNoteMessagePrinted());
        this.cbNote.addItemListener(new PrimaryCheckBoxListener(new Component[]{this.cbNoteFrom, this.cbNoteMessage, this.cbNoteStart}, this.cbNote.isSelected()));
        OrientableButton btnFont = new OrientableButton(new ActionChooseFont());
        btnFont.setText(StringResources.FONT_D);
        this.pnlContent = new OrientablePanel();
        this.pnlContent.setBorder(BorderFactory.createTitledBorder(StringResources.CONTENT));
        this.pnlContent.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.weightx = 0.25;
        Insets defaultInsets = new Insets(0, 0, 0, 0);
        Insets indentedInsets = new Insets(0, 15, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.insets = defaultInsets;
        this.pnlContent.add((Component)this.cbAllDayEvents, c);
        c.gridx = 1;
        c.gridy = 0;
        c.insets = defaultInsets;
        this.pnlContent.add((Component)this.cbAppointment, c);
        ++c.gridy;
        c.insets = indentedInsets;
        this.pnlContent.add((Component)this.cbAppointmentStart, c);
        ++c.gridy;
        this.pnlContent.add((Component)this.cbAppointmentEnd, c);
        ++c.gridy;
        this.pnlContent.add((Component)this.cbAppointmentPlace, c);
        ++c.gridy;
        this.pnlContent.add((Component)this.cbAppointmentFrom, c);
        ++c.gridy;
        this.pnlContent.add((Component)this.cbAppointmentMessage, c);
        c.gridx = 2;
        c.gridy = 0;
        c.insets = defaultInsets;
        this.pnlContent.add((Component)this.cbTask, c);
        ++c.gridy;
        c.insets = indentedInsets;
        this.pnlContent.add((Component)this.cbTaskPriority, c);
        ++c.gridy;
        this.pnlContent.add((Component)this.cbTaskStart, c);
        ++c.gridy;
        this.pnlContent.add((Component)this.cbTaskDue, c);
        ++c.gridy;
        this.pnlContent.add((Component)this.cbTaskCompletionDate, c);
        ++c.gridy;
        this.pnlContent.add((Component)this.cbTaskFrom, c);
        ++c.gridy;
        this.pnlContent.add((Component)this.cbTaskMessage, c);
        c.gridx = 3;
        c.gridy = 0;
        c.insets = defaultInsets;
        this.pnlContent.add((Component)this.cbNote, c);
        ++c.gridy;
        c.insets = indentedInsets;
        this.pnlContent.add((Component)this.cbNoteFrom, c);
        ++c.gridy;
        this.pnlContent.add((Component)this.cbNoteStart, c);
        ++c.gridy;
        this.pnlContent.add((Component)this.cbNoteMessage, c);
        ++c.gridy;
        c.gridheight = 0;
        c.anchor = 26;
        this.pnlContent.add((Component)btnFont, c);
    }

    private void buildDisplayPanel() {
        PrintingOptions options = OptionManager.getInstance().getPrintingOptions();
        this.cbWeekendDays = new ChangeReportingCheckBox(StringResources.WEEKEND_DAYS, options.isWeekendDaysPrinted());
        this.cbPrivateCalendarItems = new ChangeReportingCheckBox(StringResources.PRIVATE_CALENDAR_ITEMS, options.isPrivateCalendarItemsPrinted());
        this.cbCompletedTasks = new ChangeReportingCheckBox(StringResources.COMPLETED_TASKS, options.isCompletedTasksPrinted());
        this.pnlDisplay = new OrientablePanel();
        this.pnlDisplay.setBorder(BorderFactory.createTitledBorder(StringResources.DISPLAY));
        this.pnlDisplay.setLayout(new GridLayout(1, 3));
        this.pnlDisplay.add(this.cbWeekendDays);
        this.pnlDisplay.add(this.cbPrivateCalendarItems);
        this.pnlDisplay.add(this.cbCompletedTasks);
    }

    protected void build() {
        if (!this.printing) {
            if (OS.isNimbusLAF()) {
                this.setBorder(BorderFactory.createTitledBorder(StringResources.CALENDAR_PRINTING));
            } else {
                Border border = BorderFactory.createEtchedBorder();
                border = BorderFactory.createTitledBorder(border, StringResources.CALENDAR_PRINTING);
                this.setBorder(border);
            }
        }
        this.buildTopPanel();
        this.buildContentPanel();
        this.buildDisplayPanel();
        this.changeDetectorListener.setEnabled(true);
        Insets insets = this.pnlContent.getBorder().getBorderInsets(this.pnlContent);
        this.pnlTop.setBorder(BorderFactory.createEmptyBorder(insets.bottom, insets.left, insets.bottom, insets.right));
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.pnlTop, c);
        ++c.gridy;
        this.add((Component)this.pnlContent, c);
        ++c.gridy;
        c.weighty = 1.0;
        this.add((Component)this.pnlDisplay, c);
        Font contentFont = OptionManager.getInstance().getPrintingOptions().getCalendarContentFont();
        this.font = contentFont == null ? PrintingCalendarPanel.getDefaultFont() : contentFont;
    }

    public void collectValues() {
        if (this.printing && !this.changed) {
            return;
        }
        this.printingOptions.setDayOnNewPage(this.cbStartDayFromNewPage.isSelected());
        this.printingOptions.setNumberOfDays((Integer)this.spinnerDaysCount.getValue());
        this.printingOptions.setAllDayEventPrinted(this.cbAllDayEvents.isSelected());
        this.printingOptions.setAppointmentPrinted(this.cbAppointment.isSelected());
        this.printingOptions.setAppointmentStartPrinted(this.cbAppointmentStart.isSelected());
        this.printingOptions.setAppointmentEndPrinted(this.cbAppointmentEnd.isSelected());
        this.printingOptions.setAppointmentFromPrinted(this.cbAppointmentFrom.isSelected());
        this.printingOptions.setAppointmentPlacePrinted(this.cbAppointmentPlace.isSelected());
        this.printingOptions.setAppointmentMessagePrinted(this.cbAppointmentMessage.isSelected());
        this.printingOptions.setTaskPrinted(this.cbTask.isSelected());
        this.printingOptions.setTaskStartPrinted(this.cbTaskStart.isSelected());
        this.printingOptions.setTaskDuePrinted(this.cbTaskDue.isSelected());
        this.printingOptions.setTaskFromPrinted(this.cbTaskFrom.isSelected());
        this.printingOptions.setTaskPriorityPrinted(this.cbTaskPriority.isSelected());
        this.printingOptions.setTaskCompletionDatePrinted(this.cbTaskCompletionDate.isSelected());
        this.printingOptions.setTaskMessagePrinted(this.cbTaskMessage.isSelected());
        this.printingOptions.setNotePrinted(this.cbNote.isSelected());
        this.printingOptions.setNoteStartPrinted(this.cbNoteStart.isSelected());
        this.printingOptions.setNoteFromPrinted(this.cbNoteFrom.isSelected());
        this.printingOptions.setNoteMessagePrinted(this.cbNoteMessage.isSelected());
        this.printingOptions.setCalendarContentFont(this.font);
        this.printingOptions.setWeekendDaysPrinted(this.cbWeekendDays.isSelected());
        this.printingOptions.setPrivateCalendarItemsPrinted(this.cbPrivateCalendarItems.isSelected());
        this.printingOptions.setCompletedTasksPrinted(this.cbCompletedTasks.isSelected());
    }

    public void fireOptionsChanged() {
        this.changeDetectorListener.setEnabled(false);
        this.changesListener.setValueSaved();
        this.cbStartDayFromNewPage.setSelected(this.printingOptions.isDayOnNewPage());
        this.spinnerDaysCount.setValue(this.printingOptions.getNumberOfDays());
        this.cbAllDayEvents.setSelected(this.printingOptions.isAllDayEventPrinted());
        this.cbAppointment.setSelected(this.printingOptions.isAppointmentPrinted());
        this.cbAppointmentStart.setSelected(this.printingOptions.isAppointmentStartPrinted());
        this.cbAppointmentEnd.setSelected(this.printingOptions.isAppointmentEndPrinted());
        this.cbAppointmentFrom.setSelected(this.printingOptions.isAppointmentFromPrinted());
        this.cbAppointmentPlace.setSelected(this.printingOptions.isAppointmentPlacePrinted());
        this.cbAppointmentMessage.setSelected(this.printingOptions.isAppointmentMessagePrinted());
        this.cbTask.setSelected(this.printingOptions.isTaskPrinted());
        this.cbTaskStart.setSelected(this.printingOptions.isTaskStartPrinted());
        this.cbTaskDue.setSelected(this.printingOptions.isTaskDuePrinted());
        this.cbTaskFrom.setSelected(this.printingOptions.isTaskFromPrinted());
        this.cbTaskPriority.setSelected(this.printingOptions.isTaskPriorityPrinted());
        this.cbTaskCompletionDate.setSelected(this.printingOptions.isTaskCompletionDatePrinted());
        this.cbTaskMessage.setSelected(this.printingOptions.isTaskMessagePrinted());
        this.cbNote.setSelected(this.printingOptions.isNotePrinted());
        this.cbNoteStart.setSelected(this.printingOptions.isNoteStartPrinted());
        this.cbNoteFrom.setSelected(this.printingOptions.isNoteFromPrinted());
        this.cbNoteMessage.setSelected(this.printingOptions.isNotePrinted());
        this.font = this.printingOptions.getCalendarContentFont();
        this.cbWeekendDays.setSelected(this.printingOptions.isWeekendDaysPrinted());
        this.cbPrivateCalendarItems.setSelected(this.printingOptions.isPrivateCalendarItemsPrinted());
        this.cbCompletedTasks.setSelected(this.printingOptions.isCompletedTasksPrinted());
        this.changeDetectorListener.setEnabled(true);
    }

    public void saveOptions() {
        if (!this.printing) {
            throw new IllegalStateException("not in printing mode");
        }
        PrintingOptions options = OptionManager.getInstance().getPrintingOptions();
        options.setAllDayEventPrinted(this.cbAllDayEvents.isSelected());
        options.setAppointmentPrinted(this.cbAppointment.isSelected());
        options.setAppointmentEndPrinted(this.cbAppointmentEnd.isSelected());
        options.setAppointmentFromPrinted(this.cbAppointmentFrom.isSelected());
        options.setAppointmentMessagePrinted(this.cbAppointmentMessage.isSelected());
        options.setAppointmentPlacePrinted(this.cbAppointmentPlace.isSelected());
        options.setAppointmentStartPrinted(this.cbAppointmentStart.isSelected());
        options.setTaskPrinted(this.cbTask.isSelected());
        options.setTaskCompletionDatePrinted(this.cbTaskCompletionDate.isSelected());
        options.setTaskDuePrinted(this.cbTaskDue.isSelected());
        options.setTaskFromPrinted(this.cbTaskFrom.isSelected());
        options.setTaskMessagePrinted(this.cbTaskMessage.isSelected());
        options.setTaskStartPrinted(this.cbTaskStart.isSelected());
        options.setTaskPriorityPrinted(this.cbTaskPriority.isSelected());
        options.setNotePrinted(this.cbNote.isSelected());
        options.setNoteFromPrinted(this.cbNoteFrom.isSelected());
        options.setNoteMessagePrinted(this.cbNoteMessage.isSelected());
        options.setNoteStartPrinted(this.cbNoteStart.isSelected());
        options.setWeekendDaysPrinted(this.cbWeekendDays.isSelected());
        options.setPrivateCalendarItemsPrinted(this.cbPrivateCalendarItems.isSelected());
        options.setCompletedTasksPrinted(this.cbCompletedTasks.isSelected());
        this.printingOptions.setCalendarContentFont(this.font);
        OptionManager.getInstance().setPrintingOptions(options);
        this.changeDetectorListener.setEnabled(true);
        this.changed = false;
    }

    public void setOptions(AbstractCloneObject theAbstractOptions) throws IllegalArgumentException {
        if (!(theAbstractOptions instanceof PrintingOptions)) {
            throw new IllegalArgumentException();
        }
        this.printingOptions = (PrintingOptions)theAbstractOptions;
    }

    public MVCController getController() {
        return this.controller;
    }

    public Object getMVCModel() {
        return null;
    }

    public void setController(MVCController controller) {
        this.controller = controller;
    }

    public void setMVCModel(Object theModel) {
        this.changeDetectorListener.setEnabled(false);
        if (theModel instanceof Integer) {
            this.printingType = (Integer)theModel;
            this.daysForPrinting = this.daysForDailyPrinting;
            this.spinnerDaysCount.setValue(this.daysForPrinting);
            if (this.printingType == 0) {
                this.dsStartingDate.setDate(this.gcCurrDay);
                this.lbDaysCount.setText(StringResources.NUMBER_OF_DAYS_C);
            } else if (this.printingType == 1) {
                this.dsStartingDate.setDate(this.gcCurrWeek);
                this.lbDaysCount.setText(StringResources.NUMBER_OF_WEEKS_C);
            } else if (this.printingType == 2) {
                this.dsStartingDate.setDate(this.gcCurrMonth);
                this.lbDaysCount.setText(StringResources.NUMBER_OF_MONTHS_C);
                Calendar gc = (Calendar)this.gcCurrMonth.clone();
                gc.add(2, 1);
                gc.add(5, -1);
                this.updateCalendarFormStartingDay(this.gcCurrMonth);
            }
        } else if (theModel instanceof Calendar) {
            Calendar gc = (Calendar)theModel;
            this.initDates((Calendar)gc.clone());
            this.daysForPrinting = 1;
            this.spinnerDaysCount.setValue(new Integer(1));
        }
        this.changeDetectorListener.setEnabled(true);
    }

    public int getPrintingType() {
        return this.printingType;
    }

    private void initDates(Calendar initDate) {
        this.startingDay = Calendar.getInstance();
        this.startingDay.setTime(initDate.getTime());
        this.gcCurrDay = initDate;
        this.gcCurrWeek = initDate;
        this.gcCurrMonth = initDate;
    }

    public boolean isStartDayFromNewPage() {
        return this.cbStartDayFromNewPage.isSelected();
    }

    public Calendar getCurrentDay() {
        return this.gcCurrDay;
    }

    public Calendar getCurrentWeek() {
        return this.gcCurrWeek;
    }

    public Calendar getCurrentMonth() {
        return this.gcCurrMonth;
    }

    public Calendar getStartingDay() {
        return (Calendar)this.startingDay.clone();
    }

    public void setStartingDay(Calendar startingDay) {
        this.startingDay = startingDay;
    }

    public int getDaysForPrinting() {
        return this.daysForPrinting;
    }

    public boolean hasAllDayEvents() {
        return this.cbAllDayEvents.isSelected();
    }

    public boolean hasAppointments() {
        return this.cbAppointment.isSelected();
    }

    public boolean hasAppointmentsStart() {
        return this.cbAppointmentStart.isSelected();
    }

    public boolean hasAppointmentsEnd() {
        return this.cbAppointmentEnd.isSelected();
    }

    public boolean hasAppointmentsFrom() {
        return this.cbAppointmentFrom.isSelected();
    }

    public boolean hasAppointmentsPlace() {
        return this.cbAppointmentPlace.isSelected();
    }

    public boolean hasAppointmentsMessage() {
        return this.cbAppointmentMessage.isSelected();
    }

    public boolean hasTasks() {
        return this.cbTask.isSelected();
    }

    public boolean hasTasksStart() {
        return this.cbTaskStart.isSelected();
    }

    public boolean hasTasksDue() {
        return this.cbTaskDue.isSelected();
    }

    public boolean hasTasksFrom() {
        return this.cbTaskFrom.isSelected();
    }

    public boolean hasTasksPriority() {
        return this.cbTaskPriority.isSelected();
    }

    public boolean hasTasksCompletionDate() {
        return this.cbTaskCompletionDate.isSelected();
    }

    public boolean hasTasksMessage() {
        return this.cbTaskMessage.isSelected();
    }

    public boolean hasNotes() {
        return this.cbNote.isSelected();
    }

    public boolean hasNotesStart() {
        return this.cbNoteStart.isSelected();
    }

    public boolean hasNotesFrom() {
        return this.cbNoteFrom.isSelected();
    }

    public boolean hasNotesMessage() {
        return this.cbNoteMessage.isSelected();
    }

    public boolean hasWeekendDays() {
        return this.cbWeekendDays.isSelected();
    }

    public boolean hasPrivateCalendarItems() {
        return this.cbPrivateCalendarItems.isSelected();
    }

    public boolean hasCompletedTasks() {
        return this.cbCompletedTasks.isSelected();
    }

    public void updateCalendarFormStartingDay(Calendar updatedGcCurrDay) {
        if (this.getParent() instanceof CalendarPrintManager) {
            CalendarPrintManager cpm = (CalendarPrintManager)this.getParent();
            for (int i = 0; i < cpm.getLstPrintingFormsSize(); ++i) {
                ((CalendarForm)cpm.getLstPrintingFormsItem(i)).setStartingDay(updatedGcCurrDay);
            }
        }
    }

    public static Font getDefaultFont() {
        return new Font(PLAFChanger.getFontName(), 0, 12);
    }

    private class DateChangeListener
    implements DateValueChangeListener {
        private DateChangeListener() {
        }

        public void valueChanged(DateChangeEvent e) {
            Date newTime = e.getDate().getTime();
            PrintingCalendarPanel panel = PrintingCalendarPanel.this;
            int countOfItems = panel.getDaysForPrinting();
            if (panel.printingType == 0) {
                panel.gcCurrDay.setTime(newTime);
                panel.daysForPrinting = countOfItems;
                PrintingCalendarPanel.this.updateCalendarFormStartingDay(panel.gcCurrDay);
            } else if (panel.printingType == 1) {
                panel.gcCurrWeek.setTime(newTime);
                panel.gcCurrWeek = GWCalendarUtils.getDateForDayOfWeek(panel.gcCurrWeek, 1);
                panel.daysForPrinting = countOfItems;
            } else if (panel.printingType == 2) {
                panel.gcCurrMonth.setTime(newTime);
                panel.daysForPrinting = countOfItems;
                panel.spinnerDaysCount.setValue(new Integer(panel.daysForPrinting));
                PrintingCalendarPanel.this.updateCalendarFormStartingDay(panel.gcCurrMonth);
            }
            panel.startingDay.setTime(newTime);
        }
    }

    private class PrimaryCheckBoxListener
    implements ItemListener {
        private Component[] dependantComponents;

        public PrimaryCheckBoxListener(Component[] dependantComponents) {
            this.dependantComponents = dependantComponents;
            this.updateDependantComponents(false);
        }

        public PrimaryCheckBoxListener(Component[] dependantComponents, boolean isParentSelected) {
            this.dependantComponents = dependantComponents;
            this.updateDependantComponents(isParentSelected);
        }

        public void itemStateChanged(ItemEvent e) {
            this.updateDependantComponents(e.getStateChange() == 1);
        }

        private void updateDependantComponents(boolean enable) {
            for (Component component : this.dependantComponents) {
                component.setEnabled(enable);
            }
        }
    }

    private class ChangeReportingCheckBox
    extends OrientableCheckBox {
        public ChangeReportingCheckBox() {
            assert (PrintingCalendarPanel.this.changeDetectorListener != null) : "changeDetectorItemListener not initialized";
            this.addItemListener(PrintingCalendarPanel.this.changeDetectorListener);
        }

        public ChangeReportingCheckBox(Action a) {
            super(a);
            assert (PrintingCalendarPanel.this.changeDetectorListener != null) : "changeDetectorItemListener not initialized";
            this.addItemListener(PrintingCalendarPanel.this.changeDetectorListener);
        }

        public ChangeReportingCheckBox(String text) {
            super(text);
            assert (PrintingCalendarPanel.this.changeDetectorListener != null) : "changeDetectorItemListener not initialized";
            this.addItemListener(PrintingCalendarPanel.this.changeDetectorListener);
        }

        public ChangeReportingCheckBox(String text, boolean isSelected) {
            super(text);
            assert (PrintingCalendarPanel.this.changeDetectorListener != null) : "changeDetectorItemListener not initialized";
            this.addItemListener(PrintingCalendarPanel.this.changeDetectorListener);
            this.setSelected(isSelected);
        }
    }

    private class ChangeDetectorListener
    implements ItemListener,
    ChangeListener {
        private boolean enabled = false;

        public ChangeDetectorListener(boolean enabled) {
            this.enabled = enabled;
        }

        private void processChange() {
            if (this.enabled) {
                PrintingCalendarPanel.this.changesListener.setValueChanged();
                PrintingCalendarPanel.this.changed = true;
            }
        }

        public void stateChanged(ChangeEvent e) {
            this.processChange();
        }

        public void itemStateChanged(ItemEvent e) {
            this.processChange();
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    private class ActionChooseFont
    extends AbstractAction {
        private ActionChooseFont() {
        }

        public void actionPerformed(ActionEvent e) {
            PrintingCalendarPanel panel = PrintingCalendarPanel.this;
            assert (panel.font != null) : "font is null";
            Window window = ControlsUtils.getWindowForComponent(panel);
            FontChooserDialog fontChooserDialog = new FontChooserDialog((Dialog)window);
            fontChooserDialog.setModal(true);
            UIUtils.centerWindow((Window)fontChooserDialog, window);
            fontChooserDialog.setFont(panel.font);
            fontChooserDialog.pack();
            fontChooserDialog.setVisible(true);
            Font font = fontChooserDialog.getChoosenFont();
            if (font != null && !font.equals(panel.font)) {
                logger.debug((Object)("updating font to: " + font));
                panel.font = font;
                PrintingCalendarPanel.this.printingOptions.setCalendarContentFont(PrintingCalendarPanel.this.font);
                PrintingCalendarPanel.this.changesListener.setValueChanged();
                PrintingCalendarPanel.this.changed = true;
            }
        }
    }
}

