/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.security;

import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.application.controls.addressbook.SearchEvent;
import com.novell.gw.jclient.application.controls.filechoser.OptionChangesListener;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.frames.options.compose.security.AbstractAddressListOptionPanel;
import com.novell.gw.jclient.application.frames.options.compose.security.NotifyTableModel;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.options.AbstractCloneObject;
import com.novell.gw.notification.NotifySubscribeEntry;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class NotifyOptionsPanel
extends AbstractAddressListOptionPanel {
    private NotifyTableModel model;
    private JCheckBox cbSubscribeToAlarms;
    private JCheckBox cbSubscribeToNotification;
    private JPanel pnlNotificationOptions;

    public NotifyOptionsPanel(OptionChangesListener theChangesListener, MVCController theParentController, String userGuid) {
        super(theChangesListener, theParentController, userGuid);
        this.model = new NotifyTableModel(this.userGuid);
        this.tblAddressList.setModel(this.model);
        this.pnlNotificationOptions = new OrientablePanel(new GridBagLayout());
        this.cbSubscribeToAlarms = new JMnemonicCheckBox(StringResources.SUBSCRIBE_TO_ALARMS);
        this.cbSubscribeToNotification = new JMnemonicCheckBox(StringResources.SUBSCRIBE_TO_NOTIFICATION);
        this.lblTableTitle.setText(StringResources.NOTIFICATION_LIST_C);
        this.strBorderTitle = StringResources.NOTIFY_OPTIONS_FOR;
        this.pnlNotificationOptions.setBorder(new TitledBorder(StringResources.NOTIFY_OPTIONS_FOR));
        this.cbSubscribeToAlarms.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ((NotifyOptionsPanel)NotifyOptionsPanel.this).getNotifySubscribeEntry().options.setSubscribeAlarms(NotifyOptionsPanel.this.cbSubscribeToAlarms.isSelected());
            }
        });
        this.cbSubscribeToNotification.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ((NotifyOptionsPanel)NotifyOptionsPanel.this).getNotifySubscribeEntry().options.setSubscribeNotify(NotifyOptionsPanel.this.cbSubscribeToNotification.isSelected());
            }
        });
        this.buildUI();
        this.processItemSelection();
    }

    void buildUI() {
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.anchor = 23;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.createAddressListPanel(), constraints);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.anchor = 23;
        constraints.fill = 0;
        constraints.insets = new Insets(10, 10, 5, 10);
        this.pnlNotificationOptions.add((Component)this.cbSubscribeToAlarms, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.anchor = 23;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 10, 10, 10);
        this.pnlNotificationOptions.add((Component)this.cbSubscribeToNotification, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.anchor = 23;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.pnlNotificationOptions, constraints);
    }

    void processItemSelection() {
        boolean isEnabled;
        int index = this.tblAddressList.getSelectedRow();
        if (index != -1) {
            NotifySubscribeEntry notifySubscribeEntry = this.model.getNotifySubscribeEntry(index);
            this.cbSubscribeToAlarms.setSelected(notifySubscribeEntry.options.hasSubscribeAlarms());
            this.cbSubscribeToNotification.setSelected(notifySubscribeEntry.options.hasSubscribeNotify());
            String user = EngineCommandManager.getUserInfo().getName();
            this.btnRemoveUser.setEnabled(!this.model.getNotifySubscribeEntry(this.tblAddressList.getSelectedRow()).getUser().equals(user));
        }
        boolean bl = isEnabled = index != -1;
        if (this.cbSubscribeToAlarms != null) {
            this.cbSubscribeToAlarms.setEnabled(isEnabled);
        }
        if (this.cbSubscribeToNotification != null) {
            this.cbSubscribeToNotification.setEnabled(isEnabled);
        }
    }

    void removeUser() {
        int nSelRow = this.tblAddressList.getSelectedRow();
        if (this.model.removeContact(this.tblAddressList.getSelectedRow())) {
            int nCount = this.tblAddressList.getRowCount();
            if (nSelRow >= nCount) {
                --nSelRow;
            }
            if (nSelRow >= 0) {
                this.tblAddressList.setRowSelectionInterval(nSelRow, nSelRow);
            }
        }
    }

    void addContacts(List contacts) {
        this.model.addContacts(contacts);
        IAddressable addressable = (IAddressable)contacts.get(0);
        int index = this.model.indexOf(addressable);
        if (index >= 0) {
            this.tblAddressList.setRowSelectionInterval(index, index);
        }
    }

    void search(SearchEvent e) {
        boolean bBad = true;
        IAddressable addressable = e.getFoundContact();
        if (addressable != null && addressable instanceof IContact) {
            ArrayList<IAddressable> list = new ArrayList<IAddressable>(1);
            list.add(addressable);
            this.model.addContacts(list);
            int index = this.model.indexOf(addressable);
            if (index > 0) {
                this.tblAddressList.setRowSelectionInterval(index, index);
            }
            bBad = false;
        }
        if (bBad) {
            JOptionPane.showMessageDialog(null, StringResources.formatString(StringResources.IS_NOT_A_VALID_GROUPWISE_USER, this.tfName.getText(), this.tfName.getText()), StringResources.NOVELL_GROUPWISE, 2);
        }
    }

    protected void build() {
    }

    public void collectValues() {
        this.saveChanges();
    }

    public void fireOptionsChanged() {
    }

    public void setOptions(AbstractCloneObject theAbstractOptions) throws IllegalArgumentException {
    }

    private NotifySubscribeEntry getNotifySubscribeEntry() {
        int index = this.tblAddressList.getSelectedRow();
        return this.model.getNotifySubscribeEntry(index);
    }

    public void saveChanges() {
        this.model.saveChanges();
    }
}

