/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.security;

import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableTabbedPane;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.frames.options.compose.ComposeOption;
import com.novell.gw.jclient.application.frames.options.compose.security.ChangePasswordPane;
import com.novell.gw.jclient.application.frames.options.compose.security.NotifyOptionsPanel;
import com.novell.gw.jclient.application.frames.options.compose.security.ProxyAccessPane;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SecurityOptionsPane
extends ComposeOption {
    public static final String PASS = "PASS";
    private ProxyAccessPane pnlProxy;
    private ChangePasswordPane pnlPassword;
    private String userGuid;
    private AbstractOptionPanel notifyOptionsPanel;

    public SecurityOptionsPane(String theID, MVCController theParentController, String userGuid) {
        super(theID, theParentController);
        this.userGuid = userGuid;
    }

    public void prepareForShow() {
        this.build();
        this.changesListener.setValueSaved();
    }

    protected void build() {
        super.build();
        this.setLayout(new BorderLayout());
        this.pnlProxy = new ProxyAccessPane(this.changesListener, this.getController(), this.userGuid);
        this.notifyOptionsPanel = new NotifyOptionsPanel(this.changesListener, this.getController(), this.userGuid);
        this.setLayout(new BorderLayout());
        OrientableTabbedPane tabSecurity = new OrientableTabbedPane();
        boolean isPasswordSet = GWCommandManager.getInstance(this.userGuid).isPasswordSet();
        this.pnlPassword = new ChangePasswordPane(true, !isPasswordSet, this.userGuid, this.getController(), this.changesListener);
        tabSecurity.add(StringResources.PASSWORD, new OrientableScrollPane(this.pnlPassword));
        this.pnlPassword.registerTabbedPaneListener(tabSecurity);
        tabSecurity.add(StringResources.NOTIFY, new OrientableScrollPane(this.notifyOptionsPanel));
        tabSecurity.add(StringResources.PROXY_ACCESS, new OrientableScrollPane(this.pnlProxy));
        tabSecurity.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Component component = ((JScrollPane)((JTabbedPane)e.getSource()).getSelectedComponent()).getViewport().getComponent(0);
                if (!(component instanceof AbstractOptionPanel)) {
                    return;
                }
                AbstractOptionPanel option = (AbstractOptionPanel)((JScrollPane)((JTabbedPane)e.getSource()).getSelectedComponent()).getViewport().getComponent(0);
                boolean b = SecurityOptionsPane.this.changesListener.valueHasChanged();
                option.prepareForShow();
                if (!b) {
                    SecurityOptionsPane.this.changesListener.setValueSaved();
                }
            }
        });
        this.add((Component)tabSecurity, "Center");
    }

    public void save() {
        this.pnlPassword.saveChanges();
        if (this.pnlProxy.isPrepared) {
            this.pnlProxy.saveChanges();
        }
        if (this.notifyOptionsPanel.isPrepared) {
            this.notifyOptionsPanel.collectValues();
        }
    }

    public ChangePasswordPane getPnlPassword() {
        return this.pnlPassword;
    }

    public void putOptionValuesIntoFields() {
    }

    public void collectValues() {
    }
}

