/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.send;

import com.appframework.mvc.MVCController;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.jclient.api.enums.ItemType;
import com.novell.gw.jclient.application.controls.filechoser.OptionChangesListener;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.frames.options.compose.send.AbstractItemOptionsPanel;
import com.novell.gw.jclient.application.frames.options.compose.send.GWExpandButton;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.items.sendoptions.MailSendOptions;
import com.novell.gw.jclient.bl.om.items.sendoptions.Notification;
import com.novell.gw.jclient.bl.om.options.AbstractCloneObject;
import com.novell.gw.jclient.bl.om.options.ItemSendOptions;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class MailTrackingOptionsPanel
extends AbstractItemOptionsPanel {
    public MailTrackingOptionsPanel(OptionChangesListener theChangesListener, MVCController theParentController) {
        super(theChangesListener, theParentController);
        this.init();
        this.buildUI();
    }

    private void init() {
        this.btnWhenDeleted = new GWExpandButton(Notification.NOTIFICATION_LIST, this.itemListener);
        this.btnWhenOpened = new GWExpandButton(Notification.NOTIFICATION_LIST, this.itemListener);
        this.cbAutoDeleteSentItem.setEnabled(true);
        this.cbEnableDeliveryConfirmation.setEnabled(true);
    }

    public void setOptions(AbstractCloneObject theAbstractOptions) throws IllegalArgumentException {
        this.fireOptionsChanged((MailSendOptions)theAbstractOptions);
    }

    public void fireOptionsChanged(MailSendOptions mailSendOptions) {
        super.fireOptionsChanged();
        this.btnWhenDeleted.setSelectedItem(mailSendOptions.getRNWhenDeleted());
        this.btnWhenOpened.setSelectedItem(mailSendOptions.getRNWhenOpened());
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        this.cbCreateSentItemToTrack.setEnabled(!dataStoreSettings.getSendOptionSecurityClassification().getSecurityLocked());
        this.cbCreateSentItemToTrack.setSelected((Boolean)dataStoreSettings.getSendOptionCreateSentItem().getValue());
        int option = (Integer)dataStoreSettings.getSendOptionStatusTracking(ItemType.MAIL.getValue()).getValue();
        if (option != 0) {
            ((JRadioButton)this.buttonList.get(option - 1)).setSelected(true);
        }
    }

    public void collectValues(ItemSendOptions itemSendOptions) {
        itemSendOptions.setRNMailOpened((Notification)this.btnWhenOpened.getSelectedItem());
        itemSendOptions.setRNMailDeleted((Notification)this.btnWhenDeleted.getSelectedItem());
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        dataStoreSettings.setSendOptionCreateSentItem(this.cbCreateSentItemToTrack.isSelected());
        dataStoreSettings.setSendOptionStatusTracking(ItemType.MAIL.getValue(), this.getSendOptionStatusTrackingValue());
        dataStoreSettings.setSendOptionMailAutoDelete(this.cbAutoDeleteSentItem.isSelected());
        int value = this.cbEnableDeliveryConfirmation.isSelected() ? (this.cbSendNotifications.isSelected() ? 3 : 1) : 0;
        dataStoreSettings.setSendOptionInternetStatusTracking(value);
    }

    protected void createSentItemToTrack(boolean enabled) {
        super.createSentItemToTrack(enabled);
        this.cbAutoDeleteSentItem.setEnabled(enabled);
    }

    JPanel createReturnNotificationPanel() {
        OrientablePanel panel = new OrientablePanel(new GridLayout());
        panel.setBorder(BorderFactory.createTitledBorder(StringResources.RETURN_NOTIFICATION));
        OrientablePanel panelLeft = new OrientablePanel(new GridBagLayout());
        OrientablePanel panelRight = new OrientablePanel(new GridBagLayout());
        panel.add(panelLeft);
        panel.add(panelRight);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        constraints.anchor = 23;
        constraints.insets = new Insets(10, 10, 0, 10);
        panelLeft.add((Component)new JMnemonicLabel(StringResources.WHEN_OPENED, this.btnWhenOpened), constraints);
        ++constraints.gridy;
        constraints.insets.top = 5;
        panelLeft.add((Component)this.btnWhenOpened, constraints);
        ++constraints.gridy;
        constraints.insets.top = 10;
        panelLeft.add((Component)new JMnemonicLabel(StringResources.WHEN_DELETED, this.btnWhenDeleted), constraints);
        ++constraints.gridy;
        constraints.insets = new Insets(5, 10, 10, 10);
        panelLeft.add((Component)this.btnWhenDeleted, constraints);
        return panel;
    }

    public boolean isEnabledCreateItemToTrack() {
        return this.cbCreateSentItemToTrack.isSelected();
    }

    public boolean isEnabledDeliveryConfirmation() {
        return this.cbEnableDeliveryConfirmation.isSelected();
    }
}

