/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.send;

import com.appframework.ApplicationFrame;
import com.appframework.components.htmleditor.HTMLTextPane;
import com.appframework.components.htmleditor.ViewHTMLTextPane;
import com.appframework.utils.UIUtils;
import com.novell.gw.account.Account;
import com.novell.gw.jclient.application.controls.BasicDialog;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.filechoser.FileChooserPanel;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicButton;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.options.Signature;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.text.DefaultStyledDocument;

public class SignatureAddPromtDialog
extends BasicDialog {
    private JCheckBox cbAddSignature;
    private JCheckBox cbAddVcard;
    private HTMLTextPane taSignature;
    private JButton btnAdd;
    private JButton btnDontAdd;
    private JButton btnCancel;
    private FileChooserPanel fileVcardChooser;
    private int result = -1;
    public static final int ADD_SIGNATURE = 0;
    public static final int DONT_ADD_SIGNATURE = 1;
    public static final int ACTION_CANCELED = 2;
    private Account account;

    public static Result showDialog(Component parentComponent, Account account) {
        Window window = ControlsUtils.getWindowForComponent(parentComponent);
        SignatureAddPromtDialog dd = new SignatureAddPromtDialog((ApplicationFrame)parentComponent, account);
        dd.setModal(true);
        UIUtils.centerWindowOnScreen(dd);
        dd.pack();
        dd.setVisible(true);
        return new Result(dd.result, dd.taSignature.getPlainText(), dd.fileVcardChooser.getText(), dd.cbAddSignature.isSelected(), dd.cbAddVcard.isSelected());
    }

    private SignatureAddPromtDialog() throws HeadlessException {
        this.buildUI();
    }

    private SignatureAddPromtDialog(ApplicationFrame owner, Account account) throws HeadlessException {
        super(owner);
        this.account = account;
        this.buildUI();
    }

    private SignatureAddPromtDialog(Dialog owner) throws HeadlessException {
        super(owner);
        this.buildUI();
    }

    private void buildUI() {
        this.setTitle(StringResources.SIGNATURE);
        ClickAction clickAction = new ClickAction();
        this.cbAddSignature = new JMnemonicCheckBox(StringResources.ADD_SIGNATURE);
        this.cbAddVcard = new JMnemonicCheckBox(StringResources.ATTACH_VCARD);
        this.taSignature = new ViewHTMLTextPane();
        this.taSignature.setMode(2);
        this.taSignature.setDocument(new DefaultStyledDocument());
        Font areaFont = this.taSignature.getFont();
        this.taSignature.setFont(new Font(PLAFChanger.getFontName(), areaFont.getStyle(), areaFont.getSize()));
        this.btnAdd = new JMnemonicButton(new AddAction());
        this.btnDontAdd = new JMnemonicButton(new DontAddAction());
        this.btnCancel = new OrientableButton(new CancelAction());
        this.fileVcardChooser = new FileChooserPanel(StringResources.LEAVE_EMPTY_TO_USE_ADDRESS_BOOK, "", 0, true);
        this.cbAddSignature.addActionListener(clickAction);
        this.cbAddVcard.addActionListener(clickAction);
        this.btnAdd.setEnabled(false);
        OrientablePanel content = new OrientablePanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 7, 0);
        content.add((Component)this.cbAddSignature, c);
        c.fill = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        OrientableScrollPane scrollPane = new OrientableScrollPane(this.taSignature);
        scrollPane.setPreferredSize(new Dimension(scrollPane.getPreferredSize().width, 200));
        content.add((Component)scrollPane, c);
        c.fill = 0;
        c.gridy = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        content.add((Component)this.cbAddVcard, c);
        c.fill = 2;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridy = 3;
        content.add((Component)this.fileVcardChooser, c);
        c.anchor = 22;
        c.fill = 3;
        c.gridheight = 0;
        c.gridx = 1;
        c.gridy = 0;
        c.insets = new Insets(0, 10, 0, 0);
        c.weightx = 0.0;
        c.weighty = 1.0;
        content.add((Component)this.createButtonPanel(), c);
        content.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().add(content);
        this.setDefaultButton(this.btnAdd);
        this.setCancelButton(this.btnCancel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SignatureAddPromtDialog.this.result = 2;
            }
        });
        this.readOptions();
    }

    private JComponent createButtonPanel() {
        OrientablePanel content = new OrientablePanel();
        content.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.insets = new Insets(0, 0, 5, 0);
        c.weightx = 1.0;
        content.add((Component)this.btnAdd, c);
        content.add((Component)this.btnDontAdd, c);
        content.add((Component)this.btnCancel, c);
        c.fill = 3;
        c.weighty = 1.0;
        content.add((Component)new JPanel(), c);
        return content;
    }

    private void readOptions() {
        String userGuid = ((ApplicationFrame)this.getParent()).getUserGuid();
        Signature s = null;
        try {
            s = GWCommandManager.getInstance(userGuid).getSignature(this.account);
        }
        catch (GWCommandException e) {
            e.printStackTrace();
        }
        if (s != null) {
            this.cbAddSignature.setSelected(s.isUsedSignature());
            this.cbAddVcard.setSelected(s.isUsedCard());
            this.btnAdd.setEnabled(s.isUsedSignature() || s.isUsedCard());
            this.taSignature.setPlainText(s.getSignatureText());
            this.taSignature.setCaretPosition(0);
            this.fileVcardChooser.setEnabled(s.isUsedCard());
            this.fileVcardChooser.setText(s.getCardFileName());
        }
    }

    private void processAddAnswer() {
        int res;
        String vcfFileName;
        if (this.cbAddVcard.isSelected() && (vcfFileName = this.fileVcardChooser.getText()) != null && !"".equals(vcfFileName) && !new File(vcfFileName).exists() && (res = JOptionPane.showConfirmDialog(this, StringResources.formatString(StringResources.NO_SUCH_VCF_FILE, vcfFileName), StringResources.ERROR, 0, 0)) != 0) {
            return;
        }
        this.result = 0;
        this.setVisible(false);
    }

    private class ClickAction
    extends AbstractAction {
        private ClickAction() {
        }

        public void actionPerformed(ActionEvent e) {
            SignatureAddPromtDialog.this.taSignature.setEnabled(SignatureAddPromtDialog.this.cbAddSignature.isSelected());
            SignatureAddPromtDialog.this.fileVcardChooser.setEnabled(SignatureAddPromtDialog.this.cbAddVcard.isSelected());
            SignatureAddPromtDialog.this.btnAdd.setEnabled(SignatureAddPromtDialog.this.cbAddSignature.isSelected() || SignatureAddPromtDialog.this.cbAddVcard.isSelected());
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(StringResources.CANCEL);
        }

        public void actionPerformed(ActionEvent e) {
            SignatureAddPromtDialog.this.result = 2;
            SignatureAddPromtDialog.this.setVisible(false);
        }
    }

    private class DontAddAction
    extends AbstractAction {
        public DontAddAction() {
            super(StringResources.DONT_ADD);
        }

        public void actionPerformed(ActionEvent e) {
            SignatureAddPromtDialog.this.result = 1;
            SignatureAddPromtDialog.this.setVisible(false);
        }
    }

    private class AddAction
    extends AbstractAction {
        public AddAction() {
            super(StringResources.ADD);
        }

        public void actionPerformed(ActionEvent e) {
            SignatureAddPromtDialog.this.processAddAnswer();
        }
    }

    public static class Result {
        private int resID;
        private String signature;
        private String vCardPath;
        private boolean addSignature;
        private boolean addVCard;

        public Result(int theResID, String theSignature, String theVCardPath, boolean addSignature, boolean addVCard) {
            if (theResID < 0 || theResID > 2) {
                throw new IllegalArgumentException();
            }
            this.resID = theResID;
            this.signature = theSignature;
            this.vCardPath = theVCardPath;
            this.addSignature = addSignature;
            this.addVCard = addVCard;
        }

        public int getResultID() {
            return this.resID;
        }

        public String getSignature() {
            return this.signature;
        }

        public String getVCardPath() {
            return this.vCardPath;
        }

        public boolean isAddSignature() {
            return this.addSignature;
        }

        public boolean isAddVCard() {
            return this.addVCard;
        }
    }
}

