/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.send;

import com.appframework.components.htmleditor.HTMLConstants;
import com.appframework.components.htmleditor.HTMLTextPane;
import com.appframework.components.htmleditor.ViewHTMLTextPane;
import com.appframework.components.htmleditor.hyperlink.HTMLUtils;
import com.appframework.mvc.MVCController;
import com.appframework.utils.UIUtils;
import com.novell.gw.account.Account;
import com.novell.gw.jclient.application.controls.filechoser.FileChooserPanel;
import com.novell.gw.jclient.application.controls.filechoser.OptionChangesListener;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicCheckBox;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicRadioButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.options.AbstractCloneObject;
import com.novell.gw.jclient.bl.om.options.SendOptions;
import com.novell.gw.jclient.bl.om.options.Signature;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DefaultStyledDocument;
import org.apache.log4j.Logger;

public class SignaturePanel
extends AbstractOptionPanel {
    private static Logger logger = Logger.getLogger(SignaturePanel.class);
    private JCheckBox cbAddSign;
    private JCheckBox cbAddVCard;
    private JRadioButton rbAuto;
    private JRadioButton rbPrompt;
    private FileChooserPanel cardChooserPanel;
    private HTMLTextPane taSignature;
    private boolean taSignatureListenerEnabled = true;
    private SendOptions sendOptions;
    private String userGuid;
    private Account account;

    public SignaturePanel(OptionChangesListener theChangesListener, MVCController theParentController, String userGuid, Account account) {
        super(theChangesListener, theParentController);
        this.userGuid = userGuid;
        this.account = account;
    }

    public void build() {
        this.cbAddSign = new JMnemonicCheckBox(new SignatureClickAction());
        this.cbAddVCard = new JMnemonicCheckBox(new VCardClickAction());
        this.rbAuto = new JMnemonicRadioButton(StringResources.AUTOMATICALLY_ADD);
        this.rbPrompt = new JMnemonicRadioButton(StringResources.PROMPT_BEFORE_ADDING);
        RBClickListener l = new RBClickListener();
        this.rbAuto.addActionListener(l);
        this.rbPrompt.addActionListener(l);
        this.taSignature = new ViewHTMLTextPane();
        this.taSignature.setMode(2);
        this.taSignature.setIgnoreDefaultFontAttributes(true);
        this.taSignature.setDocument(new DefaultStyledDocument());
        Font areaFont = this.taSignature.getFont();
        this.taSignature.setFont(new Font(PLAFChanger.getFontName(), areaFont.getStyle(), areaFont.getSize()));
        this.taSignature.getDocument().addDocumentListener(new SignatureDocumentListener());
        this.cardChooserPanel = new FileChooserPanel(StringResources.LEAVE_EMPTY_TO_USE_ADDRESS_BOOK, "", 0, 7, true);
        this.cardChooserPanel.setFilter(StringResources.VCARDS + " (*.vcf)", new String[]{"vcf"});
        this.rbPrompt.setSelected(true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbAuto);
        buttonGroup.add(this.rbPrompt);
        this.updateOnSignatureEnablity(false);
        this.updateOnVCardEnablity(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        this.add((Component)SignaturePanel.createSignatureLabel(), c);
        c.fill = 2;
        c.gridy = 1;
        c.gridwidth = 2;
        c.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.cbAddSign, c);
        c.gridy = 2;
        c.fill = 1;
        c.gridheight = 3;
        c.gridwidth = 1;
        c.insets = new Insets(0, 0, 0, 10);
        c.weightx = 0.0;
        c.weighty = 1.0;
        OrientableScrollPane scrollPane = new OrientableScrollPane(this.taSignature);
        scrollPane.setMinimumSize(new Dimension(320, 200));
        scrollPane.setPreferredSize(new Dimension(320, 200));
        this.add((Component)scrollPane, c);
        c.anchor = 11;
        c.fill = 2;
        c.gridx = 1;
        c.gridheight = 1;
        c.insets = new Insets(0, 0, 0, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.add((Component)this.rbAuto, c);
        c.gridy = 3;
        this.add((Component)this.rbPrompt, c);
        c.anchor = 21;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 2;
        c.insets = new Insets(15, 0, 0, 0);
        this.add((Component)this.cbAddVCard, c);
        c.fill = 2;
        ++c.gridy;
        c.gridwidth = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.cardChooserPanel, c);
    }

    private static JLabel createSignatureLabel() {
        String alignment = "align=";
        alignment = UIUtils.getComponentOrientation().isLeftToRight() ? alignment + "left" : alignment + "right";
        return new OrientableLabel("<html><p " + alignment + '>' + StringResources.ADD_YOUR_SIGNATURE_AND_OR_VCARD + "</p></html>");
    }

    public void collectValues() {
        Signature signature = new Signature();
        signature.setUseSignature(this.cbAddSign.isSelected());
        signature.setUseECard(this.cbAddVCard.isSelected());
        signature.setSignatureText(this.taSignature.getPlainText());
        signature.setCardFileName(this.cardChooserPanel.getText());
        signature.setPromptOnAdd(this.rbPrompt.isSelected());
        try {
            GWCommandManager.getInstance(this.userGuid).setSignature(signature, this.account);
        }
        catch (GWCommandException e) {
            e.printStackTrace();
        }
    }

    public void fireOptionsChanged() {
        try {
            String fontName;
            int fontSize;
            Signature signature = GWCommandManager.getInstance(this.userGuid).getSignature(this.account);
            this.cbAddSign.setSelected(signature.isUsedSignature());
            this.rbAuto.setEnabled(signature.isUsedSignature() || signature.isUsedCard());
            this.rbPrompt.setEnabled(signature.isUsedSignature() || signature.isUsedCard());
            this.taSignatureListenerEnabled = false;
            this.taSignature.setPlainText(signature.getSignatureText());
            if (HTMLUtils.isDefaultComposeHTML()) {
                fontSize = HTMLConstants.getDefaultFontSize(1);
                fontName = HTMLConstants.getDefaultFontName(1);
            } else {
                fontSize = HTMLConstants.getDefaultFontSize(3);
                fontName = HTMLConstants.getDefaultFontName(3);
            }
            this.taSignature.setText("{\\rtf1\\ansi\n{\\fonttbl\\f0\\fnil " + fontName + ";}" + "{\\f0" + "{\\fs" + 2 * fontSize + " " + signature.getSignatureText().replaceAll("\n", "\\\\par ") + "}}");
            this.taSignature.setEnabled(signature.isUsedSignature());
            this.taSignatureListenerEnabled = true;
            this.rbAuto.setSelected(!signature.isPromptOnAdd());
            this.rbPrompt.setSelected(signature.isPromptOnAdd());
            this.cbAddVCard.setSelected(signature.isUsedCard());
            this.cardChooserPanel.setText(signature.getCardFileName());
            this.cardChooserPanel.setEnabled(signature.isUsedCard());
            if (this.changesListener != null) {
                this.changesListener.setValueSaved();
            }
        }
        catch (GWCommandException e) {
            e.printStackTrace();
        }
    }

    public void setOptions(AbstractCloneObject theAbstractOptions) throws IllegalArgumentException {
        if (!(theAbstractOptions instanceof SendOptions)) {
            logger.debug((Object)("Illegal class " + theAbstractOptions == null ? "null" : theAbstractOptions.getClass().getName()));
            throw new IllegalArgumentException();
        }
        this.sendOptions = (SendOptions)theAbstractOptions;
    }

    public Insets getInsets() {
        return new Insets(10, 10, 10, 10);
    }

    private void dataChanged() {
        if (this.changesListener != null) {
            this.changesListener.setValueChanged();
        }
    }

    private void updateOnSignatureEnablity(boolean enabled) {
        this.taSignature.setEnabled(enabled);
        boolean b = enabled || this.cbAddVCard.isSelected();
        this.rbAuto.setEnabled(b);
        this.rbPrompt.setEnabled(b);
    }

    private void updateOnVCardEnablity(boolean enabled) {
        this.cardChooserPanel.setEnabled(enabled);
        boolean b = enabled || this.cbAddSign.isSelected();
        this.rbAuto.setEnabled(b);
        this.rbPrompt.setEnabled(b);
    }

    private class RBClickListener
    implements ActionListener {
        private RBClickListener() {
        }

        public void actionPerformed(ActionEvent e) {
            SignaturePanel.this.dataChanged();
        }
    }

    private class SignatureDocumentListener
    implements DocumentListener {
        private SignatureDocumentListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            if (SignaturePanel.this.taSignatureListenerEnabled) {
                SignaturePanel.this.dataChanged();
            }
        }

        public void removeUpdate(DocumentEvent e) {
            if (SignaturePanel.this.taSignatureListenerEnabled) {
                SignaturePanel.this.dataChanged();
            }
        }

        public void changedUpdate(DocumentEvent e) {
        }
    }

    private class VCardClickAction
    extends AbstractAction {
        public VCardClickAction() {
            super(StringResources.ELECTRONIC_BUSINESS_CARD);
        }

        public void actionPerformed(ActionEvent e) {
            SignaturePanel ssp = SignaturePanel.this;
            ssp.updateOnVCardEnablity(ssp.cbAddVCard.isSelected());
            ssp.dataChanged();
        }
    }

    private class SignatureClickAction
    extends AbstractAction {
        public SignatureClickAction() {
            super(StringResources.SIGNATURE);
        }

        public void actionPerformed(ActionEvent e) {
            SignaturePanel ssp = SignaturePanel.this;
            ssp.updateOnSignatureEnablity(ssp.cbAddSign.isSelected());
            ssp.dataChanged();
        }
    }
}

