/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.send;

import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.controls.filechoser.OptionChangesListener;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.frames.options.compose.send.AbstractItemOptionsPanel;
import com.novell.gw.jclient.application.frames.options.compose.send.AppointmentTrackingOptionsPanel;
import com.novell.gw.jclient.application.frames.options.compose.send.MailTrackingOptionsPanel;
import com.novell.gw.jclient.application.frames.options.compose.send.NoteTrackingOptionsPanel;
import com.novell.gw.jclient.application.frames.options.compose.send.TaskTrackingOptionsPanel;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.sendoptions.AppSendOptions;
import com.novell.gw.jclient.bl.om.items.sendoptions.MailSendOptions;
import com.novell.gw.jclient.bl.om.items.sendoptions.NoteSendOptions;
import com.novell.gw.jclient.bl.om.items.sendoptions.TaskSendOptions;
import com.novell.gw.jclient.bl.om.options.AbstractCloneObject;
import com.novell.gw.jclient.bl.om.options.ItemSendOptions;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class StatusTrackingOptionsPanel
extends AbstractOptionPanel {
    private ItemSendOptions itemSendOptions;
    private TaskTrackingOptionsPanel pnlTaskTrackingOptions;
    private NoteTrackingOptionsPanel pnlNoteTrackingOptions;
    private MailTrackingOptionsPanel pnlMailTrackingOptions;
    private AppointmentTrackingOptionsPanel pnlAppointmentTrackingOptions;
    private JComboBox cmbSettingsFor;
    public static String[] SETTINGS_LIST = new String[]{StringResources.MAIL_MESSAGES, StringResources.APPOINTMENTS, StringResources.TASKS, StringResources.REMINDER_NOTES};

    public StatusTrackingOptionsPanel(OptionChangesListener theChangesListener, MVCController theParentController) {
        super(theChangesListener, theParentController);
    }

    private void init() {
        this.pnlTaskTrackingOptions = new TaskTrackingOptionsPanel(this.changesListener, this.controller);
        this.pnlMailTrackingOptions = new MailTrackingOptionsPanel(this.changesListener, this.controller);
        this.pnlNoteTrackingOptions = new NoteTrackingOptionsPanel(this.changesListener, this.controller);
        this.pnlAppointmentTrackingOptions = new AppointmentTrackingOptionsPanel(this.changesListener, this.controller);
        this.cmbSettingsFor = new OrientableComboBox(SETTINGS_LIST);
        this.cmbSettingsFor.addItemListener(this.itemListener);
        this.cmbSettingsFor.addActionListener(new ItemTypeListener());
    }

    private void buildUI(AbstractItemOptionsPanel panel) {
        if (!(panel instanceof MailTrackingOptionsPanel)) {
            panel.setEnabledDeliveryConfirmation(this.pnlMailTrackingOptions.isEnabledDeliveryConfirmation());
            panel.setEnabledCreateItemToTrack(this.pnlMailTrackingOptions.isEnabledCreateItemToTrack());
        }
        this.removeAll();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 21;
        constraints.fill = 2;
        constraints.insets.top = 5;
        this.add((Component)this.createSettingsForPanel(), constraints);
        ++constraints.gridy;
        constraints.weighty = 1.0;
        constraints.anchor = 23;
        this.add((Component)panel, constraints);
    }

    protected void build() {
        this.init();
        this.buildUI(this.pnlMailTrackingOptions);
    }

    public void collectValues() {
        this.pnlAppointmentTrackingOptions.collectValues(this.itemSendOptions);
        this.pnlMailTrackingOptions.collectValues(this.itemSendOptions);
        this.pnlNoteTrackingOptions.collectValues(this.itemSendOptions);
        this.pnlTaskTrackingOptions.collectValues(this.itemSendOptions);
    }

    public void fireOptionsChanged() {
        this.pnlAppointmentTrackingOptions.fireOptionsChanged(new AppSendOptions(this.itemSendOptions));
        this.pnlMailTrackingOptions.fireOptionsChanged(new MailSendOptions(this.itemSendOptions));
        this.pnlNoteTrackingOptions.fireOptionsChanged(new NoteSendOptions(this.itemSendOptions));
        this.pnlTaskTrackingOptions.fireOptionsChanged(new TaskSendOptions(this.itemSendOptions));
    }

    public void setOptions(AbstractCloneObject theAbstractOptions) throws IllegalArgumentException {
        if (!(theAbstractOptions instanceof ItemSendOptions)) {
            throw new IllegalArgumentException("instance of ItemSendOptions expected.");
        }
        this.itemSendOptions = (ItemSendOptions)theAbstractOptions;
    }

    private JPanel createSettingsForPanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(0, 0, 5, 10);
        panel.add((Component)new OrientableLabel(StringResources.SETTINGS_FOR_C), constraints);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        panel.add((Component)this.cmbSettingsFor, constraints);
        return panel;
    }

    private class ItemTypeListener
    implements ActionListener {
        private ItemTypeListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String selectedItem = (String)((JComboBox)e.getSource()).getSelectedItem();
            AbstractItemOptionsPanel pnlTemp = null;
            if (selectedItem.equals(StringResources.MAIL_MESSAGES)) {
                pnlTemp = StatusTrackingOptionsPanel.this.pnlMailTrackingOptions;
            } else if (selectedItem.equals(StringResources.APPOINTMENTS)) {
                pnlTemp = StatusTrackingOptionsPanel.this.pnlAppointmentTrackingOptions;
            } else if (selectedItem.equals(StringResources.REMINDER_NOTES)) {
                pnlTemp = StatusTrackingOptionsPanel.this.pnlNoteTrackingOptions;
            } else if (selectedItem.equals(StringResources.TASKS)) {
                pnlTemp = StatusTrackingOptionsPanel.this.pnlTaskTrackingOptions;
            }
            StatusTrackingOptionsPanel.this.buildUI(pnlTemp);
            StatusTrackingOptionsPanel.this.validate();
            StatusTrackingOptionsPanel.this.repaint();
        }
    }
}

