/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.send.signatures;

import com.novell.gw.account.AccountSettings;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import org.apache.log4j.Logger;

public class SignatureListModel
extends AbstractListModel {
    private Logger logger = Logger.getLogger(SignatureListModel.class);
    private ArrayList<AccountSettings.Signature> allSignatures = new ArrayList();
    private ArrayList<AccountSettings.Signature> modifiedSignatures;
    private ArrayList<AccountSettings.Signature> createdSignatures = new ArrayList();
    private String defaultSignature;
    private ArrayList<String> deletedSignatures;
    private AccountSettings accountSettings;

    public SignatureListModel() {
        this.modifiedSignatures = new ArrayList();
        this.deletedSignatures = new ArrayList();
        this.accountSettings = EngineCommandManager.getAccountSettings();
    }

    public int getSize() {
        return this.allSignatures.size();
    }

    public Object getElementAt(int index) {
        return this.allSignatures.get((int)index).signatureName;
    }

    public void loadValues() {
        this.loadSignatures();
        this.loadDefaultSignature();
        this.refreshValues();
    }

    private void loadSignatures() {
        this.allSignatures.clear();
        this.createdSignatures.clear();
        this.deletedSignatures.clear();
        this.modifiedSignatures.clear();
        AccountSettings.Signature signature = this.accountSettings.getFirstSignature();
        while (signature != null && !this.containsSignature(signature.signatureName)) {
            this.logger.debug((Object)("Signature: " + signature));
            this.logger.debug((Object)("Name: " + signature.signatureName));
            this.logger.debug((Object)("Flags: " + signature.signatureFlags));
            this.logger.debug((Object)("ID: " + signature.signatureID));
            this.allSignatures.add(signature);
            signature = this.accountSettings.getNextSignature();
        }
    }

    private void loadDefaultSignature() {
        Object signature = null;
        this.defaultSignature = signature == null ? null : signature.signatureName;
    }

    public void saveValues() {
        this.saveCreatedSignatures();
        this.saveModifiedSignatures();
        this.saveDeletedSignatures();
        this.saveDefaultSignature();
    }

    private void saveCreatedSignatures() {
        for (AccountSettings.Signature signature : this.createdSignatures) {
            this.saveSignature(signature);
        }
    }

    private void saveSignature(AccountSettings.Signature signature) {
        this.accountSettings.writeSignature(signature.signatureName, signature.signatureMIME, signature.signatureID, 1);
    }

    private void saveDefaultSignature() {
        this.loadSignatures();
        AccountSettings.Signature signature = this.getSignature(this.defaultSignature);
        if (this.defaultSignature != null) {
            this.accountSettings.writeSignature(signature.signatureName, signature.signatureMIME, signature.signatureID, 3);
        }
    }

    private void saveDeletedSignatures() {
        for (String signatureID : this.deletedSignatures) {
            this.accountSettings.deleteSignature(signatureID);
        }
    }

    private void saveModifiedSignatures() {
        for (AccountSettings.Signature signature : this.modifiedSignatures) {
            this.saveSignature(signature);
        }
    }

    public void refreshValues() {
        this.fireContentsChanged(this, 0, this.allSignatures.size());
    }

    public boolean containsSignature(String name) {
        for (AccountSettings.Signature signature : this.allSignatures) {
            if (!signature.signatureName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public String getDefaultSignature() {
        return this.defaultSignature;
    }

    public void addItem(String name) {
        AccountSettings accountSettings = this.accountSettings;
        accountSettings.getClass();
        AccountSettings.Signature signature = new AccountSettings.Signature(accountSettings, name, "", null, 1);
        this.allSignatures.add(signature);
        this.createdSignatures.add(signature);
        this.refreshValues();
    }

    public void removeSignature(String name) {
        AccountSettings.Signature signature = this.getSignature(name);
        if (this.createdSignatures.contains(signature)) {
            this.createdSignatures.remove(signature);
        } else {
            this.deletedSignatures.add(signature.signatureID);
        }
        if (this.defaultSignature != null && this.defaultSignature.equals(signature.signatureName)) {
            this.defaultSignature = null;
        }
        this.allSignatures.remove(signature);
        this.modifiedSignatures.remove(signature);
        this.refreshValues();
    }

    public void renameSignature(String oldName, String newName) {
        AccountSettings.Signature signature = this.getSignature(oldName);
        signature.signatureName = newName;
        if (!this.createdSignatures.contains(signature)) {
            this.modifiedSignatures.add(signature);
        }
        this.refreshValues();
    }

    public void setDefaultSignature(String name) {
        this.defaultSignature = name;
        this.refreshValues();
    }

    private AccountSettings.Signature getSignature(String signatureName) {
        for (AccountSettings.Signature signature : this.allSignatures) {
            if (!signature.signatureName.equals(signatureName)) continue;
            return signature;
        }
        return null;
    }

    public String getText(String name) {
        return this.getSignature((String)name).signatureMIME;
    }

    public String getText(int index) {
        return this.allSignatures.get((int)index).signatureMIME;
    }

    public void setText(String name, String text) {
        AccountSettings.Signature signature = this.getSignature(name);
        signature.signatureMIME = text;
        if (!this.createdSignatures.contains(signature)) {
            this.modifiedSignatures.add(signature);
        }
        this.refreshValues();
    }
}

