/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.notify;

import com.appframework.ActionList;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.notify.NotifyTrayIcon;
import com.novell.gw.jclient.application.notify.actions.ActionAboutNotify;
import com.novell.gw.jclient.application.notify.actions.ActionDisplayNotificationList;
import com.novell.gw.jclient.application.notify.actions.ActionDisplayNotifyHelp;
import com.novell.gw.jclient.application.notify.actions.ActionDisplayNotifyOptions;
import com.novell.gw.jclient.application.notify.actions.ActionEnableNotifications;
import com.novell.gw.jclient.application.notify.actions.ActionExitNotify;
import com.novell.gw.jclient.application.notify.actions.ActionReadMail;
import com.novell.gw.jclient.application.notify.actions.ActionShowInTray;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import org.apache.log4j.Logger;

public class NotifyActionList
extends ActionList {
    private static Logger logger = Logger.getLogger(NotifyActionList.class);
    private static BufferedImage GW_DOCK_ICON;
    private boolean systemTrayUsed = false;
    private boolean notificationsPresent = false;
    private boolean viewVisible = false;

    public NotifyActionList(MVCView view, MVCController parentController) {
        super(view, parentController);
        if (view instanceof NotifyTrayIcon) {
            this.systemTrayUsed = true;
        }
        logger.debug((Object)("level: " + this.getLevel()));
        logger.debug((Object)("MVCView: " + (view == null ? null : view.getClass().getName())));
        this.createActions();
    }

    private void createActions() {
        this.addAction(new ActionAboutNotify(this));
        this.addAction(new ActionDisplayNotificationList(this));
        this.addAction(new ActionDisplayNotifyHelp(this));
        this.addAction(new ActionDisplayNotifyOptions(this));
        this.addAction(new ActionExitNotify(this));
        this.addAction(new ActionReadMail(this));
        this.addAction(new ActionShowInTray(this));
        this.addAction(new ActionEnableNotifications(this));
    }

    private void handle_NUMBER_OF_NOTIFICATIONS_CHANGED(int number) {
        boolean oldValue = this.notificationsPresent;
        boolean bl = this.notificationsPresent = number > 0;
        if (this.systemTrayUsed && this.notificationsPresent != oldValue) {
            logger.debug((Object)("updating tray, notificationsPresent: " + this.notificationsPresent));
            NotifyTrayIcon trayIcon = (NotifyTrayIcon)this.getMVCView();
            if (this.notificationsPresent) {
                trayIcon.setImage(ImageResources.TRAY_NOTIFICATIONS_PRESENT.getImage());
                trayIcon.setToolTip(StringResources.YOU_HAVE_NOTIFICATIONS);
            } else {
                trayIcon.setImage(ImageResources.TRAY_NOTIFICATIONS_ABSENT.getImage());
                trayIcon.setToolTip(StringResources.NO_NOTIFICATIONS);
            }
        }
    }

    private void updateTrayIconPopupMenu(boolean clientRunning) {
        if (this.systemTrayUsed) {
            ((NotifyTrayIcon)this.getMVCView()).updatePopupMenu(clientRunning);
        }
    }

    protected void updateViewVisibility() {
        if (this.systemTrayUsed) {
            boolean showInTray = OptionManager.getInstance().getNotifierOptions().isShowInTray();
            if (GWClient.isGwClientRunning() && !showInTray) {
                this.hideView();
            } else {
                this.showView();
            }
        } else if (GWClient.isGwClientRunning()) {
            this.hideView();
        } else {
            this.showView();
        }
    }

    private void showView() {
        if (this.viewVisible) {
            return;
        }
        if (this.systemTrayUsed) {
            try {
                ((NotifyTrayIcon)this.getMVCView()).addToSystemTray();
                this.viewVisible = true;
            }
            catch (AWTException e) {
                logger.error((Object)e);
                logger.debug((Object)e, (Throwable)e);
            }
        } else {
            ((JFrame)this.getMVCView()).setVisible(true);
            this.viewVisible = true;
        }
    }

    private void hideView() {
        if (!this.viewVisible) {
            return;
        }
        if (this.systemTrayUsed) {
            try {
                ((NotifyTrayIcon)this.getMVCView()).removeFromSystemTray();
                this.viewVisible = false;
            }
            catch (AWTException e) {
                logger.error((Object)e);
                logger.debug((Object)e, (Throwable)e);
            }
        } else {
            ((JFrame)this.getMVCView()).setVisible(false);
            this.viewVisible = false;
        }
    }

    private void disposeView() {
        if (this.systemTrayUsed) {
            try {
                ((NotifyTrayIcon)this.getMVCView()).removeFromSystemTray();
            }
            catch (AWTException e) {
                logger.error((Object)e);
                logger.debug((Object)e, (Throwable)e);
            }
        } else {
            ((JFrame)this.getMVCView()).dispose();
        }
        GlobalCommand command = new GlobalCommand(1520, 0);
        this.processCommand(command);
    }

    protected void initListeners() {
        super.initListeners();
        Level level = this.getLevel();
        AppEventListener listener = new EXIT_NOTIFY_Listener();
        AppEventListenerDescriptor descriptor = new AppEventListenerDescriptor(level, 1480, listener);
        this.addListenerDescriptor(descriptor);
        listener = new NUMBER_OF_NOTIFICATIONS_CHANGED_Listener();
        descriptor = new AppEventListenerDescriptor(level, 1520, listener);
        this.addListenerDescriptor(descriptor);
        listener = new CLIENT_CLOSED_Listener();
        descriptor = new AppEventListenerDescriptor(level, 1710, listener);
        this.addListenerDescriptor(descriptor);
        listener = new CLIENT_STARTED_Listener();
        descriptor = new AppEventListenerDescriptor(level, 1720, listener);
        this.addListenerDescriptor(descriptor);
        listener = new NOTIFY_TRAY_ICON_VISIBILITY_CHANGED_Listener();
        descriptor = new AppEventListenerDescriptor(level, 1730, listener);
        this.addListenerDescriptor(descriptor);
    }

    public Component getOwnerComponent() {
        Object view = this.getMVCView();
        if (view instanceof Component) {
            return (Component)view;
        }
        return null;
    }

    private class NOTIFY_TRAY_ICON_VISIBILITY_CHANGED_Listener
    extends AppEventListener {
        private NOTIFY_TRAY_ICON_VISIBILITY_CHANGED_Listener() {
        }

        public void handle(AppEvent event) {
            NotifyActionList.this.updateViewVisibility();
        }
    }

    private class CLIENT_STARTED_Listener
    extends AppEventListener {
        private CLIENT_STARTED_Listener() {
        }

        public void handle(AppEvent event) {
            NotifyActionList.this.updateViewVisibility();
            NotifyActionList.this.updateTrayIconPopupMenu(true);
        }
    }

    private class CLIENT_CLOSED_Listener
    extends AppEventListener {
        private CLIENT_CLOSED_Listener() {
        }

        public void handle(AppEvent event) {
            NotifyActionList.this.updateViewVisibility();
            NotifyActionList.this.updateTrayIconPopupMenu(false);
        }
    }

    private class NUMBER_OF_NOTIFICATIONS_CHANGED_Listener
    extends AppEventListener {
        private NUMBER_OF_NOTIFICATIONS_CHANGED_Listener() {
        }

        public void handle(AppEvent event) {
            Integer size = (Integer)event.getData();
            NotifyActionList.this.handle_NUMBER_OF_NOTIFICATIONS_CHANGED(size);
        }
    }

    private class EXIT_NOTIFY_Listener
    extends AppEventListener {
        private EXIT_NOTIFY_Listener() {
        }

        public void handle(AppEvent event) {
            NotifyActionList.this.disposeView();
        }
    }
}

