/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.notify;

import com.appframework.AppAction;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.notify.NotifyActionList;
import com.novell.gw.jclient.application.notify.actions.ActionDisplayNotificationList;
import com.novell.gw.jclient.application.notify.actions.ActionEnableNotifications;
import com.novell.gw.jclient.application.notify.actions.ActionShowInTray;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.AWTException;
import java.awt.CheckboxMenuItem;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.apache.log4j.Logger;

public class NotifyTrayIcon
implements MVCView {
    private static Logger logger = Logger.getLogger(NotifyTrayIcon.class);
    private NotifyActionList actionList;
    private Class trayIconClass;
    private Object trayIcon;
    private PopupMenu popupMenu;
    private MenuItem miExitNotify;
    private MenuItem miShowInTray;

    public NotifyTrayIcon(MVCController parentController) throws UnsupportedOperationException {
        boolean trayCreated = this.initTrayItem();
        if (!trayCreated) {
            throw new UnsupportedOperationException("Creating tray icon failed.");
        }
        this.init(parentController);
    }

    private boolean initTrayItem() {
        boolean result = false;
        try {
            this.trayIconClass = Class.forName("java.awt.TrayIcon");
            this.trayIcon = this.trayIconClass.getConstructor(Image.class, String.class).newInstance(ImageResources.TRAY_NOTIFICATIONS_ABSENT.getImage(), StringResources.NO_NOTIFICATIONS);
            result = true;
        }
        catch (Exception e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
        return result;
    }

    private void init(MVCController parentController) {
        this.actionList = new NotifyActionList(this, parentController);
        this.popupMenu = new PopupMenu();
        AppAction actionReadMail = this.actionList.getAction(ActionKey.READ_MAIL);
        AppAction actionAboutNotify = this.actionList.getAction(ActionKey.ABOUT_NOTIFY);
        final AppAction actionDisplayNotificationList = this.actionList.getAction(ActionKey.DISPLAY_NOTIFICATION_LIST);
        AppAction actionDisplayNotifyOptions = this.actionList.getAction(ActionKey.DISPLAY_NOTIFY_OPTIONS);
        AppAction actionDisplayNotifyHelp = this.actionList.getAction(ActionKey.DISPLAY_NOTIFY_HELP);
        AppAction actionExitNotify = this.actionList.getAction(ActionKey.EXIT_NOTIFY);
        ActionShowInTray actionShowInTray = (ActionShowInTray)this.actionList.getAction(ActionKey.SHOW_IN_TRAY);
        ActionEnableNotifications actionEnableNotifications = (ActionEnableNotifications)this.actionList.getAction(ActionKey.ENABLE_NOTIFICATIONS);
        MenuItem miReadMail = new MenuItem(actionReadMail.getName());
        miReadMail.addActionListener(actionReadMail);
        MenuItem miAboutNotify = new MenuItem(actionAboutNotify.getName());
        miAboutNotify.addActionListener(actionAboutNotify);
        MenuItem miDisplayNotificationList = new MenuItem(actionDisplayNotificationList.getName());
        miDisplayNotificationList.addActionListener(actionDisplayNotificationList);
        MenuItem miDisplayNotifyOptions = new MenuItem(actionDisplayNotifyOptions.getName());
        miDisplayNotifyOptions.addActionListener(actionDisplayNotifyOptions);
        MenuItem miDisplayNotifyHelp = new MenuItem(actionDisplayNotifyHelp.getName());
        miDisplayNotifyHelp.addActionListener(actionDisplayNotifyHelp);
        CheckboxMenuItem miEnableNotifications = actionEnableNotifications.getCheckboxMenuItem();
        this.miExitNotify = new MenuItem(actionExitNotify.getName());
        this.miExitNotify.addActionListener(actionExitNotify);
        this.miShowInTray = actionShowInTray.getCheckboxMenuItem();
        this.popupMenu.add(miReadMail);
        this.popupMenu.addSeparator();
        this.popupMenu.add(miEnableNotifications);
        this.popupMenu.add(miDisplayNotificationList);
        this.popupMenu.add(miDisplayNotifyOptions);
        this.popupMenu.add(miAboutNotify);
        this.popupMenu.add(miDisplayNotifyHelp);
        this.popupMenu.addSeparator();
        if (GWClient.isGwClientRunning()) {
            this.popupMenu.add(this.miShowInTray);
        } else {
            this.popupMenu.add(this.miExitNotify);
        }
        this.setPopupMenu(this.popupMenu);
        this.setImageAutoSize(true);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (!e.isPopupTrigger() && e.getButton() == 1) {
                    logger.debug((Object)"mouse button1 clicked, not popup trigger > displaying notification list");
                    ((ActionDisplayNotificationList)actionDisplayNotificationList).doPerformAction();
                }
            }
        });
        logger.debug((Object)"TrayIcon inited");
    }

    public void updatePopupMenu(boolean clientRunning) {
        logger.debug((Object)("client state is: " + (clientRunning ? "ON" : "OFF")));
        if (clientRunning) {
            this.popupMenu.remove(this.miExitNotify);
            this.popupMenu.add(this.miShowInTray);
        } else {
            this.popupMenu.remove(this.miShowInTray);
            this.popupMenu.add(this.miExitNotify);
        }
    }

    public void setPopupMenu(PopupMenu popup) throws IllegalStateException, RuntimeException {
        if (this.trayIcon == null) {
            throw new IllegalStateException("tray icon is null");
        }
        try {
            this.trayIconClass.getMethod("setPopupMenu", PopupMenu.class).invoke(this.trayIcon, popup);
        }
        catch (Exception e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void setImage(Image image) throws IllegalStateException, RuntimeException {
        if (this.trayIcon == null) {
            throw new IllegalStateException("tray icon is null");
        }
        try {
            this.trayIconClass.getMethod("setImage", Image.class).invoke(this.trayIcon, image);
        }
        catch (Exception e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void setToolTip(String tooltip) throws IllegalStateException, RuntimeException {
        if (this.trayIcon == null) {
            throw new IllegalStateException("tray icon is null");
        }
        try {
            this.trayIconClass.getMethod("setToolTip", String.class).invoke(this.trayIcon, tooltip);
        }
        catch (Exception e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void addToSystemTray() throws IllegalStateException, AWTException, RuntimeException {
        if (this.trayIcon == null) {
            throw new IllegalStateException("tray icon is null");
        }
        try {
            Class<?> systemTrayClass = Class.forName("java.awt.SystemTray");
            Object systemTray = systemTrayClass.getMethod("getSystemTray", null).invoke(null, new Object[0]);
            systemTrayClass.getMethod("add", this.trayIconClass).invoke(systemTray, this.trayIcon);
        }
        catch (Exception e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void removeFromSystemTray() throws IllegalStateException, AWTException, RuntimeException {
        if (this.trayIcon == null) {
            throw new IllegalStateException("tray icon is null");
        }
        try {
            Class<?> systemTrayClass = Class.forName("java.awt.SystemTray");
            Object systemTray = systemTrayClass.getMethod("getSystemTray", null).invoke(null, new Object[0]);
            systemTrayClass.getMethod("remove", this.trayIconClass).invoke(systemTray, this.trayIcon);
        }
        catch (Exception e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void setImageAutoSize(boolean autoSize) throws IllegalStateException, RuntimeException {
        if (this.trayIcon == null) {
            throw new IllegalStateException("tray icon is null");
        }
        try {
            this.trayIconClass.getMethod("setImageAutoSize", Boolean.TYPE).invoke(this.trayIcon, autoSize);
        }
        catch (Exception e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void addMouseMotionListener(MouseMotionListener listener) {
        if (this.trayIcon == null) {
            throw new IllegalStateException("tray icon is null");
        }
        try {
            this.trayIconClass.getMethod("addMouseMotionListener", MouseMotionListener.class).invoke(this.trayIcon, listener);
        }
        catch (Exception e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void addMouseListener(MouseListener listener) {
        if (this.trayIcon == null) {
            throw new IllegalStateException("tray icon is null");
        }
        try {
            this.trayIconClass.getMethod("addMouseListener", MouseListener.class).invoke(this.trayIcon, listener);
        }
        catch (Exception e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public MVCController getController() {
        return this.actionList;
    }

    public Object getMVCModel() {
        return null;
    }

    public void setController(MVCController theController) {
    }

    public void setMVCModel(Object theModel) {
    }
}

