/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.notify;

import com.novell.gw.jclient.application.notify.dialogs.options.SettingsPanelModel;
import com.novell.gw.jclient.application.notify.enums.MessagePriority;
import com.novell.gw.jclient.application.notify.enums.MessageType;
import com.novell.gw.jclient.application.notify.enums.ReturnStatus;
import com.novell.gw.jclient.bl.om.GWNotify;
import com.novell.gw.jclient.bl.om.items.NotificationItem;

class ProcessingNotification {
    private NotificationItem item = null;
    private boolean soundPlaying = false;
    private DialogStatus dialogStatus = DialogStatus.NONE;
    private boolean programLaunching = false;
    private String soundFilePath = null;
    private String programFilePath = null;

    ProcessingNotification(NotificationItem item) {
        assert (item != null);
        this.item = item;
        SettingsPanelModel model = this.item.isAlarm() ? GWNotify.getInstance().getAlarmSettingsPanelModel() : (this.item.isReturnStatus() ? this.getStatusSettingsPanelModel(this.item) : this.getMessageSettingsPanelModel(this.item));
        if (model.isPlaySound()) {
            this.soundPlaying = true;
            this.soundFilePath = model.getSoundFilePath();
        }
        if (model.isLaunchProgram()) {
            this.programLaunching = true;
            this.programFilePath = model.getProgramFilePath();
        }
        if (model.isShowDialog()) {
            this.dialogStatus = DialogStatus.SHOWING;
        }
    }

    public NotificationItem getItem() {
        return this.item;
    }

    public DialogStatus getDialogStatus() {
        return this.dialogStatus;
    }

    public boolean isProgramLaunching() {
        return this.programLaunching;
    }

    public boolean isSoundPlaying() {
        return this.soundPlaying;
    }

    public void setDialogStatus(DialogStatus dialogStatus) {
        this.dialogStatus = dialogStatus;
    }

    public void setSoundPlaying(boolean soundPlaying) {
        this.soundPlaying = soundPlaying;
    }

    public void setProgramLaunching(boolean programLaunching) {
        this.programLaunching = programLaunching;
    }

    String getSoundFilePath() {
        return this.soundFilePath;
    }

    String getProgramFilePath() {
        return this.programFilePath;
    }

    boolean isEligible() {
        if (!this.isProcessing()) {
            return true;
        }
        return !this.programLaunching && this.soundPlaying && this.dialogStatus == DialogStatus.CLOSED_BY_TIMEOUT;
    }

    boolean isProcessing() {
        return this.soundPlaying || this.dialogStatus == DialogStatus.SHOWING || this.programLaunching;
    }

    private SettingsPanelModel getMessageSettingsPanelModel(NotificationItem item) {
        boolean sameSettingsForAllNewItems = GWNotify.getInstance().isSameSettingsForAllNewItems();
        MessagePriority messagePriority = item.getMessagePriority();
        MessageType messageType = null;
        if (!sameSettingsForAllNewItems) {
            messageType = item.getMessageType();
        }
        return GWNotify.getInstance().getNewItemSettingsPanelModel(sameSettingsForAllNewItems ? MessageType.ANY : messageType, messagePriority);
    }

    private SettingsPanelModel getStatusSettingsPanelModel(NotificationItem item) {
        boolean sameSettingsForAllStatus = GWNotify.getInstance().isDefaultSameSettingsForAllStatus();
        ReturnStatus returnStatus = item.getReturnStatus();
        MessageType messageType = null;
        if (!sameSettingsForAllStatus) {
            messageType = item.getMessageType();
        }
        return GWNotify.getInstance().getStatusSettingsPanelModel(sameSettingsForAllStatus ? MessageType.ANY : messageType, returnStatus);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append('[');
        builder.append((Object)this.dialogStatus);
        builder.append(';');
        if (this.soundPlaying) {
            builder.append("sound playing");
        }
        builder.append(';');
        if (this.programLaunching) {
            builder.append("program launching");
        }
        builder.append(']');
        return builder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DialogStatus {
        NONE,
        SHOWING,
        CLOSED_BY_USER,
        CLOSED_BY_TIMEOUT;

    }
}

