/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.notify.actions;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.GlobalCommand;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.orientable.MenuItemFactory;
import com.novell.gw.jclient.application.notify.actions.AbstractGroupWiseMenuNotifyAction;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.options.NotifierOptions;
import java.awt.CheckboxMenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;

public class ActionShowInTray
extends AbstractGroupWiseMenuNotifyAction
implements ItemListener {
    private static boolean trayIconSupported = OS.isTrayIconSupported();
    private JMenuItem menuItem;
    private CheckboxMenuItem checkboxMenuItem;

    public ActionShowInTray(ActionList actionList) {
        super(actionList, ActionKey.SHOW_IN_TRAY, OS.isMacOS() ? StringResources.SHOW_IN_MENU_BAR : StringResources.SHOW_IN_TRAY, false);
        this.setType(AppAction.ActionType.CHECKABLE);
        this.menuItem = MenuItemFactory.createCkeckBoxMenuItem(this);
        boolean selected = trayIconSupported && OptionManager.getInstance().getNotifierOptions().isShowInTray();
        this.menuItem.setSelected(selected);
        this.setEnabled(trayIconSupported && this.isEnabled());
        this.checkboxMenuItem = new CheckboxMenuItem(this.getName(), selected);
        this.checkboxMenuItem.addItemListener(this);
    }

    protected void registerListeners() {
        super.registerListeners();
        Level level = this.getController().getFrameLevel();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 1730, new NOTIFY_TRAY_ICON_VISIBILITY_CHANGED_Listener()));
    }

    protected void notifyEnablementChanged(boolean notifyEnabled) {
        this.setEnabled(trayIconSupported && notifyEnabled);
    }

    protected void performAction(ActionEvent e) {
        boolean selected = ((AbstractButton)e.getSource()).isSelected();
        this.doPerformAction(selected);
    }

    public void itemStateChanged(ItemEvent e) {
        boolean state = e.getStateChange() == 1;
        this.doPerformAction(state);
    }

    private void doPerformAction(boolean newState) {
        NotifierOptions options = OptionManager.getInstance().getNotifierOptions();
        options.setShowInTray(newState);
        OptionManager.getInstance().setNotifierOptions(options);
        this.getActionList().processCommand(new GlobalCommand(1730, newState));
    }

    public JMenuItem getMenuItem() {
        return this.menuItem;
    }

    public CheckboxMenuItem getCheckboxMenuItem() {
        return this.checkboxMenuItem;
    }

    private class NOTIFY_TRAY_ICON_VISIBILITY_CHANGED_Listener
    extends AppEventListener {
        private NOTIFY_TRAY_ICON_VISIBILITY_CHANGED_Listener() {
        }

        public void handle(AppEvent event) {
            boolean state = (Boolean)event.getData();
            ActionShowInTray.this.menuItem.setSelected(state);
            ActionShowInTray.this.checkboxMenuItem.setState(state);
        }
    }
}

