/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.notify.dialogs;

import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.MVCController;
import com.appframework.utils.ToolkitUtils;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialogController;
import com.novell.gw.jclient.application.controls.gwcalendar.DateAndTimeFormattingUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableSpinner;
import com.novell.gw.jclient.application.notify.NotifyController;
import com.novell.gw.jclient.application.notify.dialogs.AbstractNotifyDialog;
import com.novell.gw.jclient.application.notify.dialogs.NotificationDialogController;
import com.novell.gw.jclient.application.notify.enums.NotificationType;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWNotify;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import com.novell.gw.jclient.bl.om.items.NotificationItem;
import com.novell.gw.jclient.bl.om.options.NotifierOptions;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationDialog
extends AbstractNotifyDialog<NotificationDialogController> {
    private static Logger logger = Logger.getLogger(NotificationDialog.class);
    private static int INSET = 3;
    private static final int SNOOZE_INTERVAL = 5;
    private Timer timerCloser;
    private JPanel pnlMessage;
    private JPanel pnlButtons;
    private JLabel lbStatus = new OrientableLabel();
    private JSpinner spnSnoozeInterval;
    private NotificationItem item;
    private boolean closedByUser = true;

    public NotificationDialog(JFrame parentFrame, NotifyController parentController, NotificationItem notificationItem) {
        super(parentFrame, (MVCController)parentController, false);
        this.setModal(false);
        if (ToolkitUtils.isModalExclusionTypeSupported(ToolkitUtils.ModalExclusionType.APPLICATION_EXCLUDE)) {
            ToolkitUtils.setWindowModalExclusionType(this, ToolkitUtils.ModalExclusionType.APPLICATION_EXCLUDE);
        }
        if (parentController == null) {
            throw new IllegalArgumentException("parentController is null");
        }
        if (notificationItem == null) {
            throw new IllegalArgumentException("item is null");
        }
        this.item = notificationItem;
        this.setTitle(this.getDialogTitle());
        this.buildUI();
        int delay = GWNotify.getInstance().getNotifyDialogTimeout();
        this.timerCloser = new Timer(delay *= 1000, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                logger.debug((Object)"disposing dialog");
                NotificationDialog.this.closedByUser = false;
                NotificationDialog.this.dispose();
            }
        });
        this.timerCloser.setRepeats(false);
        this.timerCloser.start();
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e1) {
                    logger.error((Object)e1);
                }
                NotificationDialog.this.setFocusable(true);
                NotificationDialog.this.setFocusableWindowState(true);
                NotificationDialog.this.setResizable(true);
            }
        });
    }

    @Override
    protected NotificationDialogController createController(MVCController parentController) {
        return new NotificationDialogController(this, parentController);
    }

    @Override
    protected void processCloseAction(WindowEvent event) {
        super.processCloseAction(event);
        this.dispose();
    }

    private void buildUI() {
        this.buildMessagePanel();
        this.buildButtonsPanel();
        this.buildStatusBar();
        OrientablePanel pnlContent = new OrientablePanel();
        pnlContent.setLayout(new GridBagLayout());
        pnlContent.setBorder(BorderFactory.createEmptyBorder(INSET, INSET, INSET, INSET));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        pnlContent.add((Component)this.pnlMessage, c);
        c.gridy = 1;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 22;
        pnlContent.add((Component)this.pnlButtons, c);
        c.gridy = 2;
        c.fill = 2;
        c.anchor = 20;
        pnlContent.add((Component)this.lbStatus, c);
        this.setContentPane(pnlContent);
    }

    private void buildMessagePanel() {
        this.pnlMessage = new OrientablePanel();
        this.pnlMessage.setLayout(new GridBagLayout());
        Border border = BorderFactory.createLoweredBevelBorder();
        border = BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(INSET, INSET, INSET, INSET));
        this.pnlMessage.setBorder(border);
        OrientableLabel lbImage = new OrientableLabel(this.item.getBigIcon());
        OrientableLabel lbSender = new OrientableLabel(this.item.getFrom());
        Font generalFont = lbSender.getFont();
        Font senderFont = new Font(generalFont.getFontName(), generalFont.getStyle(), generalFont.getSize() + 10);
        lbSender.setFont(senderFont);
        OrientableLabel lbSubject = new OrientableLabel(this.item.getSubject());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 2;
        this.pnlMessage.add((Component)lbImage, c);
        c.gridx = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 21;
        this.pnlMessage.add((Component)lbSender, c);
        c.gridy = 1;
        this.pnlMessage.add((Component)lbSubject, c);
        if (this.item.isReturnStatus()) {
            OrientableLabel lbStatus = new OrientableLabel(this.getStatus());
            c.gridy = 2;
            this.pnlMessage.add((Component)lbStatus, c);
        } else if (this.item.isAlarm()) {
            String format = OptionManager.getInstance().getDateTimeOptions().getTimeFormat();
            String time = DateAndTimeFormattingUtils.formatDate(this.item.getDate(), format);
            OrientablePanel pnlAlarm = new OrientablePanel();
            pnlAlarm.setLayout(new GridLayout(1, 2));
            pnlAlarm.add(new OrientableLabel(time));
            pnlAlarm.add(new OrientableLabel(this.item.getLocation()));
            c.gridy = 2;
            this.pnlMessage.add((Component)pnlAlarm, c);
        }
    }

    private void buildButtonsPanel() {
        this.pnlButtons = new OrientablePanel(new GridBagLayout());
        this.pnlButtons.setBorder(BorderFactory.createEmptyBorder(INSET, 0, INSET, 0));
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.insets = new Insets(0, INSET, 0, INSET);
        OrientableButton btnClear = new OrientableButton(new ActionClear());
        this.pnlButtons.add((Component)btnClear, c);
        OrientableButton btnCloseAll = new OrientableButton(new ActionCloseAll());
        OrientableButton btnRead = new OrientableButton(new ActionRead());
        btnRead.setEnabled(this.item.canReadItem());
        if (this.item.isAlarm()) {
            this.pnlButtons.add((Component)btnRead, c);
            OrientableButton btnSnooze = new OrientableButton(new ActionSnooze());
            this.pnlButtons.add((Component)btnSnooze, c);
            this.spnSnoozeInterval = new OrientableSpinner(new SpinnerNumberModel(5, 1, 59, 1));
            this.spnSnoozeInterval.setBorder(BorderFactory.createLoweredBevelBorder());
            this.pnlButtons.add((Component)this.spnSnoozeInterval, c);
        } else {
            if (!this.item.isReturnStatus()) {
                this.pnlButtons.add((Component)btnRead, c);
                OrientableButton btnDelete = new OrientableButton(new ActionDelete());
                btnDelete.setEnabled(this.item.canDeleteItem());
                this.pnlButtons.add((Component)btnDelete, c);
            }
            this.pnlButtons.add((Component)btnCloseAll, c);
        }
        OrientableButton btnClose = new OrientableButton(new ActionClose());
        this.pnlButtons.add((Component)btnClose, c);
    }

    private void buildStatusBar() {
        String text = "";
        int count = GWNotify.getInstance().getNumberOfItems(NotificationType.MESSAGE);
        if (count > 0) {
            text = text + count + " " + StringResources.L_MESSAGE_S;
        }
        if ((count = GWNotify.getInstance().getNumberOfItems(NotificationType.APPOINTMENT)) > 0) {
            if (text.length() > 0) {
                text = text + ", ";
            }
            text = text + count + " " + StringResources.L_APPOINTMENT_S;
        }
        if ((count = GWNotify.getInstance().getNumberOfItems(NotificationType.ALARM)) > 0) {
            if (text.length() > 0) {
                text = text + ", ";
            }
            text = text + count + " " + StringResources.L_ALARM_S;
        }
        if ((count = GWNotify.getInstance().getNumberOfItems(NotificationType.RETURN_NOTIFICATION)) > 0) {
            if (text.length() > 0) {
                text = text + ", ";
            }
            text = text + count + " " + StringResources.L_RETURN_NOTIFICATION_S;
        }
        this.lbStatus.setText(text);
    }

    private String getDialogTitle() {
        if (this.item.isReturnStatus()) {
            return StringResources.MAIL_STATUS;
        }
        if (this.item.isAlarm()) {
            return StringResources.ALARM_FOR + ' ' + EngineCommandManager.getUserInfo().getName();
        }
        return StringResources.INCOMING + ' ' + this.item.getMessageType().getLocalizedSingularName();
    }

    private String getStatus() {
        String status = null;
        if (this.item.isReturnStatus()) {
            status = this.item.getReturnStatus().getLocalizedValue();
        }
        return status;
    }

    public void showMe() {
        this.setFocusable(false);
        this.setFocusableWindowState(false);
        Point position = OptionManager.getInstance().getNotifierOptions().getNotificationDialogPosition();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.pack();
        if (position == null) {
            logger.debug((Object)"bounds were not saved > calculating default bounds");
            logger.debug((Object)("INSET: " + INSET));
            int height = this.getMinimumSize().height + 30;
            int width = this.pnlButtons.getMinimumSize().width + 2 * INSET + 10;
            int x = (screenSize.width - width) / 2;
            int y = (screenSize.height - height) / 2;
            position = new Point(x, y);
            logger.debug((Object)("position: " + position));
        } else {
            Rectangle bounds = new Rectangle((int)position.getX(), (int)position.getY(), 0, 0);
            logger.debug((Object)("saved bounds: " + bounds));
            if (bounds.x + bounds.width > screenSize.width) {
                int x = screenSize.width - bounds.width;
                x = x < 0 ? 0 : x;
                bounds.setLocation(x, bounds.y);
            }
            if (bounds.y + bounds.height > screenSize.height) {
                int y = screenSize.height - bounds.height;
                y = y < 0 ? 0 : y;
                bounds.setLocation(bounds.x, y);
            }
            int buttonsPanelWidth = (int)this.pnlButtons.getPreferredSize().getWidth() + INSET * 4;
            this.setSize(new Dimension(buttonsPanelWidth, (int)this.getPreferredSize().getHeight()));
            position.setLocation((int)bounds.getX(), (int)bounds.getY());
            logger.debug((Object)("corrected bounds: " + bounds));
        }
        this.addComponentListener(new DialogPositionListener());
        this.setLocation(new Point((int)position.getX(), (int)position.getY()));
        this.setAlwaysOnTop(true);
        this.setVisible(true);
    }

    @Override
    public void dispose() {
        if (this.timerCloser == null) {
            super.dispose();
            return;
        }
        this.timerCloser.stop();
        this.timerCloser = null;
        NotifyController notifyController = GWClient.getNotifyController();
        if (notifyController != null) {
            notifyController.notificationDialogClosed(this.item, this.closedByUser);
        }
        logger.debug((Object)"disposing");
        super.dispose();
    }

    private class DialogPositionListener
    extends ComponentAdapter {
        private DialogPositionListener() {
        }

        public void componentMoved(ComponentEvent e) {
            if (e.getComponent().isVisible()) {
                this.updateOptions(e);
            }
        }

        public void componentResized(ComponentEvent e) {
            this.updateOptions(e);
        }

        private void updateOptions(ComponentEvent e) {
            int x = e.getComponent().getX();
            int y = e.getComponent().getY();
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            Point position = new Point(x, y);
            NotifierOptions options = OptionManager.getInstance().getNotifierOptions();
            options.setNotificationDialogPosition(position);
            OptionManager.getInstance().setNotifierOptions(options);
        }
    }

    private class ActionDelete
    extends AbstractAction {
        public ActionDelete() {
            super(StringResources.DELETE);
        }

        public void actionPerformed(ActionEvent e) {
            GWNotify.getInstance().deleteNotificationItem(NotificationDialog.this.item);
            GlobalCommand commandSize = new GlobalCommand(1570);
            ((ApplicationDialogController)NotificationDialog.this.getController()).processCommand(commandSize);
            NotificationDialog.this.dispose();
        }
    }

    private class ActionRead
    extends AbstractAction {
        public ActionRead() {
            super(StringResources.READ);
        }

        public void actionPerformed(ActionEvent e) {
            AbstractItem abstractItem = GWNotify.getInstance().readNotificationItem(NotificationDialog.this.item);
            MessageUtils.openItem(null, abstractItem, ControlsUtils.getUserGuid(((ApplicationDialogController)NotificationDialog.this.getController()).getParentController()));
            NotificationDialog.this.dispose();
        }
    }

    private class ActionClear
    extends AbstractAction {
        public ActionClear() {
            super(StringResources.CLEAR);
        }

        public void actionPerformed(ActionEvent e) {
            GWNotify.getInstance().clearNotificationItem(NotificationDialog.this.item);
            GlobalCommand commandSize = new GlobalCommand(1570);
            ((ApplicationDialogController)NotificationDialog.this.getController()).processCommand(commandSize);
            NotificationDialog.this.dispose();
        }
    }

    private class ActionSnooze
    extends AbstractAction {
        public ActionSnooze() {
            super(StringResources.SNOOZE);
        }

        public void actionPerformed(ActionEvent e) {
            int interval = (Integer)NotificationDialog.this.spnSnoozeInterval.getValue();
            logger.debug((Object)("snooze interval: " + interval));
            GWNotify.getInstance().snoozeItem(NotificationDialog.this.item, interval);
            NotificationDialog.this.dispose();
        }
    }

    private class ActionClose
    extends AbstractAction {
        public ActionClose() {
            super(StringResources.CLOSE);
        }

        public void actionPerformed(ActionEvent e) {
            NotificationDialog.this.dispose();
        }
    }

    private class ActionCloseAll
    extends AbstractAction {
        public ActionCloseAll() {
            super(StringResources.CLOSE_ALL);
        }

        public void actionPerformed(ActionEvent e) {
            GWClient.getNotifyController().closeAllNotificationDialogs();
            NotificationDialog.this.dispose();
        }
    }
}

