/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.notify.dialogs.options;

import com.appframework.mvc.MVCController;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableTabbedPane;
import com.novell.gw.jclient.application.notify.dialogs.AbstractNotifyDialog;
import com.novell.gw.jclient.application.notify.dialogs.options.AlarmsPane;
import com.novell.gw.jclient.application.notify.dialogs.options.GeneralPane;
import com.novell.gw.jclient.application.notify.dialogs.options.NotifyOptionsDialogController;
import com.novell.gw.jclient.application.notify.dialogs.options.NotifyOptionsDialogTabPane;
import com.novell.gw.jclient.application.notify.dialogs.options.NotifyPane;
import com.novell.gw.jclient.application.notify.dialogs.options.ReturnStatusPane;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import org.apache.log4j.Logger;

public class NotifyOptionsDialog
extends AbstractNotifyDialog {
    private static Logger logger = Logger.getLogger(NotifyOptionsDialog.class);
    private List<NotifyOptionsDialogTabPane> panels = new ArrayList<NotifyOptionsDialogTabPane>();
    private JTabbedPane tpMain;
    private boolean m_bOkayToRunThread = false;

    public NotifyOptionsDialog(JFrame parentFrame, MVCController parentController) {
        super(parentFrame, parentController, true);
        this.setTitle(StringResources.GROUPWISE_NOTIFY_OPTIONS);
        MessageUtils.showBusyCursor(true);
        this.buildUI();
        this.init();
        MessageUtils.showBusyCursor(false);
    }

    public static NotifyOptionsDialog showMe(JFrame parentFrame, MVCController parentController) {
        NotifyOptionsDialog dialog = new NotifyOptionsDialog(parentFrame, parentController);
        dialog.pack();
        UIUtils.centerWindowOnScreen(dialog);
        dialog.setVisible(true);
        return dialog;
    }

    protected NotifyOptionsDialogController createController(MVCController parentController) {
        return new NotifyOptionsDialogController(this, parentController);
    }

    private void init() {
        for (NotifyOptionsDialogTabPane panel : this.panels) {
            panel.init();
        }
    }

    private void buildUI() {
        JComponent pnlContent = (JComponent)this.getContentPane();
        pnlContent.setLayout(new BorderLayout(5, 5));
        this.tpMain = new OrientableTabbedPane();
        this.panels.add(new GeneralPane(this));
        this.panels.add(new NotifyPane(this));
        this.panels.add(new AlarmsPane(this));
        this.panels.add(new ReturnStatusPane(this));
        for (NotifyOptionsDialogTabPane panel : this.panels) {
            panel.buildUI();
            this.tpMain.addTab(panel.getTitle(), (Component)((Object)panel));
        }
        pnlContent.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pnlContent.add(this.tpMain);
        pnlContent.add((Component)this.buildButtonsPane(), "South");
    }

    private Container buildButtonsPane() {
        OrientablePanel pnlResult = new OrientablePanel(new FlowLayout(4));
        OS.addButtons(pnlResult, this.getBtnOk(), this.getBtnCancel(), this.getBtnApply());
        return pnlResult;
    }

    private void applyOptions() {
        for (NotifyOptionsDialogTabPane panel : this.panels) {
            panel.applyOptions();
        }
    }

    protected void processOkAction(ActionEvent event) {
        this.applyOptions();
        super.processOkAction(event);
    }

    protected void processApplyAction(ActionEvent event) {
        this.applyOptions();
    }

    public void resetNotifyDefaults() {
        logger.debug((Object)"reseting notify options");
        for (NotifyOptionsDialogTabPane panel : this.panels) {
            panel.resetToDefaults();
        }
        this.init();
    }

    public boolean getOkayToRunThread() {
        return this.m_bOkayToRunThread;
    }

    public void setOkayToRunThread() {
        this.m_bOkayToRunThread = true;
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (!b) {
            this.dispose();
        }
    }
}

