/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.notify.dialogs.options;

import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.notify.dialogs.options.MessageTypeListCellRenderer;
import com.novell.gw.jclient.application.notify.dialogs.options.NotifyOptionsDialog;
import com.novell.gw.jclient.application.notify.dialogs.options.NotifyOptionsDialogTabPane;
import com.novell.gw.jclient.application.notify.dialogs.options.SettingsPanel;
import com.novell.gw.jclient.application.notify.dialogs.options.SettingsPanelModel;
import com.novell.gw.jclient.application.notify.enums.MessageType;
import com.novell.gw.jclient.application.notify.enums.ReturnStatus;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWNotify;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.apache.log4j.Logger;

public class ReturnStatusPane
extends OrientablePanel
implements NotifyOptionsDialogTabPane {
    private static Logger logger = Logger.getLogger(ReturnStatusPane.class);
    private NotifyOptionsDialog dialog;
    private JComboBox cmbMessageTypes;
    private JCheckBox cbSameSettings;
    private SettingsPanel pnlOpenedStatus;
    private SettingsPanel pnlAcceptedStatus;
    private SettingsPanel pnlCompletedStatus;
    private SettingsPanel pnlDeletedStatus;
    private Map<MessageType, Map> panelModelMap = new HashMap<MessageType, Map>();
    private PrepThread m_prepThread = null;

    public ReturnStatusPane(NotifyOptionsDialog dialog) {
        this.dialog = dialog;
    }

    public void applyOptions() {
        logger.debug((Object)"applying options...");
        GWNotify.getInstance().setSameSettingsForAllStatus(this.cbSameSettings.isSelected());
        this.pnlOpenedStatus.updateModel();
        this.pnlAcceptedStatus.updateModel();
        this.pnlCompletedStatus.updateModel();
        this.pnlDeletedStatus.updateModel();
        this.saveSettingsPanelModels();
    }

    public void buildUI() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel pnlMessageTypes = this.buildMessageTypesPanel();
        this.pnlOpenedStatus = new SettingsPanel(StringResources.WHEN_OPENED);
        this.pnlOpenedStatus.buildUI();
        this.pnlOpenedStatus.buildDefaultBorder();
        this.pnlAcceptedStatus = new SettingsPanel(StringResources.WHEN_ACCEPTED);
        this.pnlAcceptedStatus.buildUI();
        this.pnlAcceptedStatus.buildDefaultBorder();
        this.pnlCompletedStatus = new SettingsPanel(StringResources.WHEN_COMPLETED);
        this.pnlCompletedStatus.buildUI();
        this.pnlCompletedStatus.buildDefaultBorder();
        this.pnlDeletedStatus = new SettingsPanel(StringResources.WHEN_DELETED);
        this.pnlDeletedStatus.buildUI();
        this.pnlDeletedStatus.buildDefaultBorder();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 21;
        this.add((Component)pnlMessageTypes, c);
        c.gridy = 1;
        c.anchor = 10;
        c.fill = 2;
        c.weightx = 1.0;
        this.add((Component)this.pnlOpenedStatus, c);
        c.gridy = 2;
        this.add((Component)this.pnlAcceptedStatus, c);
        c.gridy = 3;
        this.add((Component)this.pnlCompletedStatus, c);
        c.gridy = 4;
        c.weighty = 1.0;
        c.anchor = 19;
        this.add((Component)this.pnlDeletedStatus, c);
        this.doPrepThread();
    }

    public String getTitle() {
        return StringResources.RETURN_STATUS;
    }

    public void init() {
        MessageType msgType = this.getCurrentMessageType();
        if (msgType != null) {
            Map map = this.panelModelMap.get((Object)msgType);
            this.pnlOpenedStatus.setModel((SettingsPanelModel)map.get((Object)ReturnStatus.OPENED));
            this.pnlAcceptedStatus.setModel((SettingsPanelModel)map.get((Object)ReturnStatus.ACCEPTED));
            this.pnlCompletedStatus.setModel((SettingsPanelModel)map.get((Object)ReturnStatus.COMPLETED));
            this.pnlDeletedStatus.setModel((SettingsPanelModel)map.get((Object)ReturnStatus.DELETED));
        } else {
            this.cmbMessageTypes.setModel(this.getMessageTypesModel());
            this.cmbMessageTypes.setEnabled(!this.cbSameSettings.isSelected());
        }
    }

    public void resetToDefaults() {
        this.cbSameSettings.setSelected(GWNotify.getInstance().isDefaultSameSettingsForAllStatus());
        this.loadDefaultSettingsPanelModels();
        this.handleSameSettingsChange();
    }

    private JPanel buildMessageTypesPanel() {
        OrientablePanel panel = new OrientablePanel();
        panel.setLayout(new GridBagLayout());
        Border border = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        panel.setBorder(border);
        OrientableLabel lbCombobox = new OrientableLabel(StringResources.SETTINGS_FOR_C);
        this.cmbMessageTypes = new OrientableComboBox();
        this.cmbMessageTypes.setRenderer(new MessageTypeListCellRenderer(this.cmbMessageTypes.getRenderer()));
        this.cbSameSettings = new OrientableCheckBox(new ActionUseSameSettings());
        boolean sameSetings = GWNotify.getInstance().isSameSettingsForAllStatus();
        this.cbSameSettings.setSelected(sameSetings);
        this.cmbMessageTypes.addItemListener(new MessageTypeItemListener());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        constraints.weightx = 0.0;
        constraints.gridwidth = 1;
        panel.add((Component)lbCombobox, constraints);
        constraints.gridwidth = -1;
        panel.add((Component)this.cmbMessageTypes, constraints);
        constraints.weightx = 1.0;
        constraints.gridwidth = 0;
        panel.add((Component)this.cbSameSettings, constraints);
        return panel;
    }

    private void handleSameSettingsChange() {
        this.cmbMessageTypes.setModel(this.getMessageTypesModel());
        this.cmbMessageTypes.setEnabled(!this.cbSameSettings.isSelected());
        this.handleMesageTypeChanged();
    }

    private void handleMesageTypeChanged() {
        logger.debug((Object)("selected type: " + (Object)((Object)this.getCurrentMessageType())));
        this.init();
    }

    private void loadSettingsPanelModels() {
        this.panelModelMap.clear();
        MessageType[] types = MessageType.getConfigurableMessageTypes();
        GWNotify notify = GWNotify.getInstance();
        for (MessageType type : types) {
            ReturnStatus[] statuses;
            HashMap<ReturnStatus, SettingsPanelModel> statusToModelMap = new HashMap<ReturnStatus, SettingsPanelModel>();
            for (ReturnStatus status : statuses = ReturnStatus.getConfigurableReturnStatuses()) {
                statusToModelMap.put(status, notify.getStatusSettingsPanelModel(type, status));
            }
            this.panelModelMap.put(type, statusToModelMap);
        }
    }

    private void loadDefaultSettingsPanelModels() {
        this.panelModelMap.clear();
        MessageType[] types = MessageType.getConfigurableMessageTypes();
        GWNotify notify = GWNotify.getInstance();
        for (MessageType type : types) {
            ReturnStatus[] statuses;
            HashMap<ReturnStatus, SettingsPanelModel> statusToModelMap = new HashMap<ReturnStatus, SettingsPanelModel>();
            for (ReturnStatus status : statuses = ReturnStatus.getConfigurableReturnStatuses()) {
                statusToModelMap.put(status, notify.getDefaultStatusSettingsPanelModel(type, status));
            }
            this.panelModelMap.put(type, statusToModelMap);
        }
    }

    private void saveSettingsPanelModels() {
        MessageType[] types = MessageType.getConfigurableMessageTypes();
        GWNotify notify = GWNotify.getInstance();
        for (MessageType type : types) {
            ReturnStatus[] statuses;
            Map statusToModelMap = this.panelModelMap.get((Object)type);
            for (ReturnStatus status : statuses = ReturnStatus.getConfigurableReturnStatuses()) {
                SettingsPanelModel model = (SettingsPanelModel)statusToModelMap.get((Object)status);
                if (model == null || !model.isModified()) continue;
                notify.setStatusSettingsPanelModel(model, type, status);
                model.reset();
            }
        }
    }

    private DefaultComboBoxModel getMessageTypesModel() {
        if (this.cbSameSettings.isSelected()) {
            return new DefaultComboBoxModel<MessageType>(new MessageType[]{MessageType.ANY});
        }
        return new DefaultComboBoxModel<MessageType>(MessageType.getRegularMessageTypes());
    }

    private MessageType getCurrentMessageType() {
        return (MessageType)((Object)this.cmbMessageTypes.getSelectedItem());
    }

    private void doPrepThread() {
        this.m_prepThread = new PrepThread();
        this.m_prepThread.start();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.m_prepThread.waitForCounting();
    }

    private class PrepThread
    extends Thread {
        private boolean m_bPrepThreadRunning = false;

        PrepThread() {
        }

        public void run() {
            this.m_bPrepThreadRunning = true;
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ReturnStatusPane.this.dialog.invalidate();
                        ReturnStatusPane.this.dialog.repaint();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                while (!ReturnStatusPane.this.dialog.getOkayToRunThread()) {
                    Thread.sleep(20L);
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ReturnStatusPane.this.loadSettingsPanelModels();
                        ReturnStatusPane.this.handleSameSettingsChange();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.m_bPrepThreadRunning = false;
        }

        private void waitForCounting() {
            while (this.m_bPrepThreadRunning) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {
                    return;
                }
            }
        }
    }

    private class MessageTypeItemListener
    implements ItemListener {
        private MessageTypeItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                ReturnStatusPane.this.handleMesageTypeChanged();
            }
        }
    }

    private class ActionUseSameSettings
    extends AbstractAction {
        public ActionUseSameSettings() {
            super(StringResources.USE_SAME_SETTINGS_FOR_ALL_TYPES);
        }

        public void actionPerformed(ActionEvent e) {
            ReturnStatusPane.this.handleSameSettingsChange();
        }
    }
}

