/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.options;

import com.novell.gw.jclient.application.ColorScheme;
import com.novell.gw.jclient.application.controls.itemview.QuickViewerLocation;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class AppearanceSettings {
    private static Logger logger = Logger.getLogger(AppearanceSettings.class);
    private GWCommandManager commandManager;
    public static int DEFAULT_COLOR_SCHEME_ID = 1;
    public static Set<Integer> AVAILABLE_COLOR_SCHEME_IDS = new HashSet<Integer>();

    public AppearanceSettings(GWCommandManager commandManager) {
        if (commandManager == null) {
            throw new IllegalArgumentException("commandManager is null");
        }
        this.commandManager = commandManager;
    }

    public boolean isNavBarVisible() {
        return (Boolean)this.commandManager.getDataStoreSettings().getShowNavBar().getValue();
    }

    public boolean isLockedNavBarVisibility() {
        return this.commandManager.getDataStoreSettings().getShowNavBar().isLocked();
    }

    public void setNavBarVisible(boolean visible) {
        if (!this.commandManager.getDataStoreSettings().getShowNavBar().isLocked()) {
            if (!visible && !this.isMainMenuVisible()) {
                return;
            }
            this.commandManager.getDataStoreSettings().setShowNavBar(visible);
        }
    }

    public boolean isMainMenuVisible() {
        return (Boolean)this.commandManager.getDataStoreSettings().getShowMainMenu().getValue();
    }

    public boolean isLockedMainMenuVisibility() {
        return this.commandManager.getDataStoreSettings().getShowMainMenu().isLocked();
    }

    public void setMainMenuVisible(boolean visible) {
        if (!this.commandManager.getDataStoreSettings().getShowMainMenu().isLocked()) {
            if (!visible && !this.isNavBarVisible()) {
                return;
            }
            this.commandManager.getDataStoreSettings().setShowMainMenu(visible);
        }
    }

    public boolean isMainToolBarVisible() {
        return (Boolean)this.commandManager.getDataStoreSettings().getShowMainToolBar().getValue();
    }

    public boolean isLockedMainToolBarVisibility() {
        return this.commandManager.getDataStoreSettings().getShowMainToolBar().isLocked();
    }

    public void setMainToolBarVisible(boolean visible) {
        if (!this.commandManager.getDataStoreSettings().getShowMainToolBar().isLocked()) {
            this.commandManager.getDataStoreSettings().setShowMainToolBar(visible);
        }
    }

    public boolean isFolderTreeVisible() {
        return (Boolean)this.commandManager.getDataStoreSettings().getShowFolderTree().getValue();
    }

    public boolean isLockedFolderTreeVisibility() {
        return this.commandManager.getDataStoreSettings().getShowFolderTree().isLocked();
    }

    public void setFolderTreeVisible(boolean visible) {
        if (!this.commandManager.getDataStoreSettings().getShowFolderTree().isLocked()) {
            this.commandManager.getDataStoreSettings().setShowFolderTree(visible);
        }
    }

    public boolean isFolderTreeLong() {
        return (Boolean)this.commandManager.getDataStoreSettings().getShowFolderTreeLong().getValue();
    }

    public boolean isLockedFolderTreeLength() {
        return this.commandManager.getDataStoreSettings().getShowFolderTreeLong().isLocked();
    }

    public void setFolderTreeLong(boolean longTree) {
        if (!this.commandManager.getDataStoreSettings().getShowFolderTreeLong().isLocked()) {
            this.commandManager.getDataStoreSettings().setShowFolderTreeLong(longTree);
        }
    }

    public boolean isQuickViewerVisible() {
        return (Boolean)this.commandManager.getDataStoreSettings().getShowQuickViewer().getValue();
    }

    public boolean isLockedQuickViewerVisibility() {
        return this.commandManager.getDataStoreSettings().getShowQuickViewer().isLocked();
    }

    public void setQuickViewerVisible(boolean visible) {
        if (!this.commandManager.getDataStoreSettings().getShowQuickViewer().isLocked()) {
            this.commandManager.getDataStoreSettings().setShowQuickViewer(visible);
        }
    }

    public QuickViewerLocation getQuickViewerLocation() {
        return QuickViewerLocation.getQuickViewerLocation((Integer)this.commandManager.getDataStoreSettings().getQuickViewerPosition().getValue());
    }

    public boolean isLockedQuickViewerLocation() {
        return this.commandManager.getDataStoreSettings().getQuickViewerPosition().isLocked();
    }

    public void setQuickViewerLocation(QuickViewerLocation location) {
        if (!this.commandManager.getDataStoreSettings().getQuickViewerPosition().isLocked()) {
            this.commandManager.getDataStoreSettings().setQuickViewerPosition(location.getId());
        }
    }

    public ColorScheme getColorScheme() {
        int apiId = this.commandManager.getDataStoreSettings().getGWColorScheme();
        if (!AVAILABLE_COLOR_SCHEME_IDS.contains(apiId)) {
            this.commandManager.getDataStoreSettings().getGWColor(10);
            apiId = this.commandManager.getDataStoreSettings().getGWColorScheme();
            if (!AVAILABLE_COLOR_SCHEME_IDS.contains(apiId)) {
                apiId = DEFAULT_COLOR_SCHEME_ID;
            }
        }
        return ColorScheme.geEnum(apiId);
    }

    public void setColorScheme(int schemeId) {
        this.commandManager.getDataStoreSettings().setGWColorScheme(schemeId);
    }

    static {
        AVAILABLE_COLOR_SCHEME_IDS.add(1);
        AVAILABLE_COLOR_SCHEME_IDS.add(2);
        AVAILABLE_COLOR_SCHEME_IDS.add(3);
        AVAILABLE_COLOR_SCHEME_IDS.add(4);
        AVAILABLE_COLOR_SCHEME_IDS.add(5);
        AVAILABLE_COLOR_SCHEME_IDS.add(6);
    }
}

