/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.options;

import com.novell.gw.jclient.application.options.ApplicationOptions;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import org.apache.log4j.Logger;

public class WindowBoundsListener
extends ComponentAdapter {
    private static final Logger logger = Logger.getLogger(WindowBoundsListener.class);
    private static ApplicationOptions OPTIONS = ApplicationOptions.getInstance();
    protected String WINX_KEY;
    protected String WINY_KEY;
    protected String WINH_KEY;
    protected String WINW_KEY;

    public WindowBoundsListener(String theWindowPrefix) {
        String prefix = theWindowPrefix + '.';
        this.WINX_KEY = prefix + "WIN_X";
        this.WINY_KEY = prefix + "WIN_Y";
        this.WINH_KEY = prefix + "WIN_HEIGHT";
        this.WINW_KEY = prefix + "WIN_WIDTH";
    }

    public void componentResized(ComponentEvent e) {
        int height = e.getComponent().getHeight();
        OPTIONS.put(this.WINH_KEY, new Integer(height));
        int width = e.getComponent().getWidth();
        OPTIONS.put(this.WINW_KEY, new Integer(width));
    }

    public void componentMoved(ComponentEvent e) {
        if (e.getComponent().isVisible()) {
            int Y;
            int X = e.getComponent().getX();
            if (X >= 0) {
                OPTIONS.put(this.WINX_KEY, new Integer(X));
            }
            if ((Y = e.getComponent().getY()) >= 0) {
                OPTIONS.put(this.WINY_KEY, new Integer(Y));
            }
        }
    }
}

