/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.plaf;

import com.novell.gw.jclient.application.controls.folderstree.MainGWFoldersTree;
import com.novell.gw.jclient.application.controls.folderstree.TreeUtils;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.SubCalendarFolder;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.VariableHeightLayoutCache;

public class FoldersTreeUI
extends BasicTreeUI {
    private boolean isLeftToRight = false;
    private int sign = -1;
    public static final int NODE_SHIFT = 16;
    private boolean isLocationInExpandControl;

    protected void prepareForUIInstall() {
        super.prepareForUIInstall();
        this.isLeftToRight = this.tree.getComponentOrientation().isLeftToRight();
        this.sign = this.isLeftToRight ? 1 : -1;
    }

    protected boolean isLocationInExpandControl(TreePath path, int mouseX, int mouseY) {
        this.isLocationInExpandControl = super.isLocationInExpandControl(path, mouseX, mouseY);
        return this.isLocationInExpandControl;
    }

    public boolean isLocationInExpandControl() {
        return this.isLocationInExpandControl;
    }

    public static ComponentUI createUI(JComponent x) {
        return new FoldersTreeUI();
    }

    protected void selectPathForEvent(TreePath path, MouseEvent event) {
        AbstractFolder folder;
        Object userObject;
        if (path != null && (userObject = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()) instanceof AbstractFolder && (folder = (AbstractFolder)userObject) instanceof SubCalendarFolder && (MainGWFoldersTree.isCheckBoxClicked(event, this.getCellRenderer(), this.getPathBounds(this.tree, path)) || MainGWFoldersTree.isColorClicked(event, this.getCellRenderer(), this.getPathBounds(this.tree, path)))) {
            return;
        }
        super.selectPathForEvent(path, event);
    }

    protected void paintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        if (path.getLastPathComponent() != this.tree.getModel().getRoot()) {
            int nodeShift = TreeUtils.getShift(this.tree, path);
            if (this.isLeftToRight) {
                bounds.x += nodeShift;
            }
            bounds.width -= nodeShift;
        }
        super.paintRow(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
    }

    protected int getHorizontalLegBuffer() {
        return super.getHorizontalLegBuffer() - 16;
    }

    protected int getVerticalLegBuffer() {
        return super.getVerticalLegBuffer() - 8;
    }

    protected AbstractLayoutCache createLayoutCache() {
        return new ShiftedHeightLayoutCache();
    }

    public Rectangle getPathBounds(JTree tree, TreePath path) {
        Rectangle bounds = super.getPathBounds(tree, path);
        if (bounds != null && this.isLeftToRight) {
            bounds.x += TreeUtils.getShift(tree, path);
        }
        return bounds;
    }

    protected boolean startEditing(TreePath path, MouseEvent event) {
        boolean res = super.startEditing(path, event);
        if (this.editingComponent instanceof JPanel) {
            JPanel pnl = (JPanel)this.editingComponent;
            if (!this.isLeftToRight) {
                Rectangle nodeBounds = this.getPathBounds(this.tree, path);
                int x = nodeBounds.x - TreeUtils.getShift(this.tree, path);
                pnl.setBounds(x + 4, nodeBounds.y, nodeBounds.width, nodeBounds.height);
            }
            int size = pnl.getComponentCount();
            for (int i = 0; i < size; ++i) {
                if (!(pnl.getComponent(i) instanceof JTextField)) continue;
                ((JTextField)pnl.getComponent(i)).requestFocus(true);
                break;
            }
        }
        return res;
    }

    private class ShiftedHeightLayoutCache
    extends VariableHeightLayoutCache {
        private ShiftedHeightLayoutCache() {
        }

        public Rectangle getBounds(TreePath path, Rectangle placeIn) {
            Rectangle rect = super.getBounds(path, placeIn);
            if (rect != null && path.getLastPathComponent() != this.treeModel.getRoot()) {
                int shift = TreeUtils.getShift(FoldersTreeUI.this.tree, path);
                rect.width += shift;
                if (!FoldersTreeUI.this.isLeftToRight) {
                    rect.x = rect.x + (shift == 0 ? 0 : FoldersTreeUI.this.sign * shift);
                }
            }
            return rect;
        }

        public int getPreferredWidth(Rectangle bounds) {
            int preferredWidth = super.getPreferredWidth(bounds);
            return preferredWidth + 16;
        }
    }
}

