/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.basicforms;

import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.options.OptionManager;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.print.Printable;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public abstract class PrintForm
extends JPanel
implements Printable {
    private static Logger logger = Logger.getLogger(PrintForm.class);
    protected static final int DEFAULT_RESOLUTION = 72;
    protected static final double SCALE_FACTOR = (double)Toolkit.getDefaultToolkit().getScreenResolution() / 72.0;
    protected static final int HEADER_FIELDS_GAP = 10;
    protected static Font FNT_HEADER = OptionManager.getInstance().getPrintingOptions().getFntHeader();
    protected static Font FNT_SUB_HEADER = OptionManager.getInstance().getPrintingOptions().getFntSubHeader();
    public static Font FNT_PLAIN = OptionManager.getInstance().getPrintingOptions().getFntPlainTxt();
    protected int commonHeaderH;
    protected int pageHeight;
    protected int pageWidth;
    protected static final int dx = 5;
    public static boolean isLeftToRight = UIUtils.getComponentOrientation().isLeftToRight();
    protected boolean isPreview = false;

    protected int printCommonHeader(Graphics pg, int pageIndex, int wPage) {
        return this.printCommonHeader(pg, pageIndex, wPage, 0, 0);
    }

    protected int printCommonHeader(Graphics pg, int pageIndex, int wPage, int x, int y) {
        return 0;
    }

    protected void printCommonFooter(Graphics pg, int pageIndex, int wPage) {
    }

    public ImageIcon getIcon() {
        return null;
    }

    public void onPrintBegin() {
    }

    protected void paintHeaderRow(Graphics graphics, String title, String value, int y) {
        this.paintHeaderRow(graphics, title, value, y, graphics.getFont(), graphics.getFont());
        int titleWidth = (int)graphics.getFontMetrics().getStringBounds(title, graphics).getWidth();
        if (UIUtils.getComponentOrientation().isLeftToRight()) {
            graphics.drawString(title, 0, y);
            graphics.drawString(value, titleWidth + 5, y);
        } else {
            graphics.drawString(title, this.pageWidth - titleWidth, y);
            int valueWidth = (int)graphics.getFontMetrics().getStringBounds(value, graphics).getWidth();
            graphics.drawString(value, this.pageWidth - titleWidth - valueWidth - 5, y);
        }
    }

    protected void paintHeaderRow(Graphics graphics, String title, String value, int y, Font titleFont, Font valueFont) {
        if (value == null) {
            value = "";
        }
        int titleWidth = (int)graphics.getFontMetrics().getStringBounds(title, graphics).getWidth();
        if (UIUtils.getComponentOrientation().isLeftToRight()) {
            graphics.setFont(titleFont);
            graphics.drawString(title, 0, y);
            graphics.setFont(valueFont);
            graphics.drawString(value, titleWidth + 5, y);
        } else {
            graphics.setFont(titleFont);
            graphics.drawString(title, this.pageWidth - titleWidth, y);
            int valueWidth = (int)graphics.getFontMetrics().getStringBounds(value, graphics).getWidth();
            graphics.setFont(valueFont);
            graphics.drawString(value, this.pageWidth - titleWidth - valueWidth - 5, y);
        }
    }

    protected void drawAlignedString(Graphics graphics, String str, int x, int y, int width) {
        int strWidth;
        if (!isLeftToRight && width > (strWidth = (int)graphics.getFontMetrics().getStringBounds(str, graphics).getWidth())) {
            x += width - strWidth;
        }
        graphics.drawString(str, x, y);
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public void setPreview(boolean isPreviewOnly) {
        this.isPreview = isPreviewOnly;
    }
}

