/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.printingaddressbook;

import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.application.printing.BasicPrintManager;
import com.novell.gw.jclient.application.printing.basicforms.AddressBookForm;
import com.novell.gw.jclient.application.printing.basicforms.PrintForm;
import com.novell.gw.jclient.application.printing.printingaddressbook.AddressBookChecksPanel;
import com.novell.gw.jclient.application.printing.printingaddressbook.AddressBookPrintManagerController;
import com.novell.gw.jclient.application.printing.printingaddressbook.printforms.AddressPhone;
import com.novell.gw.jclient.application.printing.printingaddressbook.printforms.LabelsForm;
import com.novell.gw.jclient.application.printing.printingaddressbook.printforms.MailingAddress;
import com.novell.gw.jclient.application.printing.printingaddressbook.printforms.MultipleItems;
import com.novell.gw.jclient.application.resources.StringResources;
import java.util.List;
import java.util.Vector;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class AddressBookPrintManager
extends BasicPrintManager {
    private static Logger logger = Logger.getLogger(AddressBookPrintManager.class);
    private AddressBookChecksPanel addressBookChecksPanel;
    public static final int LIST_PRINTING = 0;
    public static final int PHONES_PRINTING = 1;
    public static final int LABELS_PRINTING = 2;
    public static final int MAIL_ADDRESS_PRINTING = 3;
    private int printingType = 0;
    protected List<IAddressable> selectedContacts = null;

    public AddressBookPrintManager(MVCController theParentController) {
        this.setController(new AddressBookPrintManagerController(this, theParentController));
        this.buildUI();
    }

    private void buildUI() {
        this.buildSelectionPanel();
        this.buildContentPanel();
        this.lstPrintingItems.addListSelectionListener(new LstPrintingItemsChanged());
        this.lstPrintingForms.addListSelectionListener(new LstPrintingFormsChanged());
    }

    protected void buildContentPanel() {
        this.addressBookChecksPanel = new AddressBookChecksPanel(this.getController());
        this.add(StringResources.CONTENT, this.addressBookChecksPanel);
    }

    private void refreshSelectionPanel() {
        this.vPrintingItems = new Vector();
        this.vPrintingItems.add(StringResources.LIST);
        this.lstPrintingItems.setListData(this.vPrintingItems);
        this.lstPrintingItems.setSelectedIndex(0);
        this.printingType = 0;
        this.lstPrintingForms.setListData(this.getPrintForms());
        this.lstPrintingForms.setSelectedIndex(0);
        int x = this.lstPrintingForms.getSelectedIndex();
        if (x < 0) {
            x = 0;
        }
        this.selectedForm = (PrintForm)this.lstPrintingForms.getModel().getElementAt(x);
        this.lbPreview.setIcon(this.selectedForm.getIcon());
        this.pnlListSelection.validate();
    }

    private Vector getPrintForms() {
        Vector<AddressBookForm> v = new Vector<AddressBookForm>();
        if (this.printingType == 0) {
            MultipleItems mi = new MultipleItems(this.selectedContacts, this.getController());
            mi.setMVCModel(this.addressBookChecksPanel);
            v.add(mi);
            AddressPhone ap = new AddressPhone(this.selectedContacts, this.getController());
            ap.setMVCModel(this.addressBookChecksPanel);
            v.add(ap);
            ap = new AddressPhone(this.selectedContacts, AddressPhone.ADDRESS_PHONE, this.getController());
            ap.setMVCModel(this.addressBookChecksPanel);
            v.add(ap);
            mi = new MultipleItems(this.selectedContacts, true, this.getController());
            mi.setMVCModel(this.addressBookChecksPanel);
            v.add(mi);
        } else if (this.printingType == 2) {
            LabelsForm lf = new LabelsForm(this.selectedContacts, this.getController());
            lf.setMVCModel(this.addressBookChecksPanel);
            v.add(lf);
            MailingAddress ma = new MailingAddress(this.selectedContacts, this.getController());
            ma.setMVCModel(this.addressBookChecksPanel);
            v.add(ma);
        }
        return v;
    }

    public void setMVCModel(Object theModel) {
        if (theModel instanceof List) {
            this.selectedContacts = (List)theModel;
            this.refreshSelectionPanel();
        }
    }

    class LstPrintingFormsChanged
    implements ListSelectionListener {
        LstPrintingFormsChanged() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                int x = AddressBookPrintManager.this.lstPrintingForms.getSelectedIndex();
                if (x < 0) {
                    return;
                }
                AddressBookPrintManager.this.selectedForm = (PrintForm)AddressBookPrintManager.this.lstPrintingForms.getModel().getElementAt(x);
                AddressBookPrintManager.this.lbPreview.setIcon(AddressBookPrintManager.this.selectedForm.getIcon());
                Command com = new Command(290, AddressBookPrintManager.this.selectedForm);
                AddressBookPrintManager.this.getController().processCommand(com);
                com = AddressBookPrintManager.this.selectedForm instanceof AddressPhone ? new Command(300, new Integer(1)) : (AddressBookPrintManager.this.selectedForm instanceof MailingAddress ? new Command(300, new Integer(3)) : new Command(300, new Integer(AddressBookPrintManager.this.printingType)));
                AddressBookPrintManager.this.controller.processCommand(com);
            }
        }
    }

    class LstPrintingItemsChanged
    implements ListSelectionListener {
        LstPrintingItemsChanged() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                int x = AddressBookPrintManager.this.lstPrintingItems.getSelectedIndex();
                if (x == 0) {
                    AddressBookPrintManager.this.printingType = 0;
                } else if (x == 1) {
                    AddressBookPrintManager.this.printingType = 2;
                }
                AddressBookPrintManager.this.lstPrintingForms.setListData(AddressBookPrintManager.this.getPrintForms());
                AddressBookPrintManager.this.lstPrintingForms.setSelectedIndex(0);
            }
        }
    }
}

