/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.printingcalendar.printforms;

import com.appframework.mvc.MVCController;
import com.appframework.utils.Day;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.CalendarForm;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.AbstractCalendarItem;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.ReminderNote;
import com.novell.gw.jclient.bl.om.items.TaskItem;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DailyListForm
extends CalendarForm {
    protected int dayPageIndex = -1;
    private int firstDayOnPage = 0;
    private int firstDayOnPageCopy = 0;
    private int lastDayOnPage = -1;
    protected int firstAllDayEventOnPage = 0;
    protected int firstAllDayEventOnPageCopy = 0;
    protected int lastAllDayEventOnPage = 0;
    private int lastAllDayEventOnPageCopy = 0;
    protected boolean isPrintingAllDayEventsFinished = true;
    protected boolean isPrintingAllDayEventsFinishedCopy = true;
    protected int firstAppointmentOnPage = 0;
    protected int firstAppointmentOnPageCopy = 0;
    protected int lastAppointmentOnPage = 0;
    private int lastAppointmentOnPageCopy = 0;
    protected boolean isPrintingAppointmentsFinished = true;
    protected boolean isPrintingAppointmentsFinishedCopy = true;
    private int firstTaskOnPage = 0;
    private int firstTaskOnPageCopy = 0;
    private int lastTaskOnPageCopy = 0;
    private int lastTaskOnPage = 0;
    private boolean isPrintingTasksFinished = true;
    private boolean isPrintingTasksFinishedCopy = true;
    private int firstReminderNoteOnPage = 0;
    private int firstReminderNoteOnPageCopy = 0;
    private int lastReminderNoteOnPage = 0;
    private int lastReminderNoteOnPageCopy = 0;
    private boolean isPrintingReminderNotesFinished = true;
    private boolean isPrintingReminderNotesFinishedCopy = true;
    protected static int DATE_WIDTH = 80;
    protected static final int CELL_WIDTH = 80;
    protected static final int PLACE_WIDTH = 100;
    private boolean isPrintingDayFinished = false;
    private boolean isPrintingDayFinishedCopy = false;
    protected int printingY = 0;
    private boolean isPrintFirstTime = true;
    private boolean isPrintingLastDay = false;
    protected boolean isPriningNewPage = true;
    protected Calendar gcDay;
    private Calendar gcDayCopy;
    private static int H_GAP = 4;
    private AbstractFolder folder;
    private IItemList itemList;

    public DailyListForm(MVCController theParentController) {
        this.setController(theParentController);
        try {
            this.folder = GWCommandManager.getInstance(ControlsUtils.getUserGuid(this.getController())).getCalendarFolder();
            this.itemList = this.folder.getItemList();
        }
        catch (GWCommandException e) {
            ErrorDialog.processGWException(e);
        }
    }

    @Override
    boolean pageExists(int pageIndex) {
        boolean pageExist = true;
        if (pageIndex > this.dayPageIndex && this.isPrintingDayFinished) {
            if (this.lastDayOnPage + 1 >= printingCalendarPanel.getDaysForPrinting()) {
                this.firstDayOnPage = this.lastDayOnPage + 1;
                this.isPrintFirstTime = true;
                System.gc();
                pageExist = false;
            }
        }
        return pageExist;
    }

    public AbstractFolder getFolder() {
        return this.folder;
    }

    public IItemList getItemList() {
        return this.itemList;
    }

    @Override
    public int print(Graphics pg, PageFormat pageFormat, int pageIndex) throws PrinterException {
        block11: {
            super.print(pg, pageFormat, pageIndex);
            boolean bContinue = false;
            if (pageIndex > this.dayPageIndex && this.isPrintingDayFinished) {
                this.firstDayOnPage = this.lastDayOnPage + 1;
                if (this.firstDayOnPage >= printingCalendarPanel.getDaysForPrinting()) {
                    this.isPrintFirstTime = true;
                    System.gc();
                    return 1;
                }
            }
            this.refreshPrint(pageIndex);
            if (!this.isPrintingDayFinished) {
                if (this.firstDayOnPage == printingCalendarPanel.getDaysForPrinting()) {
                    --this.firstDayOnPage;
                    this.isPrintingLastDay = true;
                }
            }
            int i = this.firstDayOnPage;
            do {
                if (i >= printingCalendarPanel.getDaysForPrinting()) break block11;
                if (this.isPrintingDayFinished) {
                    this.gcDay.add(5, 1);
                    this.lastDayOnPage = i++;
                    this.beforePrintNewDay();
                }
                if (this.isPrintingLastDay) {
                    i = ++this.firstDayOnPage;
                }
                pg.setFont(FNT_HEADER);
                FontMetrics fm = pg.getFontMetrics();
                int y = this.printingY;
                this.paintHeaderRow(pg, StringResources.DATE_C, OptionManager.getInstance().getDateTimeOptions().getGeneralDateString(this.gcDay.getTime()), y);
                this.printingY += fm.getHeight() + 10;
                if (printingCalendarPanel.hasAllDayEvents() && (bContinue = this.printAllDayEvents(pg)) && !this.isPrintingAllDayEventsFinished) {
                    return 0;
                }
                if (printingCalendarPanel.hasAppointments() && (bContinue = this.printAppointments(pg)) && !this.isPrintingAppointmentsFinished) {
                    return 0;
                }
                if (printingCalendarPanel.hasTasks() && (bContinue = this.printTasks(pg)) && !this.isPrintingTasksFinished) {
                    return 0;
                }
                if (printingCalendarPanel.hasNotes() && (bContinue = this.printReminderNotes(pg)) && !this.isPrintingReminderNotesFinished) {
                    return 0;
                }
                this.isPrintingDayFinished = true;
            } while (!printingCalendarPanel.isStartDayFromNewPage());
            Runtime.getRuntime().gc();
            return 0;
        }
        this.isPrintingDayFinished = true;
        return 0;
    }

    @Override
    public void onPrintBegin() {
        if (printingCalendarPanel.getPrintingType() == 0) {
            this.gcDay = (Calendar)printingCalendarPanel.getCurrentDay().clone();
        } else if (printingCalendarPanel.getPrintingType() == 1) {
            this.gcDay = (Calendar)printingCalendarPanel.getCurrentWeek().clone();
        } else if (printingCalendarPanel.getPrintingType() == 2) {
            this.gcDay = (Calendar)printingCalendarPanel.getCurrentMonth().clone();
        }
        this.gcDay.add(5, -1);
        this.dayPageIndex = -1;
        this.isPrintingLastDay = false;
        this.lastDayOnPage = -1;
        this.firstDayOnPage = -1;
        this.firstAllDayEventOnPage = 0;
        this.lastAllDayEventOnPage = -1;
        this.isPrintingAllDayEventsFinished = true;
        this.firstAppointmentOnPage = 0;
        this.lastAppointmentOnPage = -1;
        this.isPrintingAppointmentsFinished = true;
        this.firstTaskOnPage = 0;
        this.lastTaskOnPage = -1;
        this.isPrintingTasksFinished = true;
        this.firstReminderNoteOnPage = 0;
        this.lastReminderNoteOnPage = -1;
        this.isPrintingReminderNotesFinished = true;
        this.isPrintingDayFinished = true;
        this.printingY = 0;
        this.isPrintFirstTime = false;
        this.isPriningNewPage = true;
        this.findAdditionsLength();
    }

    private void findAdditionsLength() {
        BufferedImage bi = new BufferedImage(1000, 100, 2);
        Graphics g = bi.getGraphics();
        g.setFont(FNT_PLAIN);
        FontMetrics fm = g.getFontMetrics();
        Calendar gc = GWCalendarUtils.getToday();
        gc.set(5, 29);
        gc.set(2, 11);
        gc.set(1, 0);
        gc.set(11, 11);
        gc.set(12, 59);
        String testString = OptionManager.getInstance().getDateTimeOptions().getGeneralDateString(gc.getTime());
        DATE_WIDTH = (int)fm.getStringBounds(testString, g).getWidth() + 20;
    }

    protected void beforePrintNewDay() {
        this.firstDayOnPage = this.lastDayOnPage + 1;
        this.isPrintingDayFinished = false;
        this.isPrintingAllDayEventsFinished = false;
        this.lastAllDayEventOnPage = -1;
        this.firstAllDayEventOnPage = 0;
        this.isPrintingAppointmentsFinished = false;
        this.lastAppointmentOnPage = -1;
        this.firstAppointmentOnPage = this.getStartAppointments();
        this.isPrintingTasksFinished = false;
        this.lastTaskOnPage = -1;
        this.firstTaskOnPage = 0;
        this.isPrintingReminderNotesFinished = false;
        this.lastReminderNoteOnPage = -1;
        this.firstReminderNoteOnPage = 0;
    }

    protected void refreshPrint(int thePageIndex) {
        if (thePageIndex > this.dayPageIndex) {
            this.dayPageIndex = thePageIndex;
            this.printingY = 0;
            this.firstDayOnPageCopy = this.firstDayOnPage;
            this.gcDayCopy = (Calendar)this.gcDay.clone();
            this.isPrintingDayFinishedCopy = this.isPrintingDayFinished;
            this.isPrintingAllDayEventsFinishedCopy = this.isPrintingAllDayEventsFinished;
            if (this.isPrintingAllDayEventsFinished) {
                this.firstAllDayEventOnPage = 0;
                this.lastAllDayEventOnPage = -1;
            } else {
                this.firstAllDayEventOnPage = this.lastAllDayEventOnPage + 1;
            }
            this.firstAllDayEventOnPageCopy = this.firstAllDayEventOnPage;
            this.lastAllDayEventOnPageCopy = this.lastAllDayEventOnPage;
            this.isPrintingAppointmentsFinishedCopy = this.isPrintingAppointmentsFinished;
            if (this.isPrintingAppointmentsFinished) {
                this.firstAppointmentOnPage = this.getStartAppointments();
                this.lastAppointmentOnPage = -1;
            } else {
                this.firstAppointmentOnPage = this.lastAppointmentOnPage + 1;
            }
            this.firstAppointmentOnPageCopy = this.firstAppointmentOnPage;
            this.lastAppointmentOnPageCopy = this.lastAppointmentOnPage;
            this.isPrintingTasksFinishedCopy = this.isPrintingTasksFinished;
            if (this.isPrintingTasksFinished) {
                this.firstTaskOnPage = 0;
                this.lastTaskOnPage = -1;
            } else {
                this.firstTaskOnPage = this.lastTaskOnPage + 1;
            }
            this.firstTaskOnPageCopy = this.firstTaskOnPage;
            this.lastTaskOnPageCopy = this.lastTaskOnPage;
            this.isPrintingReminderNotesFinishedCopy = this.isPrintingReminderNotesFinished;
            if (this.isPrintingReminderNotesFinished) {
                this.firstReminderNoteOnPage = 0;
                this.lastReminderNoteOnPage = -1;
            } else {
                this.firstReminderNoteOnPage = this.lastReminderNoteOnPage + 1;
            }
            this.firstReminderNoteOnPageCopy = this.firstReminderNoteOnPage;
            this.lastReminderNoteOnPageCopy = this.lastReminderNoteOnPage;
            this.isPriningNewPage = true;
        } else {
            this.firstDayOnPage = this.firstDayOnPageCopy;
            this.gcDay = (Calendar)this.gcDayCopy.clone();
            this.printingY = 0;
            this.isPrintingDayFinished = this.isPrintingDayFinishedCopy;
            this.isPrintingAllDayEventsFinished = this.isPrintingAllDayEventsFinishedCopy;
            this.lastAllDayEventOnPage = this.lastAllDayEventOnPageCopy;
            this.firstAllDayEventOnPage = this.firstAllDayEventOnPageCopy;
            this.isPrintingAppointmentsFinished = this.isPrintingAppointmentsFinishedCopy;
            this.lastAppointmentOnPage = this.lastAppointmentOnPageCopy;
            this.firstAppointmentOnPage = this.firstAppointmentOnPageCopy;
            this.isPrintingTasksFinished = this.isPrintingTasksFinishedCopy;
            this.firstTaskOnPage = this.firstTaskOnPageCopy;
            this.lastTaskOnPage = this.lastTaskOnPageCopy;
            this.isPrintingReminderNotesFinished = this.isPrintingReminderNotesFinishedCopy;
            this.lastReminderNoteOnPage = this.lastReminderNoteOnPageCopy;
            this.firstReminderNoteOnPage = this.firstReminderNoteOnPageCopy;
            this.isPriningNewPage = false;
        }
    }

    protected boolean printAllDayEvents(Graphics pg) {
        pg.setFont(FNT_HEADER);
        FontMetrics fm = pg.getFontMetrics();
        int fontH = fm.getHeight();
        int y = this.printingY;
        int yMax = this.pageHeight - this.commonHeaderH;
        if (this.isPrintingAllDayEventsFinished) {
            return false;
        }
        if (y + fontH * 3 > yMax) {
            this.printingY = 0;
            return true;
        }
        y = this.printAppointmentsHeader(pg, y, fontH, StringResources.ALL_DAY_EVENTS_C);
        this.printAllDayEventsCollection(GWCalendarUtils.getAllDayEvents(this.itemList, this.gcDay.getTime()), ++y, fontH, yMax, pg);
        return true;
    }

    protected boolean printAppointments(Graphics pg) {
        pg.setFont(FNT_HEADER);
        FontMetrics fm = pg.getFontMetrics();
        int fontH = fm.getHeight();
        int y = this.printingY;
        int yMax = this.pageHeight - this.commonHeaderH;
        if (this.isPrintingAppointmentsFinished) {
            return false;
        }
        if (y + fontH * 3 > yMax) {
            this.printingY = 0;
            return true;
        }
        y = this.printAppointmentsHeader(pg, y, fontH, StringResources.APPOINTMENTS_C);
        this.printAppointmentsCollection(GWCalendarUtils.getAppointments(this.itemList, new Day(this.gcDay)), y, fontH, yMax, pg);
        return true;
    }

    protected void printAllDayEventsCollection(List<? extends AbstractItem> allDayEvents, int y, int fontH, int yMax, Graphics pg) {
        int nSize = allDayEvents.size();
        for (int i = this.firstAllDayEventOnPage; i < nSize; ++i) {
            if (y + fontH > yMax) {
                this.printingY = 0;
                break;
            }
            this.lastAllDayEventOnPage = i;
            y = this.printAppointmentItem(allDayEvents, i, pg, y);
        }
        if (this.lastAllDayEventOnPage >= allDayEvents.size() - 1) {
            this.isPrintingAllDayEventsFinished = true;
        }
        this.printingY = y + 10;
    }

    protected void printAppointmentsCollection(List<? extends AbstractItem> appointments, int y, int fontH, int yMax, Graphics pg) {
        int nSize = appointments.size();
        for (int i = this.firstAppointmentOnPage; i < nSize; ++i) {
            if (y + fontH > yMax) {
                this.printingY = 0;
                break;
            }
            this.lastAppointmentOnPage = i;
            y = this.printAppointmentItem(appointments, i, pg, y);
        }
        if (this.lastAppointmentOnPage >= appointments.size() - 1) {
            this.isPrintingAppointmentsFinished = true;
        }
        this.printingY = y + 10;
    }

    private int printAppointmentItem(List<? extends AbstractItem> appointments, int i, Graphics pg, int y) {
        AppointmentItem ai = (AppointmentItem)appointments.get(i);
        if (printingCalendarPanel.hasAppointmentsFrom()) {
            this.drawAlignedString(pg, ai.getSender().getDisplayText() == null ? "" : ai.getSender().getDisplayText(), this.getFromX(), y, 80);
        }
        if (printingCalendarPanel.hasAppointmentsEnd()) {
            this.drawAlignedString(pg, OptionManager.getInstance().getDateTimeOptions().getTime(ai.getEndDate()), this.getAppointmentEndTimeX(), y, DATE_WIDTH);
        }
        if (printingCalendarPanel.hasAppointmentsStart()) {
            this.drawAlignedString(pg, OptionManager.getInstance().getDateTimeOptions().getTime(ai.getStartDate()), this.getAppointmentStartTimeX(), y, DATE_WIDTH);
        }
        int placeY = y;
        if (printingCalendarPanel.hasAppointmentsPlace()) {
            placeY = ai.getLocation() != null ? (placeY += this.printMultilineString(pg, ai.getLocation(), 100, placeY, this.getAppointmentPlaceX())) : (placeY += this.printMultilineString(pg, " ", 100, placeY, this.getAppointmentPlaceX()));
        }
        int subjectY = y;
        String subjectString = DailyListForm.composeAppointmentSubjectString(ai);
        y = (subjectY += this.printMultilineString(pg, subjectString, this.getSubjectWidth(AppointmentItem.class), subjectY, this.getSubjectX(AppointmentItem.class))) > placeY ? subjectY : placeY;
        return y;
    }

    protected static String composeAppointmentSubjectString(AppointmentItem ai) {
        StringBuilder result = new StringBuilder("");
        if (ai.getSubject() != null) {
            result.append(ai.getSubject());
        }
        return result.toString();
    }

    protected int getSubjectX(Class theClass) {
        return isLeftToRight ? 0 : this.pageWidth - this.getSubjectWidth(theClass);
    }

    protected int getSubjectWidth(Class theClass) {
        int gap = 0;
        if (theClass.equals(AppointmentItem.class)) {
            if (printingCalendarPanel.hasAppointmentsFrom()) {
                gap += 80;
            }
            if (printingCalendarPanel.hasAppointmentsEnd()) {
                gap += DATE_WIDTH;
            }
            if (printingCalendarPanel.hasAppointmentsStart()) {
                gap += DATE_WIDTH;
            }
            if (printingCalendarPanel.hasAppointmentsPlace()) {
                gap += 100;
            }
        } else if (theClass.equals(TaskItem.class)) {
            if (printingCalendarPanel.hasTasksFrom()) {
                gap += 80;
            }
            if (printingCalendarPanel.hasTasksStart()) {
                gap += DATE_WIDTH;
            }
            if (printingCalendarPanel.hasTasksDue()) {
                gap += DATE_WIDTH;
            }
            if (printingCalendarPanel.hasTasksPriority()) {
                gap += 80;
            }
        } else if (theClass.equals(ReminderNote.class)) {
            if (printingCalendarPanel.hasNotesFrom()) {
                gap += 80;
            }
            if (printingCalendarPanel.hasNotesStart()) {
                gap += DATE_WIDTH;
            }
        }
        return this.pageWidth - gap;
    }

    private int getAppointmentPlaceX() {
        int result = isLeftToRight ? this.pageWidth - 100 : 0;
        if (printingCalendarPanel.hasAppointmentsFrom()) {
            result = isLeftToRight ? result - 80 : 80;
        }
        if (printingCalendarPanel.hasAppointmentsEnd()) {
            result = isLeftToRight ? result - DATE_WIDTH : result + DATE_WIDTH;
        }
        if (printingCalendarPanel.hasAppointmentsStart()) {
            result = isLeftToRight ? result - DATE_WIDTH : result + DATE_WIDTH;
        }
        result = isLeftToRight ? result - 5 : result + 5;
        return result;
    }

    protected int getAppointmentStartTimeX() {
        int result = isLeftToRight ? this.pageWidth - DATE_WIDTH : 0;
        if (printingCalendarPanel.hasAppointmentsFrom()) {
            result = isLeftToRight ? result - 80 : 80;
        }
        if (printingCalendarPanel.hasAppointmentsEnd()) {
            result = isLeftToRight ? result - DATE_WIDTH : result + DATE_WIDTH;
        }
        return result;
    }

    protected int getAppointmentEndTimeX() {
        int result = isLeftToRight ? this.pageWidth - DATE_WIDTH : 0;
        if (printingCalendarPanel.hasAppointmentsFrom()) {
            result = isLeftToRight ? result - 80 : 80;
        }
        return result;
    }

    private int getTaskPriorityX() {
        int result = isLeftToRight ? this.pageWidth - 80 : 0;
        if (printingCalendarPanel.hasTasksFrom()) {
            result = isLeftToRight ? result - 80 : 80;
        }
        if (printingCalendarPanel.hasTasksDue()) {
            result = isLeftToRight ? result - DATE_WIDTH : result + DATE_WIDTH;
        }
        if (printingCalendarPanel.hasTasksStart()) {
            result = isLeftToRight ? result - DATE_WIDTH : result + DATE_WIDTH;
        }
        return result;
    }

    private int getTaskStartDateX() {
        int result = isLeftToRight ? this.pageWidth - DATE_WIDTH : 0;
        if (printingCalendarPanel.hasTasksFrom()) {
            result = isLeftToRight ? result - 80 : 80;
        }
        if (printingCalendarPanel.hasTasksDue()) {
            result = isLeftToRight ? result - DATE_WIDTH : result + DATE_WIDTH;
        }
        return result;
    }

    private int getTaskDueDateX() {
        int result = isLeftToRight ? this.pageWidth - DATE_WIDTH : 0;
        if (printingCalendarPanel.hasTasksFrom()) {
            result = isLeftToRight ? result - 80 : 80;
        }
        return result;
    }

    protected int getFromX() {
        return isLeftToRight ? this.pageWidth - 80 : 0;
    }

    private int getReminderNoteStartDateX() {
        int result = isLeftToRight ? this.pageWidth - DATE_WIDTH : 0;
        if (printingCalendarPanel.hasNotesFrom()) {
            result = isLeftToRight ? result - 80 : 80;
        }
        return result;
    }

    protected int printAppointmentsHeader(Graphics pg, int y, int fontH, String title) {
        String tmp;
        this.paintHeaderRow(pg, title, "", y);
        pg.setColor(new Color(240, 240, 240));
        pg.fillRect(0, (y += fontH) - fontH + H_GAP, this.pageWidth, fontH);
        pg.setColor(Color.black);
        pg.drawRect(0, y - fontH + H_GAP, this.pageWidth, fontH);
        pg.setFont(FNT_PLAIN);
        this.drawAlignedString(pg, StringResources.SUBJECT, this.getSubjectX(AppointmentItem.class), y, this.getSubjectWidth(AppointmentItem.class));
        if (printingCalendarPanel.hasAppointmentsFrom()) {
            tmp = UIUtils.cutStringToWidth(StringResources.FROM, pg, 80);
            this.drawAlignedString(pg, tmp, this.getFromX(), y, 80);
        }
        if (printingCalendarPanel.hasAppointmentsEnd()) {
            tmp = UIUtils.cutStringToWidth(StringResources.END_TIME, pg, DATE_WIDTH);
            this.drawAlignedString(pg, tmp, this.getAppointmentEndTimeX(), y, DATE_WIDTH);
        }
        if (printingCalendarPanel.hasAppointmentsStart()) {
            tmp = UIUtils.cutStringToWidth(StringResources.START_TIME, pg, DATE_WIDTH);
            this.drawAlignedString(pg, tmp, this.getAppointmentStartTimeX(), y, DATE_WIDTH);
        }
        if (printingCalendarPanel.hasAppointmentsPlace()) {
            tmp = UIUtils.cutStringToWidth(StringResources.PRINT_PLACE, pg, 100);
            this.drawAlignedString(pg, tmp, this.getAppointmentPlaceX(), y, 100);
        }
        return y += fontH;
    }

    protected boolean printTasks(Graphics pg) {
        pg.setFont(FNT_HEADER);
        FontMetrics fm = pg.getFontMetrics();
        int fontH = fm.getHeight();
        int y = this.printingY;
        int yMax = this.pageHeight - this.commonHeaderH;
        if (this.isPrintingTasksFinished) {
            return false;
        }
        if (y + fontH * 3 > yMax) {
            this.printingY = 0;
            return true;
        }
        y = this.printTaskHeader(pg, y, fontH);
        ++y;
        List<AbstractItem> tasks = GWCalendarUtils.getTasks(this.itemList, new Day(this.gcDay));
        int nSize = tasks.size();
        for (int i = this.firstTaskOnPage; i < nSize; ++i) {
            if (y + fontH > yMax) {
                this.printingY = 0;
                break;
            }
            this.lastTaskOnPage = i;
            TaskItem ti = (TaskItem)tasks.get(i);
            if (printingCalendarPanel.hasTasksFrom()) {
                this.drawAlignedString(pg, ti.getSender().getDisplayText() == null ? " " : ti.getSender().getDisplayText(), this.getFromX(), y, 80);
            }
            if (printingCalendarPanel.hasTasksDue()) {
                this.drawAlignedString(pg, OptionManager.getInstance().getDateTimeOptions().getGeneralDateString(ti.getEndDate()), this.getTaskDueDateX(), y, DATE_WIDTH);
            }
            if (printingCalendarPanel.hasTasksStart()) {
                this.drawAlignedString(pg, OptionManager.getInstance().getDateTimeOptions().getGeneralDateString(new Date(ti.getDateTaskAssigned())), this.getTaskStartDateX(), y, DATE_WIDTH);
            }
            if (printingCalendarPanel.hasTasksPriority()) {
                this.drawAlignedString(pg, ti.getPriorityName(), this.getTaskPriorityX(), y, 80);
            }
            y = ti.getSubject() != null ? (y += this.printMultilineString(pg, ti.getSubject(), this.getSubjectWidth(TaskItem.class), y, this.getSubjectX(TaskItem.class))) : (y += fontH);
            ++y;
        }
        if (this.lastTaskOnPage >= tasks.size() - 1) {
            this.isPrintingTasksFinished = true;
        }
        this.printingY = y + 10;
        return true;
    }

    private int printTaskHeader(Graphics pg, int y, int fontH) {
        String tmp;
        this.paintHeaderRow(pg, StringResources.TASKS_C, "", y);
        pg.setFont(FNT_PLAIN);
        pg.setColor(new Color(240, 240, 240));
        pg.fillRect(0, (y += fontH) - fontH + H_GAP, this.pageWidth, fontH);
        pg.setColor(Color.black);
        pg.drawRect(0, y - fontH + H_GAP, this.pageWidth, fontH);
        this.drawAlignedString(pg, StringResources.SUBJECT, this.getSubjectX(TaskItem.class), y, this.getSubjectWidth(TaskItem.class));
        if (printingCalendarPanel.hasTasksFrom()) {
            tmp = UIUtils.cutStringToWidth(StringResources.FROM, pg, 80);
            this.drawAlignedString(pg, tmp, this.getFromX(), y, 80);
        }
        if (printingCalendarPanel.hasTasksDue()) {
            tmp = UIUtils.cutStringToWidth(StringResources.DUE_DATE, pg, DATE_WIDTH);
            this.drawAlignedString(pg, tmp, this.getTaskDueDateX(), y, DATE_WIDTH);
        }
        if (printingCalendarPanel.hasTasksStart()) {
            tmp = UIUtils.cutStringToWidth(StringResources.START_DATE, pg, DATE_WIDTH);
            this.drawAlignedString(pg, tmp, this.getTaskStartDateX(), y, DATE_WIDTH);
        }
        if (printingCalendarPanel.hasTasksPriority()) {
            tmp = UIUtils.cutStringToWidth(StringResources.PRIORITY, pg, 80);
            this.drawAlignedString(pg, tmp, this.getTaskPriorityX(), y, 80);
        }
        return y += fontH;
    }

    protected boolean printReminderNotes(Graphics pg) {
        pg.setFont(FNT_HEADER);
        FontMetrics fm = pg.getFontMetrics();
        int fontH = fm.getHeight();
        int y = this.printingY;
        int yMax = this.pageHeight - this.commonHeaderH;
        if (this.isPrintingReminderNotesFinished) {
            return false;
        }
        if (y + fontH * 3 > yMax) {
            this.printingY = 0;
            return true;
        }
        y = this.printNotesHeader(pg, y, fontH);
        ++y;
        List<AbstractCalendarItem> reminderNotes = GWCalendarUtils.getNotes(this.itemList, new Day(this.gcDay));
        int nSize = reminderNotes.size();
        for (int i = this.firstReminderNoteOnPage; i < nSize; ++i) {
            if (y + fontH > yMax) {
                this.printingY = 0;
                break;
            }
            this.lastReminderNoteOnPage = i;
            ReminderNote ri = (ReminderNote)reminderNotes.get(i);
            if (printingCalendarPanel.hasNotesFrom()) {
                this.drawAlignedString(pg, ri.getSender().getDisplayText() == null ? " " : ri.getSender().getDisplayText(), this.getFromX(), y, 80);
            }
            if (printingCalendarPanel.hasNotesStart()) {
                this.drawAlignedString(pg, OptionManager.getInstance().getDateTimeOptions().getGeneralDateString(ri.getStartDate()), this.getReminderNoteStartDateX(), y, DATE_WIDTH);
            }
            y = ri.getSubject() != null ? (y += this.printMultilineString(pg, ri.getSubject(), this.getSubjectWidth(ReminderNote.class), y, this.getSubjectX(ReminderNote.class))) : (y += fontH);
            ++y;
        }
        if (this.lastReminderNoteOnPage >= reminderNotes.size() - 1) {
            this.isPrintingReminderNotesFinished = true;
        }
        this.printingY = y + 10;
        return true;
    }

    private int printNotesHeader(Graphics pg, int y, int fontH) {
        String tmp;
        this.paintHeaderRow(pg, StringResources.REMINDER_NOTES_C, "", y);
        pg.setFont(FNT_PLAIN);
        pg.setColor(new Color(240, 240, 240));
        pg.fillRect(0, (y += fontH) - fontH + H_GAP, this.pageWidth, fontH);
        pg.setColor(Color.black);
        pg.drawRect(0, y - fontH + H_GAP, this.pageWidth, fontH);
        this.drawAlignedString(pg, StringResources.SUBJECT, this.getSubjectX(ReminderNote.class), y, this.getSubjectWidth(ReminderNote.class));
        if (printingCalendarPanel.hasNotesFrom()) {
            tmp = UIUtils.cutStringToWidth(StringResources.FROM, pg, 80);
            this.drawAlignedString(pg, tmp, this.getFromX(), y, 80);
        }
        if (printingCalendarPanel.hasNotesStart()) {
            tmp = UIUtils.cutStringToWidth(StringResources.START_DATE, pg, DATE_WIDTH);
            this.drawAlignedString(pg, tmp, this.getReminderNoteStartDateX(), y, DATE_WIDTH);
        }
        return y += fontH;
    }

    protected int printMultilineString(Graphics graphics, String text, int width, int height, int x) {
        int h = height;
        List<String> strings = UIUtils.breakStringIntoSubstrings(text, graphics.getFontMetrics(this.getFont()), width);
        int nSize = strings.size();
        for (int i = 0; i < nSize; ++i) {
            this.drawAlignedString(graphics, strings.get(i), x, h, width);
            h += graphics.getFontMetrics().getHeight();
        }
        if ((h -= height) == 0) {
            h = graphics.getFontMetrics().getHeight();
        }
        return h;
    }

    @Override
    public String toString() {
        return StringResources.PRINT_APPOINTMENTSK_TASKS_AND_REMIN;
    }

    @Override
    public ImageIcon getIcon() {
        return ImageResources.PRINT_FRM_DAILY_LIST;
    }

    protected int getStartAppointments() {
        return 0;
    }

    @Override
    public void setMVCModel(Object theModel) {
        super.setMVCModel(theModel);
        this.gcDay = (Calendar)printingCalendarPanel.getCurrentDay().clone();
    }
}

