/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.printingcalendar.printforms;

import com.appframework.mvc.MVCController;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.DayCell;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.AbstarctItemBean;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.CalendarForm;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.PageModel;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MonthForm
extends CalendarForm {
    private static Logger logger = Logger.getLogger(MonthForm.class);
    protected IItemList itemList;
    private DayCell[] prevCalDayCells = new DayCell[42];
    private DayCell[] prevCalLabelCells = new DayCell[7];
    private DayCell[] nextCalDayCells = new DayCell[42];
    private DayCell[] nextCalLabelCells = new DayCell[7];
    protected static final int VERTICAL_INSET = 3;
    protected final Font monthNameFont = new Font(FNT_PLAIN.getFontName(), 0, 12);
    private static final int HORIZONTAL_INSET = 3;
    public static final int DASH_LENGTH = 5;
    protected final Font dayOfMonthFont = new Font(FNT_PLAIN.getFontName(), 0, 9);
    protected Dimension dayOfMonthDimension;
    private final Font dayNameFont = new Font(FNT_PLAIN.getFontName(), 0, 12);
    private List<AbstarctItemBean> remainedAppointments = new ArrayList<AbstarctItemBean>();

    public MonthForm(MVCController parentController) {
        super(parentController);
    }

    @Override
    protected void changeDateValues(Calendar day) {
        this.dateMonth = GWCalendarUtils.monthNames[day.get(2)];
        this.dateYear = String.valueOf(day.get(1));
    }

    protected void printPreviousMonthCalendar(Graphics pg, int imagibleWidth) {
        Calendar dateMonthYear = this.getCurrentPrintDay();
        dateMonthYear.add(2, -1);
        this.changeDateValues(dateMonthYear);
        String monthYear = GWCalendarUtils.monthNames[dateMonthYear.get(2)] + " " + this.dateYear;
        int remX = CalendarForm.isLeftToRight ? 0 : imagibleWidth - monthlyCalendarFontAttributes.calculateMonthlyCalendarWidth();
        pg.setFont(monthlyCalendarFontAttributes.getFont());
        this.drawMonth(pg, monthYear, remX, this.prevCalLabelCells, this.prevCalDayCells, dateMonthYear);
    }

    protected void printNextMonthCalendar(Graphics pg, int imagibleWidth) {
        Calendar dateMonthYear = this.getCurrentPrintDay();
        dateMonthYear.add(2, 1);
        this.changeDateValues(dateMonthYear);
        String monthYear = this.dateMonth + " " + this.dateYear;
        int remX = CalendarForm.isLeftToRight ? imagibleWidth - monthlyCalendarFontAttributes.calculateMonthlyCalendarWidth() : 0;
        pg.setFont(monthlyCalendarFontAttributes.getFont());
        this.drawMonth(pg, monthYear, remX, this.nextCalLabelCells, this.nextCalDayCells, dateMonthYear);
    }

    protected int printMonthLabel(Graphics pg, int y, String text) {
        pg.setFont(this.monthNameFont);
        int textHeight = (int)pg.getFontMetrics().getStringBounds(text, pg).getHeight();
        int endY = y + textHeight + 6;
        int descent = pg.getFontMetrics().getDescent();
        int startY = endY - descent - 3;
        int stringWidth = pg.getFontMetrics().stringWidth(text);
        int startX = (this.pageWidth - stringWidth) / 2;
        pg.drawString(text, startX, startY);
        pg.drawLine(0, endY, this.pageWidth, endY);
        return endY;
    }

    private void printDay(Graphics pg, PageModel pageModel, Calendar day, Rectangle rectangle) {
        Dimension dimension = this.getDayOfMonthDimension(pg);
        int y = rectangle.y + dimension.height;
        int cellEndY = (int)((double)rectangle.y + rectangle.getHeight());
        int cellEndX = (int)((double)rectangle.x + rectangle.getWidth());
        int startX = CalendarForm.isLeftToRight ? rectangle.x : rectangle.x + rectangle.width - dimension.width;
        int endX = CalendarForm.isLeftToRight ? startX + dimension.width : startX + dimension.width;
        pg.drawLine(startX, y, endX, y);
        int x = CalendarForm.isLeftToRight ? endX : startX;
        pg.drawLine(x, rectangle.y, x, y);
        pg.setFont(this.dayOfMonthFont);
        String text = Integer.toString(day.get(5));
        int descent = pg.getFontMetrics().getDescent();
        int stringWidth = pg.getFontMetrics().stringWidth(text);
        x = startX + (dimension.width - stringWidth) / 2;
        int textHeight = (int)pg.getFontMetrics().getStringBounds(text, pg).getHeight();
        int endY = y - (dimension.height - textHeight) / 2 - descent - 3;
        pg.drawString(text, x, endY);
        x = rectangle.x;
        List<AbstarctItemBean> list = pageModel.getAllDayEvents(day);
        y = this.printCellStrings(list, pg, x, y, cellEndX, cellEndY);
        if (y < 0) {
            return;
        }
        list = pageModel.getAppointments(day);
        y = this.printCellStrings(list, pg, x, y, cellEndX, cellEndY);
        if (y < 0) {
            return;
        }
        list = pageModel.getTasks(day);
        y = this.printCellStrings(list, pg, x, y, cellEndX, cellEndY);
        if (y < 0) {
            return;
        }
        list = pageModel.getNotes(day);
        this.printCellStrings(list, pg, x, y, cellEndX, cellEndY);
    }

    private int printCellStrings(List<AbstarctItemBean> list, Graphics pg, int x, int y, int cellEndX, int cellEndY) {
        int fontMetricsHeight = pg.getFontMetrics().getHeight();
        int descent = pg.getFontMetrics().getDescent();
        this.remainedAppointments.addAll(list);
        for (AbstarctItemBean bean : list) {
            AbstractItem item = bean.getItem();
            String string = bean.getDescription();
            this.remainedAppointments.remove(bean);
            string = CalendarForm.isLeftToRight ? "   " + string : string + "   ";
            List<String> subStrings = UIUtils.breakStringIntoSubstrings(string, pg.getFontMetrics(), cellEndX - x);
            boolean firstLine = true;
            for (String subString : subStrings) {
                int endY = y + fontMetricsHeight;
                if (endY > cellEndY) {
                    logger.debug((Object)"end of cell reached > skippng the rest of items");
                    return -1;
                }
                if (firstLine) {
                    int iconStartX = CalendarForm.isLeftToRight ? x + 1 : cellEndX - fontMetricsHeight - 1;
                    int iconStartY = y + 1;
                    this.printItemIcon(item, pg, iconStartX, iconStartY, iconStartX + fontMetricsHeight - 2, iconStartY + fontMetricsHeight - 2);
                    firstLine = false;
                }
                int startX = CalendarForm.isLeftToRight ? x + 3 : cellEndX - pg.getFontMetrics().stringWidth(subString);
                pg.drawString(subString, startX, endY -= descent);
                y += fontMetricsHeight;
            }
            this.drawHorizontalDashedLine(pg, 5, x, y, cellEndX);
        }
        return y;
    }

    protected void drawHorizontalDashedLine(Graphics pg, int dashLength, int startX, int y, int endX) {
        boolean draw = true;
        while (startX + dashLength <= endX) {
            if (draw) {
                pg.drawLine(startX, y, startX + dashLength, y);
            }
            draw = !draw;
            startX += dashLength;
        }
    }

    protected int getClipHeight(Graphics pg) {
        Rectangle rectangle = pg.getClipBounds();
        return rectangle.height + rectangle.y;
    }

    protected Dimension getDayOfMonthDimension(Graphics pg) {
        if (this.dayOfMonthDimension != null) {
            return this.dayOfMonthDimension;
        }
        int maxWidth = 0;
        FontMetrics metrics = pg.getFontMetrics(this.dayOfMonthFont);
        int height = metrics.getAscent() + metrics.getDescent();
        for (int i = 1; i <= 31; ++i) {
            Rectangle2D rectangle = metrics.getStringBounds(Integer.toString(i), pg);
            maxWidth = Math.max(maxWidth, (int)rectangle.getWidth());
        }
        this.dayOfMonthDimension = new Dimension(maxWidth + 6, height + 6);
        return this.dayOfMonthDimension;
    }

    protected int printDayNames(Graphics pg, PageModel pageModel, int y) {
        pg.setFont(this.dayNameFont);
        int columnCount = pageModel.getNumberOfDaysInRow();
        ArrayList<String> dayNames = new ArrayList<String>(columnCount);
        int maxTextHeight = 0;
        for (int i = 0; i < columnCount; ++i) {
            int dayIndex = pageModel.getWeekDayIndexForColumn(i);
            String dayName = GWCalendarUtils.dayNames[dayIndex - 1];
            dayNames.add(i, dayName);
            maxTextHeight = Math.max(maxTextHeight, (int)pg.getFontMetrics().getStringBounds(dayName, pg).getHeight());
        }
        int descent = pg.getFontMetrics().getDescent();
        int endY = y + maxTextHeight + 6;
        int columnWidth = this.pageWidth / columnCount;
        for (int i = 0; i < columnCount; ++i) {
            int x = columnWidth * i;
            pg.drawLine(x, y, x, endY);
            String dayName = (String)dayNames.get(i);
            int stringWidth = pg.getFontMetrics().stringWidth(dayName);
            int textHeight = (int)pg.getFontMetrics().getStringBounds(dayName, pg).getHeight();
            int startY = endY - (maxTextHeight - textHeight) / 2 - descent - 3;
            pg.drawString(dayName, x += (columnWidth - stringWidth) / 2, startY);
        }
        pg.drawLine(0, endY, this.pageWidth, endY);
        return endY;
    }
}

