/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.printingitem.printforms;

import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.printing.basicforms.GWItemForm;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.PhoneItem;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class PhoneForm
extends GWItemForm {
    private PhoneItem item;

    public PhoneForm(PhoneItem theItem, int printAttachmentList, MVCController theParentController) {
        super(theItem, printAttachmentList, theParentController);
        this.item = theItem;
        this.itemType = StringResources.PHONE;
    }

    protected int printHeader(Graphics pg) {
        pg.setColor(Color.black);
        pg.setFont(FNT_HEADER);
        FontMetrics fm = pg.getFontMetrics();
        int y = fm.getAscent();
        int x = 0;
        Font bold = FNT_SUB_HEADER;
        Font plain = FNT_PLAIN;
        int nHeight = fm.getHeight();
        if (this.itemChecksPanel.isFromSelected()) {
            pg.setFont(bold);
            fm = pg.getFontMetrics();
            this.paintHeaderRow(pg, StringResources.FROM_C, this.item.getSender().getDisplayText(), y, bold, plain);
            y += nHeight;
        }
        if (this.itemChecksPanel.isToSelected()) {
            this.paintHeaderRow(pg, StringResources.TO_C, this.item.getTo(), y, bold, plain);
            y += nHeight;
        }
        if (this.itemChecksPanel.isDateSelected()) {
            String date = this.item.getDate() == null ? "" : OptionManager.getInstance().getDateTimeOptions().getPropertiesString(this.item.getDate());
            this.paintHeaderRow(pg, StringResources.DATE_C, date, y, bold, plain);
            y += nHeight;
        }
        this.paintHeaderRow(pg, StringResources.CALLER_C, this.item.getCaller(), y += 10, bold, plain);
        this.paintHeaderRow(pg, StringResources.COMPANY_C, this.item.getCompany(), y += nHeight, bold, plain);
        this.paintHeaderRow(pg, StringResources.PHONE_C, this.item.getPhone(), y += nHeight, bold, plain);
        pg.setFont(bold);
        x = (int)pg.getFontMetrics().getStringBounds(StringResources.MESSAGE_C, pg).getWidth();
        pg.drawString(StringResources.MESSAGE_C, this.getTitleX(x), y += nHeight + 5);
        return y += 10;
    }

    public String toString() {
        String s = StringResources.SIMPLE_PHONE_FORM;
        if (this.printAttachmentList == GWItemForm.PRINT_ATTACHMENT_LIST) {
            s = s + ' ' + StringResources.L_WITH_LIST_OF_ATTACHMENTS;
        }
        return s;
    }
}

