/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.resources;

import com.novell.gw.jclient.application.resources.ImageResources;
import java.io.IOException;
import java.util.Locale;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class StartupImageResources {
    private static Logger logger = Logger.getLogger(StartupImageResources.class);
    public static final String SPLASH_ABOUT_FILE_EXT = ".png";
    public static final String GW_SPLASH_BASE = "GW_Splash";
    public static final String GW_SPLASH_NON_LOCALIZED_BASE = "GW_Splash-nonlocalized";
    public static final String GW_ABOUT_BASE = "GW_Splash";
    public static final String FILE_GW_ICON = "gwicon.png";
    private static String IMAGES_FOLDER = "images/";

    public static ImageIcon getIcon(String fileName) throws IOException {
        return ImageResources.loadIcon(IMAGES_FOLDER + fileName);
    }

    public static ImageIcon getIcon(String baseName, Locale locale) {
        ImageIcon icon = null;
        try {
            String lang = locale.getLanguage();
            if (lang.equals("iw")) {
                lang = "he";
            }
            if ("en".equalsIgnoreCase(lang)) {
                icon = StartupImageResources.getIcon(baseName + SPLASH_ABOUT_FILE_EXT);
            } else {
                String localeExt = '_' + lang;
                if ("zh".equalsIgnoreCase(lang)) {
                    localeExt = localeExt + '_' + locale.getCountry();
                }
                if ((icon = StartupImageResources.getIcon(baseName + localeExt + SPLASH_ABOUT_FILE_EXT)) == null) {
                    icon = StartupImageResources.getIcon(baseName + SPLASH_ABOUT_FILE_EXT);
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
        return icon;
    }
}

