/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.eng_impl;

import com.appframework.utils.Assertions;
import com.novell.gw.ab.AddressBook;
import com.novell.gw.ab.SystemAddressBook;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import com.novell.gw.jclient.bl.om.directory.FrequentContactsAddressBook;
import com.novell.gw.jclient.bl.om.directory.GroupWiseAddressBook;
import com.novell.gw.jclient.bl.om.directory.PersonalAddressBook;

public class AddressBookItemsFactory {
    public static AbstractAddressBook createAddressBook(AddressBook theAddressBook) {
        if (theAddressBook.isFrequentContacts()) {
            return AddressBookItemsFactory.buildFrequentContactsAddressBook(theAddressBook);
        }
        if (theAddressBook instanceof SystemAddressBook) {
            return AddressBookItemsFactory.buildSystemAddressBok((SystemAddressBook)theAddressBook);
        }
        if (theAddressBook instanceof com.novell.gw.ab.PersonalAddressBook) {
            return AddressBookItemsFactory.buildPersonalAddressBook((com.novell.gw.ab.PersonalAddressBook)theAddressBook);
        }
        Assertions.assertIllegalArgument("Unexpected Address Book type");
        return null;
    }

    private static AbstractAddressBook buildFrequentContactsAddressBook(AddressBook theAddressBook) {
        FrequentContactsAddressBook frequentContactsAddressBook = new FrequentContactsAddressBook(String.valueOf(theAddressBook.getId()), theAddressBook);
        return frequentContactsAddressBook;
    }

    private static AbstractAddressBook buildPersonalAddressBook(com.novell.gw.ab.PersonalAddressBook thePersonalAddressBook) {
        PersonalAddressBook personalAddressBook = new PersonalAddressBook(String.valueOf(thePersonalAddressBook.getId()), (AddressBook)thePersonalAddressBook);
        return personalAddressBook;
    }

    private static AbstractAddressBook buildSystemAddressBok(SystemAddressBook theSystemAddressBook) {
        GroupWiseAddressBook groupWiseAddressBook = new GroupWiseAddressBook(String.valueOf(theSystemAddressBook.getId()), (AddressBook)theSystemAddressBook);
        return groupWiseAddressBook;
    }
}

