/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.eng_impl;

import com.appframework.utils.OS;
import com.novell.gw.engine.EngineCallback;
import com.novell.gw.engine.SendCallback;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class CallbackManager {
    private static Logger logger = Logger.getLogger(CallbackManager.class);
    private static CallbackManager instance = null;

    private CallbackManager() {
    }

    public static CallbackManager getInstance() {
        if (instance == null) {
            instance = new CallbackManager();
        }
        return instance;
    }

    public EngineCallback createCallbackProxy(EngineCallback engineCallback) {
        if (!OS.isLinuxOS()) {
            return engineCallback;
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        NewThreadInvocationHandler handler = new NewThreadInvocationHandler(engineCallback);
        EngineCallback engineCallbackProxy = (EngineCallback)Proxy.newProxyInstance(classLoader, new Class[]{EngineCallback.class}, (InvocationHandler)handler);
        return engineCallbackProxy;
    }

    public SendCallback createCallbackProxy(SendCallback sendCallback) {
        if (!OS.isLinuxOS()) {
            return sendCallback;
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        NewThreadInvocationHandler handler = new NewThreadInvocationHandler(sendCallback);
        SendCallback sendCallbackProxy = (SendCallback)Proxy.newProxyInstance(classLoader, new Class[]{SendCallback.class}, (InvocationHandler)handler);
        return sendCallbackProxy;
    }

    private class InvokerThread
    extends Thread {
        private boolean finished = false;
        private Object invokationResult = null;
        private Method method;
        private Object[] args;
        private Object target;

        public InvokerThread(Object target, Method method, Object[] args) {
            this.args = args;
            this.method = method;
            this.target = target;
        }

        public void run() {
            try {
                Object result;
                this.invokationResult = result = this.method.invoke(this.target, this.args);
                this.finished = true;
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    private class NewThreadInvocationHandler
    implements InvocationHandler {
        private Object callback = null;

        public NewThreadInvocationHandler(Object callback) {
            logger.debug((Object)("Creating proxy for callback: " + callback));
            this.callback = callback;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object invokationResult = null;
            assert (this.callback != null) : "callback is null";
            boolean edt = SwingUtilities.isEventDispatchThread();
            if (edt) {
                invokationResult = method.invoke(this.callback, args);
                return invokationResult;
            }
            InvokerThread thread = new InvokerThread(this.callback, method, args);
            thread.start();
            while (true) {
                if (thread.finished) break;
                Thread.sleep(50L);
            }
            invokationResult = thread.invokationResult;
            return invokationResult;
        }
    }
}

