/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.eng_impl;

import com.novell.gw.jclient.api.interfaces.message.IAppointment;
import com.novell.gw.jclient.api.interfaces.message.IDocumentReference;
import com.novell.gw.jclient.api.interfaces.message.IMail;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.api.interfaces.message.INote;
import com.novell.gw.jclient.api.interfaces.message.IPhoneMessage;
import com.novell.gw.jclient.api.interfaces.message.ISharedAddressBookNotification;
import com.novell.gw.jclient.api.interfaces.message.ISharedFolderNotification;
import com.novell.gw.jclient.api.interfaces.message.ITask;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.items.AbstractCalendarItem;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.DocumentItem;
import com.novell.gw.jclient.bl.om.items.GWSharedFolderNotification;
import com.novell.gw.jclient.bl.om.items.MailItem;
import com.novell.gw.jclient.bl.om.items.PhoneItem;
import com.novell.gw.jclient.bl.om.items.ReminderNote;
import com.novell.gw.jclient.bl.om.items.SharedAddressBookNotificationItem;
import com.novell.gw.jclient.bl.om.items.TaskItem;
import java.util.Date;
import org.apache.log4j.Logger;

public class GWItemFactory {
    private static Logger logger = Logger.getLogger(GWItemFactory.class);

    public static AbstractItem gwObjectToItem(IMessage item) throws GWCommandException {
        long date_start = 0L;
        long date_end = 0L;
        String location = null;
        Object priority_task = null;
        long date_task_assigned = 0L;
        AbstractItem gwItem = GWItemFactory.createGWItem(item);
        if (gwItem instanceof AbstractCalendarItem) {
            INote note = (INote)item;
            Date startDate = note.getStartDate();
            if (startDate != null) {
                date_start = startDate.getTime();
            }
            if (item instanceof IAppointment) {
                IAppointment appointment = (IAppointment)item;
                Date end_Date = appointment.getEndDate();
                if (end_Date != null) {
                    date_end = end_Date.getTime();
                }
                location = appointment.getPlace();
            } else if (item instanceof ITask) {
                Date endDate;
                ITask task = (ITask)item;
                Date assignedDate = task.getAssignedDate();
                if (assignedDate != null) {
                    date_task_assigned = assignedDate.getTime();
                }
                if ((endDate = task.getDueDate()) != null) {
                    date_end = endDate.getTime();
                }
            }
            gwItem = GWItemFactory.createCalendarItem((AbstractCalendarItem)gwItem, date_start, date_end, date_task_assigned, location);
        } else if (gwItem instanceof DocumentItem || gwItem instanceof PhoneItem) {
            // empty if block
        }
        return gwItem;
    }

    private static AbstractCalendarItem createCalendarItem(AbstractCalendarItem theCalendarItem, long date_start, long date_end, long date_task_assigned, String location) {
        if (theCalendarItem instanceof TaskItem) {
            ((TaskItem)theCalendarItem).setDateTaskAssigned(date_task_assigned);
        } else if (theCalendarItem instanceof AppointmentItem) {
            ((AppointmentItem)theCalendarItem).setLocation(location);
        } else if (theCalendarItem instanceof ReminderNote) {
            // empty if block
        }
        theCalendarItem.setStartDates(new Date[]{new Date(date_start)});
        theCalendarItem.setEndDate(new Date(date_end));
        return theCalendarItem;
    }

    private static AbstractItem createGWItem(IMessage item) throws GWCommandException {
        AbstractItem abstractGWItem = null;
        if (item instanceof IPhoneMessage) {
            abstractGWItem = new PhoneItem((IPhoneMessage)item);
        } else if (item instanceof IMail) {
            abstractGWItem = item instanceof ISharedFolderNotification ? new GWSharedFolderNotification((ISharedFolderNotification)item) : (item instanceof ISharedAddressBookNotification ? new SharedAddressBookNotificationItem((ISharedAddressBookNotification)item) : new MailItem((IMail)item));
        } else if (item instanceof ITask) {
            abstractGWItem = new TaskItem((ITask)item);
        } else if (item instanceof IAppointment) {
            abstractGWItem = new AppointmentItem((IAppointment)item);
        } else if (item instanceof INote) {
            abstractGWItem = new ReminderNote((INote)item);
        } else if (item instanceof IDocumentReference) {
            abstractGWItem = new DocumentItem((IDocumentReference)item);
        } else {
            throw new GWCommandException("Unknown Message Type : " + item.getClass().getName());
        }
        return abstractGWItem;
    }

    public static boolean isMessageRead(IMessage theMessage) {
        return theMessage.isRead();
    }
}

