/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.eng_impl;

import com.appframework.mvc.GlobalCommand;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.api.APIFactory;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextArea;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;

public class StatusWindowFrame
extends JFrame {
    private static Logger logger = Logger.getLogger(StatusWindowFrame.class);
    private JTextArea taLog;
    private JProgressBar progress;
    private JButton btnHide;
    private JLabel time;
    private JButton btnCancel;
    private LeftTimer timer;
    long startTime;
    private SimpleDateFormat format;
    private DateFormat localFormat;
    private boolean doOutput = true;
    private JCheckBox chkAutoShow;
    private boolean doAutoShow;
    private boolean isManualyOpened = false;
    private final Color BORDER_COLOR = Color.LIGHT_GRAY.darker();
    private boolean isLeftToRight = true;
    private CompListener boundsListener;
    private String WINH_KEY = "SYNCFRAME.WIN_HEIGHT";
    private String WINW_KEY = "SYNCFRAME.WIN_WIDTH";
    private String WINX_KEY = "SYNCFRAME.WIN_X";
    private String WINY_KEY = "SYNCFRAME.WIN_Y";

    public StatusWindowFrame() {
        this.setFocusableWindowState(false);
        this.format = new SimpleDateFormat("HH:mm:ss");
        this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.localFormat = DateFormat.getTimeInstance(2, EngineCommandManager.getLocale());
        this.isLeftToRight = UIUtils.getComponentOrientation().isLeftToRight();
        this.boundsListener = new CompListener();
        this.timer = new LeftTimer(100, new TimeTickAction());
        this.buildUI();
        this.initFrame();
        this.makeNonFocusable();
        this.taLog.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (OS.isLeftMouseButton(e) && !StatusWindowFrame.this.getFocusableWindowState()) {
                    StatusWindowFrame.this.setFocusableWindowState(true);
                }
            }
        });
        this.pack();
    }

    private void makeNonFocusable() {
        int nCount = this.getComponentCount();
        for (int i = 0; i < nCount; ++i) {
            Component c = this.getComponent(i);
            c.setFocusable(false);
        }
    }

    private void buildUI() {
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.setComponentOrientation(UIUtils.getComponentOrientation());
        OrientablePanel mainPanel = new OrientablePanel();
        mainPanel.setLayout(new BorderLayout());
        OrientablePanel logPanel = new OrientablePanel(new BorderLayout());
        this.taLog = new GWTextArea();
        this.taLog.setForeground(Color.BLUE);
        this.taLog.setBackground(Color.LIGHT_GRAY);
        this.taLog.setEditable(false);
        this.taLog.setBorder(new EmptyBorder(10, 10, 10, 10));
        OrientableScrollPane logScroll = new OrientableScrollPane(this.taLog);
        logPanel.add((Component)logScroll, "Center");
        OrientablePanel centerPanel = new OrientablePanel(new BorderLayout());
        centerPanel.add((Component)logPanel, "Center");
        this.progress = new JProgressBar();
        this.progress.setBackground(Color.LIGHT_GRAY);
        this.progress.setBorder(new LineBorder(Color.DARK_GRAY));
        this.progress.setBorderPainted(true);
        this.progress.setMinimum(0);
        this.progress.setStringPainted(true);
        this.progress.setComponentOrientation(UIUtils.getComponentOrientation());
        centerPanel.add((Component)this.progress, "South");
        OrientablePanel bottomPanel = new OrientablePanel(new GridBagLayout());
        bottomPanel.setBorder(new EmptyBorder(2, 2, 2, 2));
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(2, 2, 2, 2);
        OrientablePanel timePanel = new OrientablePanel(new BorderLayout());
        timePanel.setBorder(null);
        this.time = new OrientableLabel();
        this.time.setForeground(Color.GRAY);
        timePanel.add((Component)this.time, "After");
        c.anchor = 22;
        c.gridx = 1;
        c.weightx = 0.0;
        bottomPanel.add((Component)timePanel, c);
        c.weightx = 1.0;
        OrientablePanel buttonPanel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints c1 = new GridBagConstraints();
        this.btnHide = new JButton(StringResources.HIDE);
        this.btnHide.addActionListener(new HideButtonActionListener());
        this.btnCancel = new JButton(StringResources.CANCEL);
        this.btnCancel.setEnabled(false);
        this.btnCancel.addActionListener(new CancelButtonActionListener());
        c1.insets = new Insets(2, 0, 2, 2);
        c1.fill = 0;
        if (OS.isMacOS()) {
            buttonPanel.add((Component)this.btnCancel, c1);
            c1.gridx = 1;
            c1.insets = new Insets(2, 10, 2, 2);
            buttonPanel.add((Component)this.btnHide, c1);
        } else {
            buttonPanel.add((Component)this.btnHide, c1);
            c1.gridx = 1;
            c1.insets = new Insets(2, 10, 2, 2);
            buttonPanel.add((Component)this.btnCancel, c1);
        }
        this.chkAutoShow = new OrientableCheckBox();
        this.chkAutoShow.setAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                StatusWindowFrame.this.doAutoShow = !StatusWindowFrame.this.doAutoShow;
                logger.debug((Object)("!Storing autoshow status window = " + StatusWindowFrame.this.doAutoShow));
                EngineCommandManager.getAccountSettings().setSyncStatusWindowEnabled(StatusWindowFrame.this.doAutoShow);
            }
        });
        this.chkAutoShow.setText(StringResources.SHOW_DURING_SEND_RETRIEVE);
        c.gridy = 1;
        c.gridx = 0;
        c.fill = 2;
        c.insets = new Insets(2, 2, 2, 2);
        bottomPanel.add((Component)this.chkAutoShow, c);
        c.weightx = 0.0;
        c.gridx = 1;
        c.gridy = 1;
        c.insets = new Insets(2, 10, 2, 2);
        c.fill = 0;
        bottomPanel.add((Component)buttonPanel, c);
        mainPanel.add((Component)centerPanel, "Center");
        mainPanel.add((Component)bottomPanel, "South");
        contentPane.add((Component)mainPanel, "Center");
        LineBorder border = new LineBorder(this.BORDER_COLOR, 4);
        contentPane.setBorder(border);
    }

    private void initFrame() {
        this.setTitle(StringResources.UPDATING_MAILBOX);
        this.setIconImage(ImageResources.GW_ICON.getImage());
    }

    public boolean showDuringSendReceive() {
        return this.chkAutoShow.isSelected();
    }

    public void setProgressMax(int theMax) {
        this.progress.setMaximum(theMax);
    }

    public void setProgressCurrect(int theCurrent) {
        this.progress.setValue(theCurrent);
    }

    public void setStatus(String theStatus) {
        this.progress.setString(theStatus);
    }

    public synchronized void updateLog(String theLogMessage) {
        if (this.doOutput) {
            int length = this.taLog.getDocument().getLength();
            if (length > 10000) {
                try {
                    this.taLog.getDocument().remove(0, 2000);
                }
                catch (BadLocationException e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }
            long current = System.currentTimeMillis();
            String timeText = this.localFormat.format(new Date(current));
            if (theLogMessage != null && theLogMessage.length() > 0) {
                this.taLog.append(this.isLeftToRight ? timeText + ' ' + theLogMessage + '\n' : theLogMessage + ' ' + timeText + '\n');
            }
            this.scrollDown();
        }
    }

    private void scrollDown() {
        int height = 20;
        Rectangle rectangle = new Rectangle(this.taLog.getVisibleRect().width, 20);
        rectangle.x = 0;
        rectangle.y = this.taLog.getBounds().height - 20;
        this.taLog.scrollRectToVisible(rectangle);
    }

    private synchronized void doHide() {
        GWClient.getApplication().processCommand(new GlobalCommand(850));
        this.isManualyOpened = false;
        super.hide();
    }

    private static void doCancel() {
        APIFactory.getEngine().cancelSync();
        GWClient.getApplication().processCommand(new GlobalCommand(910));
    }

    public void hide() {
        if (this.isShowing()) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.doHide();
            } else {
                try {
                    SwingUtilities.invokeAndWait(new HideRunner());
                }
                catch (InterruptedException e) {
                    logger.error((Object)e, (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }
        }
    }

    public void startTimer() {
        this.timer.start();
    }

    public void stopTimer() {
        this.timer.stop();
    }

    private synchronized void doShow() {
        this.doAutoShow = EngineCommandManager.getAccountSettings().isSyncStatusWindowEnabled();
        logger.debug((Object)("!Getting autoshow status window = " + this.doAutoShow));
        this.chkAutoShow.setSelected(this.doAutoShow);
        GWClient.getApplication().processCommand(new GlobalCommand(860));
        this.doUpdateSizeLocation();
        this.setFocusableWindowState(this.isManualyOpened);
        super.show();
    }

    private void doUpdateSizeLocation() {
        logger.debug((Object)"doUpdateSizeLocation entered");
        this.removeComponentListener(this.boundsListener);
        if (EngineCommandManager.getUserInfo() == null) {
            logger.debug((Object)"user = null");
            UIUtils.setPrefferedWindowSize(360, 400, this);
            UIUtils.centerWindowOnScreen(this);
        } else {
            logger.debug((Object)"get FrameParameters");
            int h = ApplicationOptions.getInstance().getInteger(this.WINH_KEY, 400);
            int w = ApplicationOptions.getInstance().getInteger(this.WINW_KEY, 360);
            int x = ApplicationOptions.getInstance().getInteger(this.WINX_KEY, 0);
            int y = ApplicationOptions.getInstance().getInteger(this.WINY_KEY, 0);
            Rectangle bounds = new Rectangle(x, y, w, h);
            if (StatusWindowFrame.checkBounds(bounds)) {
                logger.debug((Object)"check bounds = TRUE");
                UIUtils.setPrefferedWindowSizeLocation(this, h, x, y);
            } else {
                logger.debug((Object)"check bounds = FALSE");
                UIUtils.setPrefferedWindowSize(360, 400, this);
                UIUtils.centerWindowOnScreen(this);
            }
        }
        this.addComponentListener(this.boundsListener);
        logger.debug((Object)"doUpdateSizeLocation exited");
    }

    public void show() {
        if (!this.isShowing()) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.doShow();
            } else {
                try {
                    SwingUtilities.invokeAndWait(new ShowRunner());
                }
                catch (InterruptedException e) {
                    logger.error((Object)e, (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }
        }
    }

    private synchronized void doUpdateTime() {
        long current = System.currentTimeMillis();
        long diff = current - this.startTime;
        String left = this.format.format(new Date(diff));
        this.time.setText(StringResources.formatString(StringResources.TIME_ELAPSED_C, left));
    }

    private void updateTime() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doUpdateTime();
        } else {
            try {
                SwingUtilities.invokeAndWait(new TimerUpdateRunner());
            }
            catch (InterruptedException e) {
                logger.error((Object)e, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    public void switchView() {
        if (this.isVisible()) {
            this.isManualyOpened = false;
            this.dispose();
        } else {
            this.isManualyOpened = true;
            this.show();
        }
    }

    public boolean isManualyOpened() {
        return this.isManualyOpened && this.doAutoShow;
    }

    private void updateParams() {
        logger.debug((Object)"updateParams entered");
        Rectangle bounds = this.getBounds();
        if (StatusWindowFrame.checkBounds(bounds)) {
            ApplicationOptions.getInstance().put(this.WINH_KEY, new Integer(bounds.height));
            ApplicationOptions.getInstance().put(this.WINW_KEY, new Integer(bounds.width));
            ApplicationOptions.getInstance().put(this.WINX_KEY, new Integer(bounds.x));
            ApplicationOptions.getInstance().put(this.WINY_KEY, new Integer(bounds.y));
        }
        logger.debug((Object)"updateParams exited");
    }

    private static boolean checkBounds(Rectangle theBounds) {
        double width = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        double height = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        double x = theBounds.getX();
        double y = theBounds.getY();
        double w = theBounds.getWidth();
        double h = theBounds.getHeight();
        double deltaH = height - 200.0;
        double deltaW = width - 200.0;
        return !(x < 0.0 || y < 0.0 || x > deltaW || y > deltaH || h > deltaH) && !(w > deltaW);
    }

    public void setSyncStarted(boolean syncStarted) {
        this.btnCancel.setEnabled(syncStarted);
    }

    private void showMe() {
        super.show();
    }

    private class TitleListener
    extends MouseAdapter
    implements MouseMotionListener {
        private Point pointPressed = null;

        private TitleListener() {
        }

        public void mousePressed(MouseEvent me) {
            this.pointPressed = me.getPoint();
        }

        public void mouseReleased(MouseEvent me) {
            this.pointPressed = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseDragged(MouseEvent me) {
            Point point = this.pointPressed;
            synchronized (point) {
                if (this.pointPressed == null) {
                    return;
                }
                StatusWindowFrame frame = StatusWindowFrame.this;
                Point point2 = me.getPoint();
                point2.translate(-this.pointPressed.x, -this.pointPressed.y);
                SwingUtilities.convertPointToScreen(point2, frame);
                frame.setLocation(point2);
            }
        }

        public void mouseMoved(MouseEvent e) {
        }
    }

    private class CompListener
    extends ComponentAdapter {
        private CompListener() {
        }

        public void componentResized(ComponentEvent e) {
            StatusWindowFrame.this.updateParams();
        }

        public void componentMoved(ComponentEvent e) {
            StatusWindowFrame.this.updateParams();
        }
    }

    private class HideRunner
    implements Runnable {
        private HideRunner() {
        }

        public void run() {
            StatusWindowFrame.this.doHide();
        }
    }

    private class ShowRunner
    implements Runnable {
        private ShowRunner() {
        }

        public void run() {
            StatusWindowFrame.this.doShow();
        }
    }

    private class TimerUpdateRunner
    implements Runnable {
        private TimerUpdateRunner() {
        }

        public void run() {
            StatusWindowFrame.this.doUpdateTime();
        }
    }

    private class TimeTickAction
    implements ActionListener {
        private TimeTickAction() {
        }

        public void actionPerformed(ActionEvent e) {
            StatusWindowFrame.this.updateTime();
        }
    }

    private class LeftTimer
    extends Timer {
        public LeftTimer(int delay, ActionListener listener) {
            super(delay, listener);
        }

        public void start() {
            StatusWindowFrame.this.startTime = System.currentTimeMillis();
            super.start();
        }
    }

    private class CancelButtonActionListener
    implements ActionListener {
        private CancelButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            StatusWindowFrame.doCancel();
        }
    }

    private class HideButtonActionListener
    implements ActionListener {
        private HideButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            StatusWindowFrame.this.dispose();
        }
    }
}

