/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.eng_impl.utils;

import com.novell.gw.jclient.api.impl.APIWrapperManager;
import com.novell.gw.jclient.api.interfaces.IColumnFieldInfo;
import com.novell.gw.jclient.bl.eng_impl.utils.APIUtils;
import com.novell.gw.jclient.bl.eng_impl.utils.SortOrder;
import java.io.Serializable;

public final class ColumnInfo
implements Cloneable,
Serializable {
    private transient IColumnFieldInfo nativeColumnInfo;

    public ColumnInfo(IColumnFieldInfo theDisplayColumnInfo) {
        this.nativeColumnInfo = theDisplayColumnInfo;
    }

    public IColumnFieldInfo getNativeColumnInfo() {
        return this.nativeColumnInfo;
    }

    public String getName() {
        return this.nativeColumnInfo.getName();
    }

    public int getFieldID() {
        return this.nativeColumnInfo.getFieldID();
    }

    public boolean isSorted() {
        return this.nativeColumnInfo.isSorted();
    }

    public boolean isSortedAscending() {
        return this.isSorted() && this.getSortOrder() == SortOrder.ASCENDING;
    }

    public boolean isSortedDescending() {
        return this.isSorted() && this.getSortOrder() == SortOrder.DESCENDING;
    }

    public SortOrder getSortOrder() {
        return APIUtils.getSortOrder(this.nativeColumnInfo.getSortOption());
    }

    public int getWidth() {
        return this.nativeColumnInfo.getWidth();
    }

    public void setWidth(int theWidth) {
        this.nativeColumnInfo.setWidth(theWidth);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof ColumnInfo && this.doEquals((ColumnInfo)obj);
    }

    private boolean doEquals(ColumnInfo columnInfo) {
        return this.getFieldID() == columnInfo.getFieldID() && this.isSorted() == columnInfo.isSorted() && this.getName().equals(columnInfo.getName()) && this.getSortOrder().equals(columnInfo.getSortOrder()) && this.getWidth() == columnInfo.getWidth();
    }

    public String toString() {
        return this.getName();
    }

    public void setSorted(boolean b) {
        if (b && !this.nativeColumnInfo.isSorted()) {
            this.nativeColumnInfo.setSortOption(16);
        } else if (!b && this.nativeColumnInfo.isSorted()) {
            this.nativeColumnInfo.setSortOption(28);
        }
    }

    public void setSortOrder(SortOrder theSortOrder) {
        this.nativeColumnInfo.setSortOption(theSortOrder.getID());
    }

    public Object clone() throws CloneNotSupportedException {
        ColumnInfo clone = (ColumnInfo)super.clone();
        clone.nativeColumnInfo = APIWrapperManager.createColumnFieldInfo(this.nativeColumnInfo.getName(), this.nativeColumnInfo.getFieldID(), this.nativeColumnInfo.getWidth(), this.nativeColumnInfo.getSortOption());
        return clone;
    }
}

