/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.eng_impl.utils;

import com.novell.gw.jclient.api.interfaces.IColumnAndSortInfo;
import com.novell.gw.jclient.api.interfaces.IColumnFieldInfo;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.bl.eng_impl.utils.ColumnInfo;
import com.novell.gw.jclient.bl.eng_impl.utils.SortOrder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class ColumnInfos
implements Cloneable,
Serializable {
    private static Logger logger = Logger.getLogger(ColumnInfos.class);
    private ArrayList<ColumnInfo> columns = new ArrayList();
    private String type;
    private ColumnInfo sortedColumn = null;
    private IViewDisplaySettings displaySettings;

    public ColumnInfos() {
    }

    public ColumnInfos(IColumnFieldInfo[] theInfos) {
        this();
        if (theInfos == null) {
            throw new IllegalArgumentException("Input paramether can not be NULL");
        }
        for (IColumnFieldInfo columnFieldInfo : theInfos) {
            if (columnFieldInfo == null) continue;
            this.columns.add(new ColumnInfo(columnFieldInfo));
        }
    }

    public ColumnInfos(IColumnAndSortInfo columnAndSortInfo) {
        this(columnAndSortInfo.getVisibleColumns());
        if (columnAndSortInfo.getSortField() != null) {
            if (this.sortedColumn == null) {
                this.sortedColumn = this.getColumnByName(columnAndSortInfo.getSortField().getName());
            }
            if (this.sortedColumn == null) {
                this.sortedColumn = new ColumnInfo(columnAndSortInfo.getSortField());
            }
        }
    }

    public ColumnInfos(IViewDisplaySettings nativeDisplaySettings) {
        this(nativeDisplaySettings.getColumnAndSortInfo());
        this.displaySettings = nativeDisplaySettings;
    }

    private ColumnInfo getColumnByName(String name) {
        for (ColumnInfo columnInfo : this.columns) {
            if (!columnInfo.getName().equals(name)) continue;
            return columnInfo;
        }
        return null;
    }

    public void add(int index, ColumnInfo theInfo) {
        if (theInfo != null && !this.columns.contains(theInfo) && this.getColumnInfo(theInfo.getFieldID()) == null) {
            this.columns.add(index, theInfo);
        }
    }

    public void add(ColumnInfo theColumnInfo) {
        if (theColumnInfo != null && !this.columns.contains(theColumnInfo)) {
            if (this.sortedColumn.getName().equals(theColumnInfo.getName())) {
                this.columns.add(this.sortedColumn);
                if (this.sortedColumn.getWidth() == 0) {
                    this.sortedColumn.setWidth(theColumnInfo.getWidth());
                }
            } else {
                this.columns.add(theColumnInfo);
                if (theColumnInfo.isSorted()) {
                    this.sortedColumn = theColumnInfo;
                }
            }
        }
    }

    public ColumnInfo remove(int index) {
        return this.columns.remove(index);
    }

    public boolean remove(ColumnInfo theColumnInfo) {
        return this.columns.remove(theColumnInfo);
    }

    public void clear() {
        this.columns.clear();
    }

    public int size() {
        return this.columns.size();
    }

    public ColumnInfo get(int index) {
        return this.columns.get(index);
    }

    public ColumnInfo getSorted() {
        if (this.sortedColumn == null) {
            int nSize = this.columns.size();
            for (int i = 0; i < nSize; ++i) {
                ColumnInfo info = this.columns.get(i);
                if (info == null || !info.isSorted()) continue;
                this.sortedColumn = info;
                break;
            }
        }
        return this.sortedColumn;
    }

    public ColumnInfo[] toArray() {
        return this.columns.toArray(new ColumnInfo[this.columns.size()]);
    }

    public IColumnFieldInfo[] getNativeColumnInfos() {
        IColumnFieldInfo[] result = new IColumnFieldInfo[this.columns.size()];
        int nSize = this.columns.size();
        for (int i = 0; i < nSize; ++i) {
            ColumnInfo columnInfo = this.columns.get(i);
            result[i] = columnInfo.getNativeColumnInfo();
        }
        return result;
    }

    public IColumnFieldInfo getNativeSortedColumnInfo() {
        return this.sortedColumn == null ? null : this.sortedColumn.getNativeColumnInfo();
    }

    public String getColumnsListAsString() {
        StringBuilder visibleInfos = new StringBuilder();
        int size = this.columns.size();
        for (int i = 0; i < size; ++i) {
            ColumnInfo columnInfo = this.columns.get(i);
            visibleInfos.append(columnInfo.getName());
            if (i >= size - 1) continue;
            visibleInfos.append(", ");
        }
        return visibleInfos.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        ColumnInfos clone = (ColumnInfos)super.clone();
        clone.type = this.type;
        clone.columns = new ArrayList();
        int nSize = this.columns.size();
        for (int i = 0; i < nSize; ++i) {
            ColumnInfo info = this.columns.get(i);
            clone.columns.add((ColumnInfo)info.clone());
        }
        return clone;
    }

    boolean addColumnInfo(ColumnInfo theInfo) {
        if (theInfo != null) {
            int id;
            if (!this.columns.contains(theInfo) && this.getColumnInfo(theInfo.getFieldID()) == null) {
                return this.columns.add(theInfo);
            }
            if (theInfo.isSorted() && (id = this.retrieveIndex(theInfo)) > -1 && id < this.columns.size()) {
                this.columns.set(id, theInfo);
                return true;
            }
        }
        return false;
    }

    private int retrieveIndex(ColumnInfo c) {
        int res = -1;
        if (c != null) {
            int n = this.columns.size();
            for (int i = 0; i < n; ++i) {
                ColumnInfo ci = this.columns.get(i);
                if (ci.getFieldID() != c.getFieldID()) continue;
                res = i;
                break;
            }
        }
        return res;
    }

    public String getType() {
        return this.type;
    }

    private void clearSortInfos() {
        for (ColumnInfo column : this.columns) {
            column.setSorted(false);
        }
        this.sortedColumn = null;
    }

    public ColumnInfo getColumnInfo(int theFieldID) {
        ColumnInfo result = null;
        int nSize = this.columns.size();
        for (int i = 0; i < nSize; ++i) {
            ColumnInfo columnInfo = this.columns.get(i);
            if (columnInfo.getFieldID() != theFieldID) continue;
            result = columnInfo;
            break;
        }
        return result;
    }

    public void setSortColumn(ColumnInfo theColumnInfo, SortOrder theSortOrder) {
        this.clearSortInfos();
        if (theColumnInfo != null) {
            ColumnInfo columnInfo = this.getColumnByName(theColumnInfo.getName());
            if (columnInfo != null) {
                columnInfo.setSorted(true);
                columnInfo.setSortOrder(theSortOrder);
                this.sortedColumn = columnInfo;
            } else {
                theColumnInfo.setSortOrder(theSortOrder);
                if (this.sortedColumn != null) {
                    this.sortedColumn.setSorted(false);
                }
                this.sortedColumn = theColumnInfo;
                this.sortedColumn.setSortOrder(theSortOrder);
            }
        }
    }

    public void moveInfos(ColumnInfo theColumnInfo1, ColumnInfo theColumnInfo2) {
        if (this.columns.contains(theColumnInfo1) && this.columns.contains(theColumnInfo2)) {
            int pos1 = this.columns.indexOf(theColumnInfo1);
            int pos2 = this.columns.indexOf(theColumnInfo2);
            Collections.swap(this.columns, pos1, pos2);
        }
    }

    public static ColumnInfos getDifferenceByFieldID(ColumnInfos theColumnInfos1, ColumnInfos theColumnInfos2) throws CloneNotSupportedException {
        ColumnInfos result = (ColumnInfos)theColumnInfos1.clone();
        Iterator<ColumnInfo> iterator = result.columns.iterator();
        while (iterator.hasNext()) {
            ColumnInfo columnInfo = iterator.next();
            if (theColumnInfos2.getColumnInfo(columnInfo.getFieldID()) == null) continue;
            iterator.remove();
        }
        return result;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof ColumnInfos && this.doEquals((ColumnInfos)obj);
    }

    private boolean doEquals(ColumnInfos columnInfos) {
        if (this.getColumnsListAsString().equals(columnInfos.getColumnsListAsString()) && this.columns.size() == columnInfos.columns.size()) {
            int nSize = this.columns.size();
            for (int i = 0; i < nSize; ++i) {
                if (this.columns.get(i).equals(columnInfos.columns.get(i))) continue;
                return false;
            }
            ColumnInfo thisSorted = this.getSorted();
            ColumnInfo infoSorted = columnInfos.getSorted();
            return thisSorted == null && infoSorted == null || thisSorted != null && infoSorted != null && thisSorted.getFieldID() == infoSorted.getFieldID() && thisSorted.isSortedAscending() == infoSorted.isSortedAscending() && thisSorted.isSortedDescending() == infoSorted.isSortedDescending() && thisSorted.getSortOrder().equals(infoSorted.getSortOrder());
        }
        return false;
    }

    public ColumnInfo getColumnInfoAt(int theIndex) {
        return this.columns.get(theIndex - 1);
    }

    public boolean removeColumnInfoAt(int theIndex) {
        return this.remove(this.getColumnInfoAt(theIndex));
    }

    public int getIndexOf(ColumnInfo theColumnInfo) {
        return this.columns.indexOf(theColumnInfo) + 1;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Column columns: [");
        for (ColumnInfo column : this.columns) {
            result.append('[').append("name = ").append(column.getName()).append(", width = ").append(column.getWidth()).append(']');
        }
        result.append(']');
        return result.toString();
    }

    public void save() {
        if (this.displaySettings != null) {
            this.displaySettings.setColumnAndSortInfo(this.getNativeColumnInfos(), this.getNativeSortedColumnInfo());
        }
    }

    public IViewDisplaySettings getDisplaySettings() {
        return this.displaySettings;
    }
}

