/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.impl;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Observable;
import java.util.Observer;
import org.apache.log4j.Logger;

public class StreamHandler {
    private static Logger logger = Logger.getLogger(StreamHandler.class);
    private CopyObservable copyObservable;
    private boolean useNotification;
    private static final int BUFFER_SIZE = 1024;
    private static StreamHandlerLocal streamHandlerLocal = new StreamHandlerLocal();

    private StreamHandler(boolean theUseNotification) {
        this.useNotification = theUseNotification;
        this.copyObservable = new CopyObservable();
    }

    private void setUseNotification(boolean b) {
        this.useNotification = b;
    }

    public static synchronized StreamHandler getInstance() {
        return StreamHandler.getInstance(false);
    }

    public static synchronized StreamHandler getInstance(boolean useNotify) {
        return streamHandlerLocal.get(useNotify);
    }

    public synchronized void copyStream(InputStream in, OutputStream out) throws IOException {
        if (in == null || out == null) {
            throw new NullPointerException("Streams cann't be null.");
        }
        BufferedInputStream stream = new BufferedInputStream(in);
        int n = 0;
        byte[] buffer = new byte[1024];
        while ((n = stream.read(buffer)) > 0) {
            out.write(buffer, 0, n);
            this.notifyCopyProgress(n);
        }
        out.flush();
        out.close();
        stream.close();
    }

    public synchronized byte[] getStreamData(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        this.copyStream(in, out);
        byte[] res = out.toByteArray();
        return res == null ? new byte[]{} : res;
    }

    public synchronized void addCopyListener(CopyProgressListener l) {
        this.copyObservable.addObserver(l);
    }

    public synchronized void removeCopyListener(CopyProgressListener l) {
        this.copyObservable.deleteObserver(l);
    }

    private void notifyCopyProgress(int copiedBytes) {
        if (this.useNotification) {
            this.copyObservable.notifyObservers(new Integer(copiedBytes));
        }
    }

    private static class StreamHandlerLocal
    extends ThreadLocal {
        private StreamHandlerLocal() {
        }

        protected synchronized Object initialValue() {
            return new StreamHandler(false);
        }

        public StreamHandler get(boolean b) {
            StreamHandler sh = (StreamHandler)super.get();
            sh.setUseNotification(b);
            return sh;
        }
    }

    private static class CopyObservable
    extends Observable {
        private CopyObservable() {
        }

        public void notifyObservers(Integer copiedBytes) {
            this.setChanged();
            super.notifyObservers(copiedBytes);
            this.setChanged();
        }
    }

    public static interface CopyProgressListener
    extends Observer {
    }
}

