/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.impl.cache;

import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;

public class ItemsCache {
    private static volatile Map cache = new Hashtable();

    public static synchronized AbstractItem getItem(String theItemID, String userGuid) {
        return (AbstractItem)ItemsCache.getItemList(userGuid).get(theItemID);
    }

    private static synchronized Cashe getItemList(String userGuid) {
        Cashe itemLists = (Cashe)cache.get(userGuid);
        if (itemLists == null) {
            itemLists = new Cashe();
            cache.put(userGuid, itemLists);
        }
        return itemLists;
    }

    public static synchronized boolean containsItem(String theItemID, String userGuid) {
        return ItemsCache.getItemList(userGuid).containsKey(theItemID);
    }

    public static synchronized void putItem(AbstractItem theItem, String userGuid) {
        if (!ItemsCache.containsItem(theItem.getID(), userGuid)) {
            ItemsCache.getItemList(userGuid).put(theItem.getID(), theItem);
        }
    }

    public static void clear() {
        cache.clear();
    }

    public static void clear(String userGuid) {
        ItemsCache.getItemList(userGuid).clear();
        cache.remove(userGuid);
    }

    public static int getCount(String userGuid) {
        return ItemsCache.getItemList(userGuid).size();
    }

    private static class Cashe
    extends LinkedHashMap {
        private static final int MAX_COUNT = 1000;

        private Cashe() {
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 1000;
        }
    }
}

