/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.impl.dnd;

import com.novell.gw.engine.TransferItems;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.application.controls.DnDUtils;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.eng_impl.GWItemFactory;
import com.novell.gw.jclient.bl.impl.dnd.GWFlavors;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.exceptions.GWException;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransferableWrapper
implements Transferable {
    private static Logger logger = Logger.getLogger(TransferableWrapper.class);
    private String parentFolderId;
    private GWFlavors.SingleItem singleTableItem;
    private IItemList itemList;
    private ArrayList<DataFlavor> flavors;
    private int[] indices;
    private TransferItems transferItems;
    private String folderID;
    private Boolean isFoldersOnly;
    private String userGuid;
    private int viewMode;

    private TransferableWrapper(TransferItems transferItems, String userGuid) {
        logger.debug((Object)("transferItems: " + transferItems));
        logger.debug((Object)("userGuid: " + userGuid));
        this.transferItems = transferItems;
        this.userGuid = userGuid;
        this.flavors = new ArrayList();
        this.flavors.add(GWFlavors.transferItemsFlavor);
        this.flavors.add(GWFlavors.userGuidFlavor);
    }

    public TransferableWrapper(IItemList itemList, int[] indices, boolean isDocumentsTransfer, boolean onlyFolders, String userGuid, IViewDisplaySettings viewDisplaySettings, AbstractFolder parentFolder) {
        this(itemList.getTransferItems(indices), userGuid);
        this.itemList = itemList;
        this.indices = indices;
        this.viewMode = viewDisplaySettings.getViewMode();
        this.isFoldersOnly = onlyFolders;
        if (!isDocumentsTransfer) {
            this.parentFolderId = parentFolder.getID();
            this.flavors.add(GWFlavors.folderFlavor);
            this.flavors.add(DataFlavor.javaFileListFlavor);
            this.flavors.add(GWFlavors.uriListFlavor);
            this.flavors.add(GWFlavors.parentFolderFlavor);
            this.flavors.add(GWFlavors.indicesFlavor);
            this.flavors.add(GWFlavors.viewModeFlavor);
            this.flavors.add(GWFlavors.foldersOnlyFlavor);
            if (indices.length == 1) {
                IItem item = this.itemList.getItemAt(indices[0]);
                if (item instanceof IMessage) {
                    try {
                        String id = EngineCommandManager.getInstance(userGuid).getItem(this.itemList, (IMessage)item).getID();
                        this.singleTableItem = new GWFlavors.SingleItem(0, id);
                        this.flavors.add(GWFlavors.singleTableItemFlavor);
                    }
                    catch (GWCommandException e) {
                        logger.error((Object)e);
                    }
                } else if (item instanceof IFolder) {
                    String id = EngineCommandManager.getInstance(userGuid).getGWFolder((IFolder)item).getID();
                    this.singleTableItem = new GWFlavors.SingleItem(1, id);
                    this.flavors.add(GWFlavors.singleTableItemFlavor);
                }
            }
        }
    }

    public TransferableWrapper(AbstractFolder selectedFolder, String userGuid) {
        this(selectedFolder.getTransferItems(), userGuid);
        this.folderID = selectedFolder.getID();
        this.singleTableItem = new GWFlavors.SingleItem(1, selectedFolder.getID());
        this.flavors.add(GWFlavors.folderFlavor);
        this.flavors.add(GWFlavors.singleTableItemFlavor);
        this.flavors.add(GWFlavors.foldersOnlyFlavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors.toArray(new DataFlavor[this.flavors.size()]);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.flavors.contains(flavor);
    }

    private List<File> getFileList() {
        ArrayList<File> result = new ArrayList<File>(this.indices.length);
        for (int index : this.indices) {
            IItem item = this.itemList.getItemAt(index);
            try {
                String path;
                File file;
                if (!(item instanceof IMessage) || !(file = new File(path = DnDUtils.saveItem(GWItemFactory.gwObjectToItem((IMessage)item)))).isFile()) continue;
                result.add(file);
            }
            catch (GWException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (this.isDataFlavorSupported(flavor)) {
            if (flavor.equals(GWFlavors.transferItemsFlavor)) {
                return this.transferItems;
            }
            if (flavor.equals(GWFlavors.userGuidFlavor)) {
                return this.userGuid;
            }
            if (flavor.equals(GWFlavors.folderFlavor)) {
                return this.folderID;
            }
            if (flavor.equals(GWFlavors.indicesFlavor)) {
                return this.indices;
            }
            if (flavor.equals(DataFlavor.javaFileListFlavor)) {
                return this.getFileList();
            }
            if (flavor.equals(GWFlavors.uriListFlavor)) {
                return DnDUtils.getUrlFromFileList(this.getFileList());
            }
            if (flavor.equals(GWFlavors.parentFolderFlavor)) {
                return this.parentFolderId;
            }
            if (flavor.equals(GWFlavors.singleTableItemFlavor)) {
                return this.singleTableItem;
            }
            if (flavor.equals(GWFlavors.foldersOnlyFlavor)) {
                return this.isFoldersOnly;
            }
            if (flavor.equals(GWFlavors.viewModeFlavor)) {
                return this.viewMode;
            }
        }
        throw new UnsupportedFlavorException(flavor);
    }
}

