/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om;

import com.appframework.utils.Utils;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWUserInfo;
import java.io.File;
import org.apache.log4j.Logger;

public class PathManager {
    private static Logger logger = Logger.getLogger(PathManager.class);
    public static final String OLDOPTIONSPATH = Utils.USER_HOME + File.separator + ".Groupwise" + File.separator;
    private static final String OPTIONSPATH = Utils.USER_HOME + File.separator + ".novell" + File.separator + "groupwise" + File.separator;

    public static String getBaseOptionsPath() {
        return OPTIONSPATH;
    }

    public static String getUserOptionsPath() {
        String path = PathManager.getBaseOptionsPath() + PathManager.getUserName();
        File userDir = new File(path);
        File oldUserDir = new File(OLDOPTIONSPATH + PathManager.getUserName());
        if (oldUserDir.exists()) {
            if (!userDir.exists()) {
                boolean stat = oldUserDir.renameTo(userDir);
                logger.debug((Object)("Renamed old user dir: " + stat));
            } else {
                boolean stat;
                File[] oldFiles;
                for (File oldFile : oldFiles = oldUserDir.listFiles()) {
                    File newFile = new File(userDir, oldFile.getName());
                    if (newFile.exists()) continue;
                    stat = oldFile.renameTo(newFile);
                    logger.debug((Object)("Moved file (" + oldFile.getName() + ") from old user dir to new user dir: " + stat));
                }
                Utils.clearDir(oldUserDir);
                stat = oldUserDir.delete();
                logger.debug((Object)("Deleted old user dir: " + stat));
            }
        }
        if (!userDir.exists()) {
            userDir.mkdirs();
        }
        path = path + File.separator;
        return path;
    }

    public static String getTempFolderPath() {
        String path = PathManager.getUserOptionsPath() + "Client";
        File folder = new File(path);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        path = path + File.separator;
        return path;
    }

    private static String getUserName() {
        GWUserInfo userInfo = EngineCommandManager.getUserInfo();
        if (userInfo == null) {
            return ".unknown_user";
        }
        return userInfo.getName();
    }

    public static void deleteUserTempDir() {
        String tempFolderPath = PathManager.getTempFolderPath();
        if (tempFolderPath != null) {
            File tempDir = new File(tempFolderPath);
            PathManager.deleteDirTree(tempDir);
        }
    }

    private static void deleteDirTree(File theFile) {
        File[] files = theFile.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                PathManager.deleteDirTree(file);
                continue;
            }
            file.delete();
        }
        theFile.delete();
    }
}

