/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.items;

import com.appframework.components.htmleditor.hyperlink.HTMLUtils;
import com.appframework.components.htmleditor.hyperlink.LinkParser;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.api.enums.MessageSuggestedBodyFormat;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.api.interfaces.message.ISuggestedBody;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.MessageBodyFormat;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StringReader;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.rtf.RTFEditorKit;
import org.apache.log4j.Logger;

public class MessageBody
implements Serializable {
    private static Logger logger = Logger.getLogger(MessageBody.class);
    private static final String DEFAULT_TEXT = "";
    private String htmlText = null;
    private String plainText = null;
    private String rtfText = null;
    private boolean htmlTextSet = false;
    private boolean plainTextSet = false;
    private boolean rtfTextSet = false;
    private AbstractItem item = null;
    private MessageBodyFormat lastTextFormat;

    public MessageBody(AbstractItem item) {
        this.item = item;
    }

    @Deprecated
    public String getMessage() {
        MessageBodyFormat format = this.getPreferredBodyFormat();
        if (MessageBodyFormat.HTML.equals((Object)format)) {
            return this.getHtmlText();
        }
        return this.getRtfText();
    }

    public boolean isRtfMessage() {
        return !Utils.isNullOrEmpty(this.getRtfText());
    }

    public long getSize() {
        return Utils.isNullOrEmpty(this.getPlainText()) ? 0L : (long)(this.getPlainText().length() * 2);
    }

    public boolean isHtmlTextSet() {
        return this.htmlTextSet;
    }

    public boolean isRtfTextSet() {
        return this.rtfTextSet;
    }

    public String getHtmlText() {
        if (!this.htmlTextSet) {
            this.loadHtmlText();
        }
        return this.htmlText;
    }

    public void setHtmlText(String htmlText) {
        this.htmlTextSet = true;
        this.setLastTextFormat(MessageBodyFormat.HTML);
        this.htmlText = htmlText;
    }

    public void setSuggestedBody(ISuggestedBody suggestedBody) {
        if (suggestedBody == null) {
            throw new IllegalArgumentException("suggestedBody is null");
        }
        if (suggestedBody.getFormat() == MessageSuggestedBodyFormat.HTML) {
            this.setHtmlText(suggestedBody.getText());
        } else {
            this.setRtfText(suggestedBody.getText());
        }
    }

    public String getPlainText() {
        if (!this.plainTextSet) {
            this.loadPlainText();
        }
        return this.plainText;
    }

    public String getRtfText() {
        if (!this.rtfTextSet) {
            this.loadRtfText();
        }
        return this.rtfText;
    }

    public void setRtfText(String rtfText) {
        this.rtfTextSet = true;
        this.setLastTextFormat(MessageBodyFormat.RTF);
        this.rtfText = rtfText;
    }

    private void loadHtmlText() {
        if (this.item == null) {
            this.htmlText = HTMLUtils.getEmptyHTML();
        } else if (this.item.isHTMLMessage()) {
            String path = this.item.getHTMLBodyTextFile();
            try {
                String text = Utils.readTextFromReader(new FileReader(path));
                text = HTMLUtils.replaceTags(text, "DIV", "P");
                text = HTMLUtils.replaceTags(text, "STRONG", "B");
                this.htmlText = text = HTMLUtils.replaceTags(text, "EM", "I");
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
                if (this.htmlText == null) {
                    this.htmlText = HTMLUtils.getEmptyHTML();
                }
            }
        } else {
            String plainMessage = this.getPlainText();
            this.htmlText = LinkParser.createLinkedText(plainMessage);
        }
        assert (this.htmlText != null);
        this.htmlTextSet = true;
        this.setLastTextFormat(MessageBodyFormat.HTML);
    }

    private void loadPlainText() {
        if (this.item == null) {
            this.plainText = DEFAULT_TEXT;
        } else {
            String rtf = this.getRtfText();
            if (Utils.isNullOrEmpty(rtf)) {
                this.plainText = DEFAULT_TEXT;
            } else {
                String text = null;
                RTFEditorKit kit = new RTFEditorKit();
                try {
                    Document doc = kit.createDefaultDocument();
                    kit.read(new StringReader(this.getRtfText()), doc, 0);
                    text = HTMLUtils.fixChars(doc.getText(0, doc.getLength()));
                }
                catch (IOException e) {
                    logger.error((Object)e, (Throwable)e);
                }
                catch (BadLocationException e) {
                    logger.error((Object)e, (Throwable)e);
                }
                if (MessageBody.isHtmlOnlyWarningNeeded(this.item.getNativeItem(), rtf)) {
                    text = StringResources.HTML_ONLY_WARNING;
                }
                this.plainText = text;
            }
        }
        this.plainTextSet = true;
    }

    private void loadRtfText() {
        if (this.item == null) {
            this.rtfText = DEFAULT_TEXT;
        } else {
            String text = DEFAULT_TEXT;
            InputStreamReader reader = this.item.getNativeItem().getBodyRtfReader();
            if (reader != null) {
                text = Utils.readTextFromReader(reader);
            }
            if (MessageBody.isHtmlOnlyWarningNeeded(this.item.getNativeItem(), text)) {
                text = "{\\rtf1 \\b " + StringResources.HTML_ONLY_WARNING + "\\b0}";
            }
            this.rtfText = text;
        }
        this.rtfTextSet = true;
        this.setLastTextFormat(MessageBodyFormat.RTF);
    }

    public MessageBodyFormat getLastTextFormat() {
        return this.lastTextFormat;
    }

    public void setLastTextFormat(MessageBodyFormat format) {
        this.lastTextFormat = format;
    }

    public void reload() {
        this.htmlText = null;
        this.plainText = null;
        this.rtfText = null;
        this.htmlTextSet = false;
        this.rtfTextSet = false;
        this.plainTextSet = false;
    }

    private MessageBodyFormat getPreferredBodyFormat() {
        if (this.item == null) {
            if (this.htmlTextSet) {
                return MessageBodyFormat.HTML;
            }
            if (this.rtfTextSet) {
                return MessageBodyFormat.RTF;
            }
            return HTMLUtils.isDefaultComposeHTML() ? MessageBodyFormat.HTML : MessageBodyFormat.RTF;
        }
        if (this.item.isHTMLMessage() || this.item.isHTMLMessageComposition()) {
            return MessageBodyFormat.HTML;
        }
        return MessageBodyFormat.RTF;
    }

    public static boolean isHTMLOnlyMessage(MessageBody messageBody) {
        return messageBody.item.getNativeItem().isHTMLMessage() && Utils.isNullOrEmpty(messageBody.getRtfText());
    }

    private static boolean isHtmlOnlyWarningNeeded(IMessage message, String rtfText) {
        return message.showHTMLOnlyWarning() && message.isHTMLMessage() && Utils.isNullOrEmpty(rtfText);
    }

    public MessageBody copyForItem(AbstractItem item, boolean isHTML, boolean isComposingParent) {
        MessageBody messageBody = new MessageBody(item);
        if (isHTML) {
            if (isComposingParent) {
                String html = this.getHtmlText();
                messageBody.setHtmlText(html);
            } else {
                messageBody.setSuggestedBody(item.getNativeItem().getSuggestedBody());
            }
        } else {
            messageBody.setRtfText(this.getRtfText());
        }
        return messageBody;
    }
}

