/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.items;

import com.appframework.Application;
import com.appframework.ApplicationFrame;
import com.appframework.components.htmleditor.hyperlink.HTMLUtils;
import com.appframework.level.Level;
import com.appframework.mvc.ControllerManager;
import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.MVCController;
import com.appframework.utils.UIUtils;
import com.appframework.utils.Utils;
import com.novell.gw.account.Account;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.api.enums.RecipientCopyType;
import com.novell.gw.jclient.api.impl.ab.APIAbWrapperManager;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.ab.IAddress;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.api.interfaces.folder.INntpFolder;
import com.novell.gw.jclient.api.interfaces.message.IAppointment;
import com.novell.gw.jclient.api.interfaces.message.IAttachment;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.actions.ActionAttachmentOpen;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.addressbook.InstallSharedABDialog;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.itemedit.ComposeMode;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.dialogs.installfolder.InstallFolderDialog;
import com.novell.gw.jclient.application.dialogs.saveasdialog.SaveAsDialog;
import com.novell.gw.jclient.application.frames.FramesFactory;
import com.novell.gw.jclient.application.frames.compose.FrameCompose;
import com.novell.gw.jclient.application.frames.compose.FrameComposeActionList;
import com.novell.gw.jclient.application.frames.compose.FrameComposePostedItem;
import com.novell.gw.jclient.application.frames.open.FrameOpen;
import com.novell.gw.jclient.application.frames.open.FrameOpenActionList;
import com.novell.gw.jclient.application.impl.SelectedItemsInfoImpl;
import com.novell.gw.jclient.application.interfaces.ISelectedItemsInfo;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.options.mailto.MailToOptions;
import com.novell.gw.jclient.application.options.mailto.MailToStringParser;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.application.startup.ComposeMailDispatcher;
import com.novell.gw.jclient.application.startup.MailToEvent;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import com.novell.gw.jclient.bl.eng_impl.GWItemFactory;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.NntpSubFolder;
import com.novell.gw.jclient.bl.om.items.AbstractCalendarItem;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.DocumentItem;
import com.novell.gw.jclient.bl.om.items.GWAttachment;
import com.novell.gw.jclient.bl.om.items.GWSharedFolderNotification;
import com.novell.gw.jclient.bl.om.items.MessageBodyFormat;
import com.novell.gw.jclient.bl.om.items.SharedAddressBookNotificationItem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageUtils {
    private static Logger logger = Logger.getLogger(MessageUtils.class);

    public static void openItem(IItemList itemList, AbstractItem item, String userGuid) {
        MessageUtils.openItem(itemList, item, userGuid, false);
    }

    public static void openItem(IItemList itemList, AbstractItem item, String userGuid, boolean cascade) {
        FrameOpen frameOpen = GWClient.getOpenFrame(item);
        if (frameOpen == null) {
            FrameOpen lastFrameOpen = Application.getLastFrameOpen();
            frameOpen = new FrameOpen(itemList, item, userGuid);
            GlobalCommand command = new GlobalCommand(480, frameOpen);
            ((FrameOpenActionList)frameOpen.getController()).processCommand(command);
            if (cascade && lastFrameOpen != null) {
                frameOpen.showMe(lastFrameOpen.getLocation().x + 20, lastFrameOpen.getLocation().y + 20);
            } else if (lastFrameOpen != null) {
                frameOpen.showMe(lastFrameOpen.getLocation().x, lastFrameOpen.getLocation().y);
            } else {
                frameOpen.showMe();
            }
        } else {
            frameOpen.showItemContent();
            if (frameOpen.isVisible()) {
                frameOpen.setVisible(true);
            }
            UIUtils.restoreFrameState(frameOpen);
            frameOpen.toFront();
        }
    }

    @Deprecated
    public static void openItem(AbstractItem theItem, MVCController theParentMainFrameController) {
        MessageUtils.openItem(theItem, theParentMainFrameController, false);
    }

    @Deprecated
    public static void openItem(AbstractItem item, MVCController theParentMainFrameController, boolean cascade) {
        FrameOpen frameOpen = GWClient.getOpenFrame(item);
        if (frameOpen == null) {
            FrameOpen lastFrameOpen = Application.getLastFrameOpen();
            frameOpen = new FrameOpen(null, item, ControlsUtils.getUserGuid(theParentMainFrameController));
            GlobalCommand command = new GlobalCommand(480, frameOpen);
            ((FrameOpenActionList)frameOpen.getController()).processCommand(command);
            if (cascade && lastFrameOpen != null) {
                frameOpen.showMe(lastFrameOpen.getLocation().x + 20, lastFrameOpen.getLocation().y + 20);
            } else if (lastFrameOpen != null) {
                frameOpen.showMe(lastFrameOpen.getLocation().x, lastFrameOpen.getLocation().y);
            } else {
                frameOpen.showMe();
            }
        } else {
            frameOpen.showItemContent();
            if (frameOpen.isVisible()) {
                frameOpen.setVisible(true);
            }
            UIUtils.restoreFrameState(frameOpen);
            frameOpen.toFront();
        }
    }

    public static void openMessageFromMimeFile(String filename, String userGUID, Component component) {
        try {
            IMessage message = EngineCommandManager.getInstance(EngineCommandManager.getUserGuid()).getCurrentDataStore().importMimeFile(filename);
            if (message != null) {
                AbstractItem item = GWItemFactory.gwObjectToItem(message);
                if (item instanceof GWSharedFolderNotification || item instanceof SharedAddressBookNotificationItem) {
                    logger.warn((Object)("Trying to open unsupported message. Message type: [" + item.getClass() + "]. Skipped."));
                    return;
                }
                if (Utils.isNullOrEmpty(userGUID)) {
                    MessageUtils.doOpenItem(null, item, false, EngineCommandManager.getUserGuid());
                } else {
                    MessageUtils.doOpenItem(null, item, false, userGUID);
                }
            }
        }
        catch (EngineException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
            ErrorDialog.processEngineException(e, component);
        }
        catch (GWCommandException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
            ErrorDialog.processGWException(e, component);
        }
    }

    public static void doOpenItem(IItemList itemList, AbstractItem item, boolean cascade, String userGuid) {
        MessageUtils.showBusyCursor(true);
        if (item instanceof GWSharedFolderNotification) {
            InstallFolderDialog installFolderDialog = new InstallFolderDialog(Application.getGWMainAppFrame(), (GWSharedFolderNotification)item);
            installFolderDialog.setVisible(true);
        } else if (item instanceof SharedAddressBookNotificationItem) {
            InstallSharedABDialog installFolderDialog = new InstallSharedABDialog((Frame)Application.getGWMainAppFrame(), (SharedAddressBookNotificationItem)item);
            installFolderDialog.pack();
            ((Dialog)installFolderDialog).setVisible(true);
        } else if (item instanceof DocumentItem) {
            MessageUtils.openDocumentItem(item);
        } else if (item.isPersonal() || item.getNativeItem().isPostedViewName()) {
            if (item.isProcessing()) {
                return;
            }
            MessageUtils.openPostedItem(item, userGuid);
        } else if (item.isDraft()) {
            MessageUtils.openDraftItem(item, userGuid);
        } else {
            MessageUtils.openItem(itemList, item, userGuid, cascade);
        }
        MessageUtils.showBusyCursor(false);
    }

    private static void openDocumentItem(AbstractItem item) {
        DocumentItem documentItem = (DocumentItem)item;
        GWAttachment attachment = documentItem.getAttachments().get(0);
        ActionAttachmentOpen.openAttachment(attachment);
    }

    private static void openPostedItem(AbstractItem theItem, String userGuid) {
        FrameCompose tempFrame = GWClient.getComposeFrame(theItem);
        if (tempFrame != null) {
            if (!tempFrame.isVisible()) {
                tempFrame.setVisible(true);
            }
            UIUtils.restoreFrameState(tempFrame);
            tempFrame.toFront();
        } else {
            try {
                ApplicationFrame frame;
                AbstractItem item = GWItemFactory.gwObjectToItem(theItem.getNativeItem());
                boolean canModify = item.getNativeItem().canModify();
                if (canModify) {
                    boolean isModify = item.isPersonal();
                    frame = new FrameComposePostedItem(item, isModify, ComposeMode.NEW, userGuid);
                } else {
                    frame = new FrameOpen(null, item, userGuid);
                }
                FrameOpen lastFrameOpen = Application.getLastFrameOpen();
                if (lastFrameOpen != null) {
                    frame.showMe(lastFrameOpen.getLocation().x, lastFrameOpen.getLocation().y);
                } else {
                    frame.showMe();
                }
                GlobalCommand command = new GlobalCommand(480, frame);
                frame.getController().processCommand(command);
            }
            catch (GWCommandException e) {
                logger.debug((Object)e, (Throwable)e);
            }
        }
    }

    private static void openDraftItem(AbstractItem theItem, String userGuid) {
        FrameCompose tempFrame = GWClient.getComposeFrame(theItem);
        if (tempFrame != null) {
            if (!tempFrame.isVisible()) {
                tempFrame.setVisible(true);
            }
            UIUtils.restoreFrameState(tempFrame);
            tempFrame.toFront();
        } else {
            try {
                AbstractItem item = GWItemFactory.gwObjectToItem(theItem.getNativeItem());
                FrameCompose frame = FramesFactory.getComposeFrame(item, true, ComposeMode.NEW, userGuid);
                FrameOpen lastFrameOpen = Application.getLastFrameOpen();
                if (lastFrameOpen != null) {
                    frame.showMe(lastFrameOpen.getLocation().x, lastFrameOpen.getLocation().y);
                } else {
                    frame.showMe();
                }
                GlobalCommand command = new GlobalCommand(480, frame);
                ((FrameComposeActionList)frame.getController()).processCommand(command);
            }
            catch (GWCommandException e) {
                logger.debug((Object)e, (Throwable)e);
            }
        }
    }

    public static MVCController getMainFrameController(MVCController theController) {
        Level frameLevel = theController.getFrameLevel();
        MVCController controller = ControllerManager.getInstance().get(frameLevel);
        if (controller.getMVCView() instanceof ApplicationFrame) {
            return controller;
        }
        return null;
    }

    private static boolean isDeletingAllowed(boolean isMultiple, Component component) {
        if (OptionManager.getInstance().getGeneralOptions().isDeleteConfirmationAllowed()) {
            String title;
            String message;
            if (isMultiple) {
                message = StringResources.DELETE_SELECTED_MESSAGES_Q;
                title = StringResources.DELETE_MESSAGES;
            } else {
                message = StringResources.DELETE_SELECTED_MESSAGE_Q;
                title = StringResources.DELETE_MESSAGE;
            }
            int res = JOptionPane.showConfirmDialog(component, message, title, 0);
            if (res != 0) {
                return false;
            }
        }
        return true;
    }

    public static boolean delete(List<AbstractItem> items, IItemList itemList, Component component) {
        if (MessageUtils.isDeletingAllowed(true, component)) {
            Application.disableFrames(items);
            return GWEngineUtils.deleteItems(itemList);
        }
        return false;
    }

    public static boolean delete(IItemList itemList, AbstractItem theAbstractGWItem, Component component) {
        if (MessageUtils.isDeletingAllowed(false, component)) {
            Application.disableFrames(theAbstractGWItem);
            return GWEngineUtils.deleteItem(itemList, theAbstractGWItem);
        }
        return false;
    }

    public static boolean deleteAndEmpty(IItemList itemList, AbstractItem item) {
        if (GWEngineUtils.deleteAndEmptyItem(itemList, item)) {
            Application.disableFrames(item);
            return true;
        }
        return false;
    }

    public static void saveAttachment(final GWAttachment attachment, final String filePath) {
        MessageUtils.showBusyCursor(true);
        Thread thread = new Thread(){

            public void run() {
                if (attachment != null) {
                    try {
                        GWEngineUtils.saveAttachment(attachment, filePath);
                    }
                    catch (GWCommandException e1) {
                        logger.error((Object)e1, (Throwable)e1);
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                ErrorDialog.processGWException(e1);
                            }
                        });
                    }
                }
            }
        };
        thread.start();
        MessageUtils.repaint(thread);
        MessageUtils.showBusyCursor(false);
    }

    public static void showBusyCursor(boolean b) {
        for (ApplicationFrame appFrame : Application.getAllFrames()) {
            MessageUtils.showBusyCursor(appFrame, b);
        }
    }

    private static void repaintFrames() {
        for (ApplicationFrame frame : Application.getAllFrames()) {
            JComponent component = (JComponent)frame.getContentPane();
            component.paintImmediately(component.getVisibleRect());
            frame.getJMenuBar().paintImmediately(frame.getJMenuBar().getVisibleRect());
            for (Window ownedWindow : frame.getOwnedWindows()) {
                Container contentPane;
                if (!(ownedWindow instanceof JDialog) || !ownedWindow.isShowing() || !((contentPane = ((JDialog)ownedWindow).getContentPane()) instanceof JComponent)) continue;
                ((JComponent)contentPane).paintImmediately(((JComponent)contentPane).getVisibleRect());
            }
        }
    }

    public static void showBusyCursor(JFrame frame, boolean b) {
        if (frame != null) {
            int cursorType;
            int n = cursorType = b ? 3 : 0;
            if (b && !UIUtils.isJDKMoreThan5()) {
                frame.setEnabled(true);
            }
            Component frameGlassPane = frame.getGlassPane();
            frameGlassPane.setCursor(Cursor.getPredefinedCursor(cursorType));
            frameGlassPane.setVisible(b);
            Window[] ownedWindows = frame.getOwnedWindows();
            int nCount = ownedWindows.length;
            for (int j = 0; j < nCount; ++j) {
                if (!(ownedWindows[j] instanceof JDialog) || !ownedWindows[j].isShowing()) continue;
                JDialog dialog = (JDialog)ownedWindows[j];
                Component dlgGlassPane = dialog.getGlassPane();
                dlgGlassPane.setCursor(Cursor.getPredefinedCursor(cursorType));
                dlgGlassPane.setVisible(b);
                if (!(dialog instanceof SaveAsDialog) || b || UIUtils.isJDKMoreThan5()) continue;
                dialog.getParent().setEnabled(false);
            }
        }
    }

    private static void repaint(Thread thread) {
        while (thread.isAlive()) {
            MessageUtils.repaintFrames();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                thread.interrupt();
                try {
                    thread.join();
                }
                catch (InterruptedException e1) {
                    logger.error((Object)e1);
                    logger.debug((Object)e1, (Throwable)e1);
                }
                if (Thread.currentThread().isInterrupted()) continue;
                Thread.currentThread().interrupt();
            }
        }
    }

    public static boolean isPersonalizeSubjectDifferent(IMessage message1, IMessage message2) {
        boolean message1IsDummy = message1.isChecklistDummyItem();
        boolean message2IsDummy = message2.isChecklistDummyItem();
        if (message1IsDummy && message2IsDummy) {
            logger.debug((Object)"both messages are checklist dummy items");
            return false;
        }
        if (message1IsDummy || message2IsDummy) {
            logger.debug((Object)"one message is checklist dummy item");
            return true;
        }
        assert (!message1IsDummy && !message2IsDummy);
        return !Utils.areObjectsNullsOrEqual(message1.getPersonalizeSubject(), message2.getPersonalizeSubject());
    }

    public static boolean isItemComposeModeHtml(AbstractItem item) {
        if (item.getNativeItem().isNNTPMessage() && EngineCommandManager.getAccountSettings().getNNTPAlwaysPostPlain()) {
            return false;
        }
        if (item.getMessage().getLastTextFormat() != null) {
            return MessageBodyFormat.HTML.equals((Object)item.getMessage().getLastTextFormat());
        }
        if (item.hasBodyText() && !item.isIgnoreMessageTypeOnCompose()) {
            return item.isHTMLMessage();
        }
        return HTMLUtils.isDefaultComposeHTML();
    }

    public static boolean isAdvancedReplyDialogNeeded(IMessage message) {
        if (message == null) {
            throw new IllegalArgumentException("message is null");
        }
        if (message.isPersonal()) {
            return true;
        }
        IFolder folder = message.getFolder();
        if (folder instanceof INntpFolder) {
            return true;
        }
        return folder.isSharedFolder() || folder.isSharedFolderReference();
    }

    public static boolean isNntpMessageOrHeader(IMessage message) {
        return message != null && (message.isNNTPHeader() || message.isNNTPMessage());
    }

    public static void prepareNewNntpMessage(AbstractItem newNntpItem, NntpSubFolder itemNntpFolder) {
        if (newNntpItem == null) {
            throw new IllegalArgumentException("newNntpItem is null");
        }
        if (itemNntpFolder == null) {
            throw new IllegalArgumentException("itemNntpFolder is null");
        }
        IDataStore dataStore = EngineCommandManager.getInstance(EngineCommandManager.getUserGuid()).getCurrentDataStore();
        assert (dataStore != null);
        Account nntpAccount = itemNntpFolder.getNativeFolder().getInternetAccount(dataStore);
        newNntpItem.getNativeItem().setSendingAccount(nntpAccount);
        ArrayList<IRecipient> toFolders = new ArrayList<IRecipient>();
        IAddress a = APIAbWrapperManager.createAddress(itemNntpFolder.getName(), itemNntpFolder.getName());
        toFolders.add(APIAbWrapperManager.createRecipient(a, RecipientCopyType.getTo()));
        newNntpItem.setRecipients(toFolders);
    }

    public static List<IItem> getItemsAsCollection(List list) {
        ArrayList<IItem> result = new ArrayList<IItem>();
        for (Object o : list) {
            IItem item;
            if (o instanceof IItem) {
                item = (IItem)o;
            } else {
                if (!(o instanceof AbstractItem)) continue;
                item = ((AbstractItem)o).getNativeObject();
            }
            result.add(item);
        }
        return result;
    }

    public static IItem[] getItemsAsArray(List list) {
        List<IItem> items = MessageUtils.getItemsAsCollection(list);
        return items.toArray(new IItem[items.size()]);
    }

    public static List<AbstractItem> convertToAbstractItemsList(IItem[] items) {
        ArrayList<AbstractItem> abstractItems = new ArrayList<AbstractItem>();
        try {
            for (IItem item : items) {
                if (item instanceof IMessage) {
                    AbstractItem newItem = GWItemFactory.gwObjectToItem((IMessage)item);
                    abstractItems.add(newItem);
                    continue;
                }
                logger.warn((Object)("unexpected item type: " + (item == null ? null : item.getClass().getName())));
                assert (false) : "unexpected item type: " + (item == null ? null : item.getClass().getName());
            }
        }
        catch (GWCommandException e) {
            ErrorDialog.processGWException(e);
        }
        return abstractItems;
    }

    public static List<AbstractCalendarItem> convertToAbstractCalendarItemsList(IItem[] items) {
        ArrayList<AbstractCalendarItem> calendarItems = new ArrayList<AbstractCalendarItem>();
        try {
            for (IItem item : items) {
                if (!(item instanceof IMessage)) continue;
                AbstractItem newItem = GWItemFactory.gwObjectToItem((IMessage)item);
                if (newItem instanceof AbstractCalendarItem) {
                    calendarItems.add((AbstractCalendarItem)newItem);
                    continue;
                }
                logger.warn((Object)("unexpected item type: " + (newItem == null ? null : newItem.getClass().getName())));
                assert (false) : "unexpected item type: " + (newItem == null ? null : newItem.getClass().getName());
            }
        }
        catch (GWCommandException e) {
            ErrorDialog.processGWException(e);
        }
        return calendarItems;
    }

    public static void prepareNewAppointment(IAppointment appointment) {
        if (appointment == null) {
            throw new IllegalArgumentException("appointment is null");
        }
        Date minimumDate = GWCalendarUtils.getToday().getTime();
        Date initialStartDate = appointment.getStartDate();
        if (initialStartDate == null || initialStartDate.getTime() < minimumDate.getTime()) {
            initialStartDate = minimumDate;
        }
        Date startDate = GWCalendarUtils.roundAppointmentStartDate(initialStartDate);
        appointment.setStartDate(startDate);
        int durationInMinutes = MessageUtils.getDefaultAppointmentDuration();
        Date endDate = new Date(startDate.getTime() + (long)(durationInMinutes * 60000));
        appointment.setEndDate(endDate);
    }

    public static int getDefaultAppointmentDuration() {
        return (Integer)EngineCommandManager.getInstance(EngineCommandManager.getUserGuid()).getCurrentDataStore().getSettings().getAppointmentDefaultLength().getValue();
    }

    public static boolean showAttachmentWindow(boolean isFrameOpen, IMessage message) {
        if (isFrameOpen) {
            if (message.getAttachments().length == 0) {
                return false;
            }
            for (IAttachment attachment : message.getAttachments()) {
                if (attachment.isSystemAttachment()) continue;
                return true;
            }
            return false;
        }
        return ApplicationOptions.getInstance().getBoolean("ATTACHLIST_VISIBLE");
    }

    public static void composeMail(String mailtoUrl) {
        MailToStringParser parser = new MailToStringParser();
        parser.setEncoding("UTF-8");
        MailToOptions mailToOptions = parser.createMailToOptions(mailtoUrl);
        logger.debug((Object)("mailToOptions: " + mailToOptions));
        ComposeMailDispatcher.dispatchEvent(new MailToEvent(mailToOptions));
    }

    public static boolean hasSingleItem(ISelectedItemsInfo selectedItemsInfo) {
        return selectedItemsInfo != null && !selectedItemsInfo.hasFolders() && selectedItemsInfo.hasItems() && selectedItemsInfo.getItems().size() == 1;
    }

    public static ISelectedItemsInfo createSelectedItemsInfo(IItem[] items, IItemList itemList, String userGuid) {
        ArrayList<AbstractItem> abstractItems = new ArrayList<AbstractItem>();
        ArrayList<AbstractFolder> abstractFolders = new ArrayList<AbstractFolder>();
        if (items != null && items.length > 0) {
            GWCommandManager commandManager = EngineCommandManager.getInstance(userGuid);
            for (IItem item : items) {
                if (item instanceof IFolder) {
                    abstractFolders.add(commandManager.getGWFolder((IFolder)item));
                    continue;
                }
                if (!(item instanceof IMessage)) continue;
                IMessage message = (IMessage)item;
                try {
                    abstractItems.add(commandManager.getItem(itemList, message));
                }
                catch (GWCommandException e) {
                    logger.error((Object)e);
                }
            }
        }
        return new SelectedItemsInfoImpl(itemList, abstractItems, abstractFolders);
    }

    public static boolean canShowPersonalizeTab(AbstractItem item) {
        return item != null && !item.isPersonal() && item.getNativeItem().canUpdatePersonalizeData();
    }
}

