/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.items;

import com.novell.gw.jclient.application.notify.enums.MessagePriority;
import com.novell.gw.jclient.application.notify.enums.MessageType;
import com.novell.gw.jclient.application.notify.enums.ReturnStatus;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.bl.om.NotifyTypeConverter;
import com.novell.gw.notification.NotifyItem;
import java.util.Date;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationItem
implements Comparable<NotificationItem> {
    private NotifyItem nativeItem;

    public NotificationItem(NotifyItem notifyItem) {
        if (notifyItem == null) {
            throw new NullPointerException("notifyItem is null");
        }
        this.nativeItem = notifyItem;
    }

    public String getFrom() {
        return this.nativeItem.getFrom();
    }

    public String getSubject() {
        return this.nativeItem.getSubject();
    }

    public Date getDate() {
        return this.nativeItem.getApptStartTime();
    }

    public String getLocation() {
        return this.nativeItem.getLocation();
    }

    public NotifyItem getNativeItem() {
        return this.nativeItem;
    }

    public boolean isAlarm() {
        NotifyItem.NotifyType nativeType = this.nativeItem.getNotifyType();
        switch (nativeType) {
            case NEW_ALARM: {
                return true;
            }
        }
        return false;
    }

    public boolean isReturnStatus() {
        NotifyItem.NotifyType nativeType = this.nativeItem.getNotifyType();
        switch (nativeType) {
            case APPT_STATUS: 
            case COMMON_STATUS: 
            case MAIL_STATUS: 
            case NEW_STATUS: 
            case NOTE_STATUS: 
            case TASK_STATUS: {
                return true;
            }
        }
        return false;
    }

    public MessagePriority getMessagePriority() {
        return NotifyTypeConverter.convertStatusTypeToMessagePriority(this.nativeItem.getPriority());
    }

    public ReturnStatus getReturnStatus() {
        return NotifyTypeConverter.convertStatusTypeToReturnStatus(this.nativeItem.getStatusType());
    }

    public MessageType getMessageType() {
        if (this.isReturnStatus()) {
            return NotifyTypeConverter.convertStatusNotifyTypeToMessageType(this.nativeItem.getNotifyType());
        }
        return NotifyTypeConverter.convertNewItemNotifyTypeToMessageType(this.nativeItem.getNotifyType());
    }

    public ImageIcon getBigIcon() {
        ImageIcon icon = null;
        if (!this.isAlarm()) {
            if (this.isReturnStatus()) {
                switch (this.getReturnStatus()) {
                    case ACCEPTED: {
                        return ImageResources.APPOINTMENT_ACCEPTED_BIG;
                    }
                    case COMPLETED: {
                        return ImageResources.TASK_COMPLETED_BIG;
                    }
                    case DELETED: {
                        return ImageResources.MAIL_DELETED_BIG;
                    }
                    case OPENED: {
                        return ImageResources.MAIL_OPENED_BIG;
                    }
                    case UNDELIVERABLE: {
                        return ImageResources.MAIL_UNDELIVERABLE_BIG;
                    }
                }
                throw new IllegalStateException("unexpeced return status: " + (Object)((Object)this.getReturnStatus()));
            }
            switch (this.getMessageType()) {
                case APPOINTMENT: {
                    return ImageResources.NEW_APPOINTMENT_BIG;
                }
                case MAIL_MESSEGE: {
                    return ImageResources.NEW_MAIL_BIG;
                }
                case NOTE: {
                    return ImageResources.NEW_REMINDER_BIG;
                }
                case TASK: {
                    return ImageResources.NEW_TASK_BIG;
                }
                case PHONE: {
                    return ImageResources.NEW_PHONE_MESSAGE_BIG;
                }
            }
            throw new IllegalStateException("unexpeced message type: " + (Object)((Object)this.getMessageType()));
        }
        icon = ImageResources.ICON_ALARM_BIG;
        return icon;
    }

    public ImageIcon getSmallIcon() {
        ImageIcon icon = null;
        if (!this.isAlarm()) {
            if (this.isReturnStatus()) {
                switch (this.getReturnStatus()) {
                    case ACCEPTED: {
                        return ImageResources.APPOINTMENT_ACCEPTED;
                    }
                    case COMPLETED: {
                        return ImageResources.TASK_COMPLETED;
                    }
                    case DELETED: {
                        return ImageResources.MAIL_DELETED;
                    }
                    case OPENED: {
                        return ImageResources.MAIL_OPENED;
                    }
                    case UNDELIVERABLE: {
                        return ImageResources.MAIL_UNDELIVERABLE;
                    }
                }
                throw new IllegalStateException("unexpeced return status: " + (Object)((Object)this.getReturnStatus()));
            }
            switch (this.getMessageType()) {
                case APPOINTMENT: {
                    return ImageResources.NEW_APPOINTMENT;
                }
                case MAIL_MESSEGE: {
                    return ImageResources.NEW_MAIL;
                }
                case NOTE: {
                    return ImageResources.NEW_REMINDER;
                }
                case TASK: {
                    return ImageResources.NEW_TASK;
                }
                case PHONE: {
                    return ImageResources.NEW_PHONE_MESSAGE;
                }
            }
            throw new IllegalStateException("unexpeced message type: " + (Object)((Object)this.getMessageType()));
        }
        icon = ImageResources.ALARM_SMALL;
        return icon;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.nativeItem + ":\n");
        builder.append("MsgID >" + this.nativeItem.getMsgID() + "<\n");
        builder.append("UserID >" + this.nativeItem.getUserID() + "<\n");
        builder.append("subject >" + this.nativeItem.getSubject() + "<\n");
        builder.append("from >" + this.nativeItem.getFrom() + "<\n");
        builder.append("notify type >" + this.nativeItem.getNotifyType() + "<\n");
        builder.append("status type >" + this.nativeItem.getStatusType() + "<\n");
        return builder.toString();
    }

    @Override
    public int compareTo(NotificationItem o) {
        Date date1 = this.getDate();
        Date date2 = o.getDate();
        return date2.compareTo(date1);
    }

    public boolean canReadItem() {
        return this.nativeItem.canReadItem();
    }

    public boolean canDeleteItem() {
        return this.nativeItem.canDeleteItem();
    }
}

