/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.items;

import java.security.InvalidParameterException;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class TimeInterval {
    private static Logger logger = Logger.getLogger(TimeInterval.class);
    private long startDate;
    private long endDate;

    public TimeInterval() {
        this(System.currentTimeMillis());
    }

    public TimeInterval(Date theEndDate) {
        this(theEndDate.getTime());
    }

    public TimeInterval(Date theStartDate, Date theEndDate) {
        this(theStartDate.getTime(), theEndDate.getTime());
    }

    public TimeInterval(long theEndDate) {
        this(new Date().getTime(), theEndDate);
    }

    public TimeInterval(long theStartDate, long theEndDate) {
        this.startDate = theStartDate;
        this.endDate = theEndDate;
    }

    public long getStartDate() {
        return this.startDate;
    }

    public void setStartDate(long theStartDate) {
        this.startDate = theStartDate;
    }

    public long getEndDate() {
        return this.endDate;
    }

    public void setEndDate(long theEndDate) {
        this.endDate = theEndDate;
    }

    public Date getStartDateAsDate() {
        return new Date(this.startDate);
    }

    public void setStartDateAsDate(Date theStartDate) {
        this.startDate = theStartDate.getTime();
    }

    public Date getEndDateAsDate() {
        return new Date(this.endDate);
    }

    public void setEndDateAsDate(Date theEndDate) {
        this.endDate = theEndDate.getTime();
    }

    public boolean contains(Date theDate) {
        return this.startDate <= theDate.getTime() && this.endDate > theDate.getTime();
    }

    public boolean contains(Calendar day) {
        return this.contains(day.getTime());
    }

    public boolean contains(TimeInterval theTimeInterval) {
        if (theTimeInterval == null) {
            return false;
        }
        TimeInterval.checkInterval(theTimeInterval);
        return this.startDate <= theTimeInterval.startDate && this.endDate >= theTimeInterval.endDate;
    }

    public boolean hasIntersectionWith(TimeInterval theTimeInterval) {
        if (theTimeInterval == null) {
            return false;
        }
        TimeInterval.checkInterval(theTimeInterval);
        boolean startInInterval = theTimeInterval.startDate - this.startDate > 0L && theTimeInterval.startDate - this.endDate < 0L;
        boolean endInInterval = theTimeInterval.endDate - this.startDate > 0L && theTimeInterval.endDate - this.endDate < 0L;
        return startInInterval || endInInterval || theTimeInterval.contains(this);
    }

    private static void checkInterval(TimeInterval theInterval) {
        if (theInterval.startDate > theInterval.endDate) {
            throw new InvalidParameterException("Invalid time interval received. End date should be larger or equal than start date.Interval: [" + theInterval + ']');
        }
    }

    public int getDurationInMinutes() {
        return (int)((this.endDate - this.startDate) / 60000L);
    }

    public int getDuration() {
        return (int)(this.endDate - this.startDate);
    }

    public String toString() {
        return "Start Time: " + this.getStartDateAsDate() + " End Time: " + this.getEndDateAsDate() + " Duration in minutes: " + this.getDurationInMinutes();
    }
}

