/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.options;

import com.novell.gw.jclient.application.resources.StringResources;
import java.util.Calendar;
import java.util.TimeZone;

public class GWTimeZone {
    private TimeZone timeZone;
    private String fullName;

    public GWTimeZone(TimeZone theTimeZone) {
        this.timeZone = theTimeZone;
    }

    public String toString() {
        if (this.fullName == null) {
            this.fullName = GWTimeZone.createGwTimeZoneName(this.timeZone);
        }
        return this.fullName;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone theTimeZone) {
        this.timeZone = theTimeZone;
        this.fullName = null;
    }

    public static String createGwTimeZoneName(TimeZone timeZone) {
        String strMins;
        Calendar gc = Calendar.getInstance(timeZone);
        int offset = gc.get(15) / 60000;
        int hours = offset / 60;
        int mins = offset % 60;
        String sign = hours >= 0 ? "+" : "-";
        String string = strMins = Math.abs(mins) < 10 ? '0' + Integer.toString(Math.abs(mins)) : Integer.toString(Math.abs(mins));
        String strHours = hours >= 0 ? (hours < 10 ? "0" + Integer.toString(hours) : Integer.toString(hours)) : (-hours < 10 ? "0" + Integer.toString(-hours) : Integer.toString(-hours));
        return StringResources.formatString(StringResources.GW_TIME_ZONE_NAME, sign, strHours, strMins, gc.getTimeZone().getID());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GWTimeZone that = (GWTimeZone)o;
        return this.timeZone.equals(that.timeZone);
    }
}

