/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.options;

import com.appframework.CustomizableToolBarComponent;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.toolbars.ApplicationFrameToolBar;
import com.novell.gw.jclient.bl.om.options.ActionInfo;
import com.novell.gw.jclient.bl.om.options.ComponentInfo;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JSeparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolBarOptions {
    private Layout layout;
    private Style style;
    private String name;
    private boolean changed = true;
    private List<ComponentInfo> componentInfos = new ArrayList<ComponentInfo>();

    public static ToolBarOptions getInstance(ApplicationFrameToolBar toolBar) {
        ToolBarOptions toolBarOptions = new ToolBarOptions();
        String name = toolBar.getName();
        toolBarOptions.setName(name);
        ArrayList<ComponentInfo> infoList = new ArrayList<ComponentInfo>();
        for (Component component : toolBar.getComponents()) {
            if (component instanceof JSeparator) {
                infoList.add(ComponentInfo.SEPARATOR_INFO);
                continue;
            }
            if (!(component instanceof CustomizableToolBarComponent)) continue;
            CustomizableToolBarComponent button = (CustomizableToolBarComponent)((Object)component);
            ActionKey actionKey = button.getDefaultActionName();
            ActionInfo actionInfo = new ActionInfo(actionKey);
            actionInfo.setShowWithText(button.showTextLabel());
            infoList.add(actionInfo);
        }
        toolBarOptions.setComponentInfos(infoList);
        return toolBarOptions;
    }

    protected ToolBarOptions clone() throws CloneNotSupportedException {
        ToolBarOptions options = (ToolBarOptions)super.clone();
        options.setLayout(this.getLayout());
        options.setStyle(this.getStyle());
        options.setName(this.getName());
        options.setComponentInfos(this.getComponentInfos());
        return options;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setComponentInfos(List<ComponentInfo> componentInfos) {
        this.componentInfos = componentInfos;
    }

    public ComponentInfo getComponentInfo(int index) {
        return this.componentInfos.get(index);
    }

    public boolean addComponentInfo(ComponentInfo componentInfo) {
        return this.componentInfos.add(componentInfo);
    }

    public List<ComponentInfo> getComponentInfos() {
        return this.componentInfos;
    }

    public int indexOf(ActionKey actionKey) {
        for (int i = 0; i < this.componentInfos.size(); ++i) {
            ComponentInfo componentInfo = this.componentInfos.get(i);
            if (!componentInfo.getComponentSource().equals((Object)actionKey)) continue;
            return i;
        }
        return -1;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        DEFAULT,
        ADDED,
        REMOVED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        PICTURE,
        PICTURE_AND_TEXT,
        PICTURE_AND_SELECTED_TEXT,
        PREVIEW;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Layout {
        SINGLE_ROW_OF_BUTTONS_ONLY,
        MULTIPLE_ROW_OF_BUTTONS;

    }
}

