/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.options.properties;

import com.novell.gw.jclient.application.printing.preview.PrintUtils;
import com.novell.gw.jclient.bl.om.options.Options;
import com.novell.gw.jclient.bl.om.options.PrintingOptions;
import com.novell.gw.jclient.bl.om.options.properties.OptionsProperties;
import com.novell.gw.jclient.bl.om.options.properties.SortedProperties;
import java.awt.Font;
import java.util.Properties;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintingOptionsProperties
extends OptionsProperties<PrintingOptions> {
    private static Logger logger = Logger.getLogger(PrintingOptionsProperties.class);
    private static final String PREFIX = "printing.";
    private final String HEADER = "printing.header";
    private final String SUBHEADER = "printing.subheader";
    private final String PLAIN_TEXT = "printing.plain_text";
    private final String DAY_ON_NEW_PAGE = "printing.day_on_new_page";
    private final String DAYS_NUMBER = "printing.days_number";
    private final String ROWS_NUMBER = "printing.rows_number";
    private final String COLS_NUMBER = "printing.cols_number";
    private final String PAGE_FORMAT = "printing.page_format.";
    private final String PRINT_PAGE_NUMBER = "printing.print_page_number";
    private final String ALL_DAY_EVENT = "printing.all_day_event.printed";
    private final String APPOINTMENT = "printing.appointment.printed";
    private final String TASK = "printing.task.printed";
    private final String NOTE = "printing.note.printed";
    private final String MESSAGE_PRINTED = "printing.message.printed.";
    private final String ADDRESS_BOOK = "printing.address_book.printed.";
    private final String WEEKEND_DAYS_PRINTED = "printing.weekend_days.printed";
    private final String PRIVATE_CALENDAR_ITEMS_PRINTED = "printing.private_calendar_items.printed";
    private final String COMPLETED_TASKS_PRINTED = "printing.completed_tasks.printed";
    private static final String FONT = "font";
    private static final String NAME = "name";
    private static final String SIZE = "size";
    private static final String BOLD = "bold";
    private static final String ITALIC = "italic";
    private static final String FROM = "from";
    private static final String START = "start";
    private static final String END = "end";
    private static final String DUE = "due";
    private static final String USER_NAME = "user_name";
    private static final String ITEM_TYPE = "item_type";
    private static final String TO = "to";
    private static final String SUBJECT = "suject";
    private static final String COMPLETION_DATE = "completion_date";
    private static final String MESSAGE = "message";
    private static final String PLACE = "place";
    private static final String PRIORITY = "priority";
    private static final String EMAIL = "email";
    private static final String DEPARTMENT = "department";
    private static final String PHONE_NUMBER = "phone_number";
    private static final String FAX_NUMBER = "fax_number";
    private static final String USER_ID = "user_id";
    private static final String LAST_NAME = "last_name";
    private static final String FIRST_NAME = "first_name";
    private static final String TITLE = "title";
    private static final String STATE = "state";
    private static final String EMAIL_DISPLAY = "email_display";
    private static final String CELL_PHONE_NUMBER = "cell_phone_number";
    private static final String DISPLAY_NAME = "display_name";
    private static final String ZIP = "zip";
    private static final String COUNTRY = "country";
    private static final String PAGER_NUMBER = "pager_number";
    private static final String OWNER = "owner";
    private static final String CITY = "city";
    private static final String HOME_PHONE_NUMBER = "home_phone_number";
    private static final String ADDRESS = "address";
    private static final String GREETING = "greeting";
    private static final String COMMENTS = "comments";
    private static final String MAILSTOP = "mailstop";
    private static final String ORGANIZATION = "organization";
    private static final String SCREEN_NAME = "screen_name";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String IMAGE_X = "image_x";
    private static final String IMAGE_Y = "image_y";
    private static final String IMAGE_WIDTH = "image_width";
    private static final String IMAGE_HEIGHT = "image_height";
    private static final String ORIENTATION = "orientation";
    private static final String CALENDAR = "calendar";
    private static final String CONTENT = "content";
    private static final String CALENDAR_HEADER = "calendar_header";
    private static final String FOOTER = "footer";
    private static final String PAGE_NUMBER = "page_number";
    private static final String DATE_AND_TIME = "date_and_time";
    private static final String PRINT_SELECTED_FOLDER = "print_selected_folder";
    private static final String EXTRA_TEXT_PRINTED_ON_NEXT_PAGE = "extra_text_printed_on_next_page";
    private static final String DUPLEX = "duplex";
    private static final String PRINT_TO_TEXT_FILE = "print_to_text_file";
    private static final String SHADING_USED = "shading_used";
    private static final String SEPARATOR_LINE_PRINTED = "separator_line_printed";
    private static final String CENTERED_ON_PAGE = "centered_on_page";
    private static final String BLANK_PAGE_INSERTED = "blank_page_inserted";
    private static final String CATEGORY_COLOR_USED = "category_color_used";

    @Override
    public Options readOptions(Properties theProperties) {
        PrintingOptions po = new PrintingOptions();
        Font fontDefault = PrintingOptions.getDefaultFont();
        Font font = this.readFont(theProperties, "printing.header");
        if (font == null) {
            po.setFntHeader(fontDefault);
        } else {
            po.setFntHeader(font);
        }
        font = this.readFont(theProperties, "printing.subheader");
        if (font == null) {
            po.setFntSubHeader(fontDefault);
        } else {
            po.setFntSubHeader(font);
        }
        font = this.readFont(theProperties, "printing.plain_text");
        if (font == null) {
            po.setFntPlainTxt(fontDefault);
        } else {
            po.setFntPlainTxt(font);
        }
        font = this.readFont(theProperties, "printing.calendar.content");
        if (font == null) {
            po.setCalendarContentFont(fontDefault);
        } else {
            po.setCalendarContentFont(font);
        }
        String value = theProperties.getProperty("printing.print_page_number");
        if (value != null) {
            try {
                po.setPageNumberPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.days_number")) != null) {
            try {
                po.setNumberOfDays(Integer.parseInt(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.day_on_new_page")) != null) {
            try {
                po.setDayOnNewPage(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.rows_number")) != null) {
            try {
                po.setRowsNumber(Integer.parseInt(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.cols_number")) != null) {
            try {
                po.setColsNumber(Integer.parseInt(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.calendar_header")) != null) {
            try {
                po.setCalendarHeader(value);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.calendar.footer.name")) != null) {
            try {
                po.setCalendarFooterNamePrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.calendar.footer.date_and_time")) != null) {
            try {
                po.setCalendarFooterDateAndTimePrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.calendar.footer.page_number")) != null) {
            try {
                po.setCalendarFooterPageNumberPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.calendar.print_selected_folder")) != null) {
            try {
                po.setSelectedFolderPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.calendar.extra_text_printed_on_next_page")) != null) {
            try {
                po.setExtraTextPrintedOnNextPage(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.calendar.duplex")) != null) {
            try {
                po.setDuplex(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.calendar.print_to_text_file")) != null) {
            try {
                po.setPrintToTextFile(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.calendar.shading_used")) != null) {
            try {
                po.setShadingUsed(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.calendar.separator_line_printed")) != null) {
            try {
                po.setSeparatorLinePrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.calendar.centered_on_page")) != null) {
            try {
                po.setCenteredOnPage(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.calendar.blank_page_inserted")) != null) {
            try {
                po.setBlankPageInserted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.calendar.category_color_used")) != null) {
            try {
                po.setCategoryColorUsed(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.message.printed.user_name")) != null) {
            try {
                po.setUserNamePrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.message.printed.item_type")) != null) {
            try {
                po.setItemTypePrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.message.printed.from")) != null) {
            try {
                po.setFromPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.message.printed.to")) != null) {
            try {
                po.setToPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.message.printed.suject")) != null) {
            try {
                po.setSubjectPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.appointment.printed")) != null) {
            try {
                po.setAppointmentPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.appointment.printed.from")) != null) {
            try {
                po.setAppointmentFromPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.appointment.printed.start")) != null) {
            try {
                po.setAppointmentStartPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.appointment.printed.end")) != null) {
            try {
                po.setAppointmentEndPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.appointment.printed.place")) != null) {
            try {
                po.setAppointmentPlacePrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.appointment.printed.message")) != null) {
            try {
                po.setAppointmentMessagePrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.all_day_event.printed")) != null) {
            try {
                po.setAllDayEventPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.all_day_event.printed.from")) != null) {
            try {
                po.setAllDayEventFromPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.all_day_event.printed.start")) != null) {
            try {
                po.setAllDayEventStartPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.all_day_event.printed.end")) != null) {
            try {
                po.setAllDayEventEndPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.task.printed")) != null) {
            try {
                po.setTaskPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.task.printed.from")) != null) {
            try {
                po.setTaskFromPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.task.printed.start")) != null) {
            try {
                po.setTaskStartPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.task.printed.priority")) != null) {
            try {
                po.setTaskPriorityPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.task.printed.due")) != null) {
            try {
                po.setTaskDuePrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.task.printed.completion_date")) != null) {
            try {
                po.setTaskCompletionDatePrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.task.printed.message")) != null) {
            try {
                po.setTaskMessagePrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.note.printed")) != null) {
            try {
                po.setNotePrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.note.printed.from")) != null) {
            try {
                po.setNoteFromPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.note.printed.start")) != null) {
            try {
                po.setNoteStartPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.note.printed.message")) != null) {
            try {
                po.setNoteMessagePrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.address_book.printed.name")) != null) {
            try {
                po.setNamePrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.address_book.printed.email")) != null) {
            try {
                po.setE_MailPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.address_book.printed.department")) != null) {
            try {
                po.setDepartmentPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.address_book.printed.phone_number")) != null) {
            try {
                po.setPhoneNumberPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.address_book.printed.fax_number")) != null) {
            try {
                po.setFaxNumberPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.address_book.printed.user_id")) != null) {
            try {
                po.setUserIdPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.address_book.printed.last_name")) != null) {
            try {
                po.setLastNamePrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.address_book.printed.first_name")) != null) {
            try {
                po.setFirstNamePrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.address_book.printed.title")) != null) {
            try {
                po.setTitlePrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.address_book.printed.state")) != null) {
            try {
                po.setStatePrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.address_book.printed.email_display")) != null) {
            try {
                po.setEMailDisplayPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.address_book.printed.cell_phone_number")) != null) {
            try {
                po.setCellPhoneNumberPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.address_book.printed.display_name")) != null) {
            try {
                po.setDisplayNamePrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.address_book.printed.zip")) != null) {
            try {
                po.setZIPPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.address_book.printed.country")) != null) {
            try {
                po.setCountryPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.address_book.printed.pager_number")) != null) {
            try {
                po.setPagerNumberPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.address_book.printed.owner")) != null) {
            try {
                po.setOwnerPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.address_book.printed.city")) != null) {
            try {
                po.setCityPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.address_book.printed.home_phone_number")) != null) {
            try {
                po.setHomePhoneNumberPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.address_book.printed.address")) != null) {
            try {
                po.setAddressPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.address_book.printed.greeting")) != null) {
            try {
                po.setGreetingPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.address_book.printed.comments")) != null) {
            try {
                po.setCommentsPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.address_book.printed.mailstop")) != null) {
            try {
                po.setMailStopPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.address_book.printed.organization")) != null) {
            try {
                po.setOrganizationPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.address_book.printed.screen_name")) != null) {
            try {
                po.setScreenNamePrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.weekend_days.printed")) != null) {
            try {
                po.setWeekendDaysPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.private_calendar_items.printed")) != null) {
            try {
                po.setPrivateCalendarItemsPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.completed_tasks.printed")) != null) {
            try {
                po.setCompletedTasksPrinted(PrintingOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        po.setPrintAttributeSet(PrintUtils.getAttributeFromArray(this.readPageFormat(theProperties)));
        return po;
    }

    @Override
    public Properties createProperties(PrintingOptions options) {
        PrintingOptions po = options;
        PrintingProperties properties = new PrintingProperties();
        properties.put("printing.header", po.getFntHeader());
        properties.put("printing.subheader", po.getFntSubHeader());
        properties.put("printing.plain_text", po.getFntPlainTxt());
        properties.put("printing.calendar.content", po.getCalendarContentFont());
        properties.put((Object)"printing.calendar_header", po.getCalendarHeader());
        properties.put((Object)"printing.calendar.footer.name", po.isCalendarFooterNamePrinted());
        properties.put((Object)"printing.calendar.footer.date_and_time", po.isCalendarFooterDateAndTimePrinted());
        properties.put((Object)"printing.calendar.footer.page_number", po.isCalendarFooterPageNumberPrinted());
        properties.put((Object)"printing.calendar.print_selected_folder", po.isSelectedFolderPrinted());
        properties.put((Object)"printing.calendar.extra_text_printed_on_next_page", po.isExtraTextPrintedOnNextPage());
        properties.put((Object)"printing.calendar.duplex", po.isDuplex());
        properties.put((Object)"printing.calendar.print_to_text_file", po.isPrintToTextFile());
        properties.put((Object)"printing.calendar.shading_used", po.isShadingUsed());
        properties.put((Object)"printing.calendar.separator_line_printed", po.isSeparatorLinePrinted());
        properties.put((Object)"printing.calendar.centered_on_page", po.isCenteredOnPage());
        properties.put((Object)"printing.calendar.blank_page_inserted", po.isBlankPageInserted());
        properties.put((Object)"printing.calendar.category_color_used", po.isCategoryColorUsed());
        properties.put((Object)"printing.print_page_number", po.isPageNumberPrinted());
        properties.put((Object)"printing.days_number", po.getNumberOfDays());
        properties.put((Object)"printing.day_on_new_page", po.isDayOnNewPage());
        properties.put((Object)"printing.rows_number", po.getRowsNumber());
        properties.put((Object)"printing.cols_number", po.getColsNumber());
        properties.put((Object)"printing.weekend_days.printed", po.isWeekendDaysPrinted());
        properties.put((Object)"printing.private_calendar_items.printed", po.isPrivateCalendarItemsPrinted());
        properties.put((Object)"printing.completed_tasks.printed", po.isCompletedTasksPrinted());
        properties.put((Object)"printing.message.printed.user_name", po.isUserNamePrinted());
        properties.put((Object)"printing.message.printed.item_type", po.isItemTypePrinted());
        properties.put((Object)"printing.message.printed.from", po.isFromPrinted());
        properties.put((Object)"printing.message.printed.to", po.isToPrinted());
        properties.put((Object)"printing.message.printed.suject", po.isSubjectPrinted());
        properties.put((Object)"printing.all_day_event.printed", po.isAllDayEventPrinted());
        properties.put((Object)"printing.all_day_event.printed.from", po.isAllDayEventFromPrinted());
        properties.put((Object)"printing.all_day_event.printed.start", po.isAllDayEventStartPrinted());
        properties.put((Object)"printing.all_day_event.printed.end", po.isAllDayEventEndPrinted());
        properties.put((Object)"printing.appointment.printed", po.isAppointmentPrinted());
        properties.put((Object)"printing.appointment.printed.from", po.isAppointmentFromPrinted());
        properties.put((Object)"printing.appointment.printed.start", po.isAppointmentStartPrinted());
        properties.put((Object)"printing.appointment.printed.end", po.isAppointmentEndPrinted());
        properties.put((Object)"printing.appointment.printed.place", po.isAppointmentPlacePrinted());
        properties.put((Object)"printing.appointment.printed.message", po.isAppointmentMessagePrinted());
        properties.put((Object)"printing.task.printed", po.isTaskPrinted());
        properties.put((Object)"printing.task.printed.from", po.isTaskFromPrinted());
        properties.put((Object)"printing.task.printed.start", po.isTaskStartPrinted());
        properties.put((Object)"printing.task.printed.due", po.isTaskDuePrinted());
        properties.put((Object)"printing.task.printed.completion_date", po.isTaskCompletionDatePrinted());
        properties.put((Object)"printing.task.printed.priority", po.isTaskPriorityPrinted());
        properties.put((Object)"printing.task.printed.message", po.isTaskMessagePrinted());
        properties.put((Object)"printing.note.printed", po.isNotePrinted());
        properties.put((Object)"printing.note.printed.from", po.isNoteFromPrinted());
        properties.put((Object)"printing.note.printed.start", po.isNoteStartPrinted());
        properties.put((Object)"printing.note.printed.message", po.isNoteMessagePrinted());
        properties.put((Object)"printing.address_book.printed.name", po.isNamePrinted());
        properties.put((Object)"printing.address_book.printed.email", po.isE_MailPrinted());
        properties.put((Object)"printing.address_book.printed.department", po.isDepartmentPrinted());
        properties.put((Object)"printing.address_book.printed.phone_number", po.isPhoneNumberPrinted());
        properties.put((Object)"printing.address_book.printed.fax_number", po.isFaxNumberPrinted());
        properties.put((Object)"printing.address_book.printed.user_id", po.isUserIdPrinted());
        properties.put((Object)"printing.address_book.printed.last_name", po.isLastNamePrinted());
        properties.put((Object)"printing.address_book.printed.first_name", po.isFirstNamePrinted());
        properties.put((Object)"printing.address_book.printed.title", po.isTitlePrinted());
        properties.put((Object)"printing.address_book.printed.state", po.isStatePrinted());
        properties.put((Object)"printing.address_book.printed.email_display", po.isEMailDisplayPrinted());
        properties.put((Object)"printing.address_book.printed.cell_phone_number", po.isCellPhoneNumberPrinted());
        properties.put((Object)"printing.address_book.printed.display_name", po.isDisplayNamePrinted());
        properties.put((Object)"printing.address_book.printed.zip", po.isZIPPrinted());
        properties.put((Object)"printing.address_book.printed.country", po.isCountryPrinted());
        properties.put((Object)"printing.address_book.printed.pager_number", po.isPagerNumberPrinted());
        properties.put((Object)"printing.address_book.printed.owner", po.isOwnerPrinted());
        properties.put((Object)"printing.address_book.printed.city", po.isCityPrinted());
        properties.put((Object)"printing.address_book.printed.home_phone_number", po.isHomePhoneNumberPrinted());
        properties.put((Object)"printing.address_book.printed.address", po.isAddressPrinted());
        properties.put((Object)"printing.address_book.printed.greeting", po.isGreetingPrinted());
        properties.put((Object)"printing.address_book.printed.comments", po.isCommentsPrinted());
        properties.put((Object)"printing.address_book.printed.mailstop", po.isMailStopPrinted());
        properties.put((Object)"printing.address_book.printed.organization", po.isOrganizationPrinted());
        properties.put((Object)"printing.address_book.printed.screen_name", po.isScreenNamePrinted());
        float[] prAttr = PrintUtils.getValuesFromPrintAttributes(po.getPrintAttributeSet());
        properties.put((Object)"printing.page_format.width", prAttr[0]);
        properties.put((Object)"printing.page_format.height", prAttr[1]);
        properties.put((Object)"printing.page_format.image_x", prAttr[2]);
        properties.put((Object)"printing.page_format.image_y", prAttr[3]);
        properties.put((Object)"printing.page_format.image_width", prAttr[4]);
        properties.put((Object)"printing.page_format.image_height", prAttr[5]);
        properties.put((Object)"printing.page_format.orientation", (int)prAttr[6]);
        return properties;
    }

    private Font readFont(Properties theProperties, String propertyName) {
        String property;
        String name = theProperties.getProperty(propertyName + '.' + FONT + '.' + NAME);
        if (name == null || !(name instanceof String) || name.length() == 0) {
            return null;
        }
        int size = 12;
        boolean bold = false;
        boolean italic = false;
        try {
            property = theProperties.getProperty(propertyName + '.' + FONT + '.' + SIZE);
            if (property != null) {
                size = Integer.parseInt(property);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        try {
            property = theProperties.getProperty(propertyName + '.' + FONT + '.' + BOLD);
            if (property != null) {
                bold = PrintingOptionsProperties.readBoolean(property);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        try {
            property = theProperties.getProperty(propertyName + '.' + FONT + '.' + ITALIC);
            if (property != null) {
                italic = PrintingOptionsProperties.readBoolean(property);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        int modifiers = bold ? (italic ? 3 : 1) : (italic ? 2 : 0);
        Font font = new Font(name, modifiers, size);
        return font;
    }

    private float[] readPageFormat(Properties theProperties) {
        float[] attr = new float[]{215.9f, 279.4f, 25.4f, 25.4f, 165.1f, 228.6f, 3.0f};
        String value = theProperties.getProperty("printing.page_format.width");
        if (value != null) {
            try {
                attr[0] = Float.parseFloat(value);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.page_format.height")) != null) {
            try {
                attr[1] = Float.parseFloat(value);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.page_format.image_x")) != null) {
            try {
                attr[2] = Float.parseFloat(value);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.page_format.image_y")) != null) {
            try {
                attr[3] = Float.parseFloat(value);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.page_format.image_width")) != null) {
            try {
                attr[4] = Float.parseFloat(value);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.page_format.image_height")) != null) {
            try {
                attr[5] = Float.parseFloat(value);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty("printing.page_format.orientation")) != null) {
            try {
                attr[6] = Float.parseFloat(value);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return attr;
    }

    protected class PrintingProperties
    extends SortedProperties {
        protected PrintingProperties() {
        }

        public void put(String keyPrefix, Font font) {
            if (font != null) {
                this.put((Object)(keyPrefix + '.' + PrintingOptionsProperties.FONT + '.' + PrintingOptionsProperties.NAME), font.getName());
                this.put((Object)(keyPrefix + '.' + PrintingOptionsProperties.FONT + '.' + PrintingOptionsProperties.SIZE), font.getSize());
                this.put((Object)(keyPrefix + '.' + PrintingOptionsProperties.FONT + '.' + PrintingOptionsProperties.BOLD), font.isBold());
                this.put((Object)(keyPrefix + '.' + PrintingOptionsProperties.FONT + '.' + PrintingOptionsProperties.ITALIC), font.isItalic());
            }
        }
    }
}

