/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.options.properties;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedProperties
extends Properties {
    private static Logger logger = Logger.getLogger(SortedProperties.class);
    public static final String LIST_ELEMENT_SEPARATOR = "|";
    private static final String specialSaveChars = "=: \t\r\n\f#!";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    @Override
    public synchronized Object put(Object key, Object value) {
        if (!(key instanceof String)) {
            logger.warn((Object)("key is not a String: " + key + ", class: " + (key == null ? "null" : key.getClass().getName())));
        }
        if (!(value instanceof String)) {
            logger.warn((Object)("value for key '" + key + "' is not a String: " + value + ", class: " + (value == null ? "null" : value.getClass().getName())));
        }
        if (value != null) {
            return super.put(key, value);
        }
        return null;
    }

    @Override
    public void put(Object key, Integer value) {
        this.put(key, value == null ? null : String.valueOf(value));
    }

    @Override
    public void put(Object key, int value) {
        this.put(key, String.valueOf(value));
    }

    @Override
    public void put(Object key, long value) {
        this.put(key, String.valueOf(value));
    }

    @Override
    public void put(Object key, Long value) {
        this.put(key, value == null ? null : String.valueOf(value));
    }

    @Override
    public void put(Object key, float value) {
        this.put(key, String.valueOf(value));
    }

    @Override
    public void put(Object key, Float value) {
        this.put(key, value == null ? null : String.valueOf(value));
    }

    @Override
    public void put(Object key, boolean value) {
        this.put(key, String.valueOf(value));
    }

    @Override
    public void put(Object key, Boolean value) {
        this.put(key, value == null ? null : String.valueOf(value));
    }

    @Override
    public void put(Object key, double value) {
        this.put(key, String.valueOf(value));
    }

    @Override
    public void put(Object key, Double value) {
        this.put(key, value == null ? null : String.valueOf(value));
    }

    @Override
    public void put(Object key, List<String> value) {
        StringBuilder buffer = new StringBuilder(value.size() * 50);
        int nSize = value.size();
        for (int i = 0; i < nSize; ++i) {
            buffer.append(value.get(i));
            if (i >= value.size() - 1) continue;
            buffer.append(LIST_ELEMENT_SEPARATOR);
        }
        this.put(key, buffer.toString());
    }

    public static List<String> toList(String value) {
        int separatorIndex;
        ArrayList<String> stringList = new ArrayList<String>();
        while ((separatorIndex = value.indexOf(LIST_ELEMENT_SEPARATOR)) > -1) {
            String element = value.substring(0, separatorIndex);
            stringList.add(element);
            value = value.substring(separatorIndex + LIST_ELEMENT_SEPARATOR.length());
        }
        if (value.length() > 0) {
            stringList.add(value);
        }
        return stringList;
    }

    @Override
    public synchronized void store(OutputStream out, String header) throws IOException {
        BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter(out, "8859_1"));
        if (header != null) {
            SortedProperties.writeln(awriter, '#' + header);
        }
        SortedProperties.writeln(awriter, '#' + new Date().toString());
        Object[] keys = this.keySet().toArray();
        try {
            Arrays.sort(keys);
            int nCount = keys.length;
            for (int i = 0; i < nCount; ++i) {
                String key = (String)keys[i];
                String val = (String)this.get(key);
                key = SortedProperties.saveConvert(key, true);
                val = SortedProperties.saveConvert(val, false);
                SortedProperties.writeln(awriter, key + '=' + val);
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            Enumeration<Object> en = this.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                String val = this.get(key).toString();
                key = SortedProperties.saveConvert(key, true);
                val = SortedProperties.saveConvert(val, false);
                SortedProperties.writeln(awriter, key + '=' + val);
            }
        }
        awriter.flush();
    }

    private static void writeln(BufferedWriter bw, String s) throws IOException {
        bw.write(s);
        bw.newLine();
    }

    private static String saveConvert(String theString, boolean escapeSpace) {
        int len = theString.length();
        StringBuilder outBuffer = new StringBuilder(len * 2);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(SortedProperties.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(SortedProperties.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(SortedProperties.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(SortedProperties.toHex(aChar & 0xF));
                        continue block8;
                    }
                    if (specialSaveChars.indexOf(aChar) != -1) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }
}

