/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.options.properties;

import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.bl.om.options.ActionInfo;
import com.novell.gw.jclient.bl.om.options.ComponentInfo;
import com.novell.gw.jclient.bl.om.options.Options;
import com.novell.gw.jclient.bl.om.options.ToolBarOptions;
import com.novell.gw.jclient.bl.om.options.ToolBarsOptions;
import com.novell.gw.jclient.bl.om.options.properties.OptionsProperties;
import com.novell.gw.jclient.bl.om.options.properties.SortedProperties;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolBarProperties
extends OptionsProperties<ToolBarsOptions> {
    private static final Logger logger = Logger.getLogger(ToolBarProperties.class);
    private static final String POSITION = "POSITION";
    private static final String LAYOUT = "LAYOUT";
    private static final String STYLE = "STYLE";
    private static final String COMPONENT_STATE = "COMPONENT_STATE";
    private static final String SHOW_WITH_TEXT = "SHOW_WITH_TEXT";
    private static final String COMPONENT = "COMPONENT";

    @Override
    public Options readOptions(Properties properties) {
        ToolBarsOptions toolBarsOptions = new ToolBarsOptions();
        HashMap componentInfos = new HashMap();
        HashMap componentPositions = new HashMap();
        for (Object o : properties.keySet()) {
            String propertyKey = (String)o;
            int index = propertyKey.indexOf(".");
            if (index == -1) continue;
            String toolBarName = propertyKey.substring(0, index);
            String realToolBarName = toolBarName.replace("_", " ");
            ToolBarOptions toolBarOptions = toolBarsOptions.getToolBarOptions(realToolBarName);
            if (toolBarOptions == null) {
                toolBarOptions = new ToolBarOptions();
                toolBarOptions.setName(toolBarName);
                toolBarsOptions.putToolBarOptions(realToolBarName, toolBarOptions);
                componentInfos.put(toolBarOptions, new HashMap());
                componentPositions.put(toolBarOptions, new HashMap());
            }
            String componentPrefix = toolBarName + "." + COMPONENT + ".";
            String layoutPrefix = toolBarName + "." + LAYOUT;
            String stylePrefix = toolBarName + "." + STYLE;
            if (propertyKey.contains(componentPrefix)) {
                ComponentInfo componentInfo;
                String component = propertyKey.substring(componentPrefix.length(), propertyKey.length());
                component = component.substring(0, component.indexOf("."));
                logger.debug((Object)("component: " + component));
                logger.debug((Object)("propertyKey: " + propertyKey));
                Map infoMap = (Map)componentInfos.get(toolBarOptions);
                Map positionMap = (Map)componentPositions.get(toolBarOptions);
                if (infoMap.containsKey(component)) {
                    componentInfo = (ComponentInfo)infoMap.get(component);
                } else {
                    componentInfo = component.equals("SEPARATOR") ? ComponentInfo.getInstance("SEPARATOR") : ComponentInfo.getInstance((Object)ActionKey.valueOf(component));
                    infoMap.put(component, componentInfo);
                }
                String positionPrefix = component + "." + POSITION;
                String showWithTextPrefix = component + "." + SHOW_WITH_TEXT;
                String statePrefix = component + "." + COMPONENT_STATE;
                if (propertyKey.contains(positionPrefix)) {
                    Integer position = Integer.valueOf(properties.getProperty(propertyKey));
                    logger.debug((Object)("position: " + position));
                    positionMap.put(position, componentInfo);
                    continue;
                }
                if (propertyKey.contains(statePrefix)) {
                    ToolBarOptions.State state = ToolBarOptions.State.valueOf(properties.getProperty(propertyKey));
                    logger.debug((Object)("state: " + (Object)((Object)state)));
                    componentInfo.setState(state);
                    continue;
                }
                if (!(componentInfo instanceof ActionInfo) || !propertyKey.contains(showWithTextPrefix)) continue;
                boolean showWithText = Boolean.valueOf(properties.getProperty(propertyKey));
                logger.debug((Object)("showWithText: " + showWithText));
                ((ActionInfo)componentInfo).setShowWithText(showWithText);
                continue;
            }
            if (propertyKey.contains(layoutPrefix)) {
                ToolBarOptions.Layout layout = ToolBarOptions.Layout.valueOf(properties.getProperty(propertyKey));
                logger.debug((Object)("layout: " + (Object)((Object)layout)));
                toolBarOptions.setLayout(layout);
                continue;
            }
            if (!propertyKey.contains(stylePrefix)) continue;
            ToolBarOptions.Style style = ToolBarOptions.Style.valueOf(properties.getProperty(propertyKey));
            logger.debug((Object)("style: " + (Object)((Object)style)));
            toolBarOptions.setStyle(style);
        }
        for (ToolBarOptions toolBarOptions : componentInfos.keySet()) {
            Map positionMap = (Map)componentPositions.get(toolBarOptions);
            Set integers = positionMap.keySet();
            int maxPosition = 0;
            for (Integer i : integers) {
                if (i <= maxPosition) continue;
                maxPosition = i;
            }
            ComponentInfo[] infos = new ComponentInfo[maxPosition + 1];
            Set set = positionMap.keySet();
            for (int i = 0; i <= maxPosition; ++i) {
                infos[i] = set.contains(i) ? (ComponentInfo)positionMap.get(i) : ComponentInfo.SEPARATOR_INFO;
            }
            List<ComponentInfo> infoList = Arrays.asList(infos);
            if (infoList.contains(null)) {
                throw new NullPointerException();
            }
            toolBarOptions.setComponentInfos(infoList);
        }
        return toolBarsOptions;
    }

    @Override
    public Properties createProperties(ToolBarsOptions options) {
        SortedProperties properties = new SortedProperties();
        for (ToolBarOptions toolBarOptions : options.values()) {
            if (toolBarOptions == null || !toolBarOptions.isChanged()) continue;
            String name = toolBarOptions.getName();
            name = name.replace(" ", "_");
            String prefix = name + ".";
            StringBuilder builder = new StringBuilder();
            builder.append(prefix);
            builder.append(LAYOUT);
            properties.setProperty(builder.toString(), toolBarOptions.getLayout().toString());
            builder = new StringBuilder();
            builder.append(prefix);
            builder.append(STYLE);
            properties.setProperty(builder.toString(), toolBarOptions.getStyle().toString());
            for (int i = 0; i < toolBarOptions.getComponentInfos().size(); ++i) {
                ComponentInfo componentInfo = toolBarOptions.getComponentInfos().get(i);
                builder = new StringBuilder();
                builder.append(name);
                builder.append(".");
                builder.append(COMPONENT);
                builder.append(".");
                builder.append(componentInfo.getComponentSource());
                builder.append(".");
                prefix = builder.toString();
                builder = new StringBuilder();
                builder.append(prefix);
                builder.append(POSITION);
                properties.setProperty(builder.toString(), Integer.toString(i));
                if (componentInfo instanceof ActionInfo) {
                    builder = new StringBuilder();
                    builder.append(prefix);
                    builder.append(SHOW_WITH_TEXT);
                    properties.setProperty(builder.toString(), Boolean.toString(((ActionInfo)componentInfo).isShowWithText()));
                }
                builder = new StringBuilder();
                builder.append(prefix);
                builder.append(COMPONENT_STATE);
                properties.setProperty(builder.toString(), componentInfo.getState().toString());
            }
        }
        return properties;
    }
}

