/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.rmi.one_instance.server;

import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.options.mailto.MailToOptions;
import com.novell.gw.jclient.application.startup.ComposeMailDispatcher;
import com.novell.gw.jclient.application.startup.MailToEvent;
import com.novell.gw.jclient.application.startup.OpenMailEvent;
import com.novell.gw.jclient.rmi.one_instance.GWClientRMI;
import java.io.File;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GWClientRMIImpl
extends UnicastRemoteObject
implements GWClientRMI {
    private static Logger logger = Logger.getLogger(GWClientRMIImpl.class);

    public GWClientRMIImpl() throws RemoteException {
        logger.debug((Object)("Create Instance of " + GWClientRMIImpl.class));
    }

    @Override
    public String getVersion() {
        return "7.0";
    }

    @Override
    public void openFiles(List<File> files) throws RemoteException {
        for (File file : files) {
            ComposeMailDispatcher.dispatchEvent(new OpenMailEvent(file));
        }
    }

    @Override
    public void showComposeNewMailForm(MailToOptions mailTo) throws RemoteException {
        logger.debug((Object)("RMI Request to Show Compose New Mail Form " + mailTo));
        ComposeMailDispatcher.dispatchEvent(new MailToEvent(mailTo));
    }

    @Override
    public void startNotifier() throws RemoteException {
        logger.debug((Object)"Starting Notifier");
        GWClient client = (GWClient)GWClient.getApplication();
        client.startNotifier(true);
    }

    @Override
    public void startGWClient() throws RemoteException {
        logger.debug((Object)"Starting GW Client");
        GWClient client = (GWClient)GWClient.getApplication();
        if (client != null) {
            client.startGWClient();
        }
    }
}

