/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.common;

import com.novell.gw.admin.common.ErrorDescription;
import com.novell.gw.admin.common.ErrorInterpreter;
import com.novell.gw.util.ClassHeirarchy;
import com.novell.gw.util.Debug;
import com.novell.gw.util.Resource;
import java.util.MissingResourceException;

public abstract class AbstractErrorInterpreter
implements ErrorInterpreter {
    protected Resource res = null;

    public AbstractErrorInterpreter(String string) {
        this.res = Resource.getBundle((String)string);
    }

    public AbstractErrorInterpreter(Resource resource) {
        this.res = resource;
    }

    public ErrorDescription getErrorDescription(Exception exception) {
        Debug.assrtPrecondition((boolean)this.handles(exception), null);
        ErrorDescription errorDescription = new ErrorDescription();
        String string = null;
        String string2 = this.getErrorKey(exception);
        while (string == null) {
            try {
                string = this.res.getString(string2);
            }
            catch (MissingResourceException missingResourceException) {
                Debug.trace((String)("\n***AbstractErrorInterpreter.getErrorDescription: key= " + string2 + "\n e= " + missingResourceException));
                string2 = this.getErrorKey(exception.getClass().getSuperclass());
            }
        }
        Debug.assrtPostcondition((string != null ? 1 : 0) != 0, null);
        errorDescription.setErrorMessage(string + "\n" + exception.getMessage());
        return errorDescription;
    }

    public String getErrorKey(Exception exception) {
        return this.getErrorKey(exception.getClass());
    }

    public String getErrorKey(Class clazz) {
        return ClassHeirarchy.getSimpleClassName((String)clazz.getName());
    }

    public abstract boolean handles(Exception var1);
}

