/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.ui;

import com.novell.gw.admin.ui.AttributeMapper;
import com.novell.gw.admin.ui.BasicMapper;
import com.novell.gw.admin.ui.DateMapper;
import com.novell.gw.admin.ui.DosDateMapper;
import com.novell.gw.admin.ui.LanguageMapper;
import com.novell.gw.admin.ui.MoveStatusActionMapper;
import com.novell.gw.admin.ui.MoveStatusErrorMapper;
import java.util.Hashtable;

public abstract class AttributeMapperFactory {
    private static Hashtable mapHash = new Hashtable();

    public static AttributeMapper getAttributeMapper(String string) {
        try {
            int n = Integer.parseInt(string);
            return AttributeMapperFactory.getAttributeMapper(n);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static AttributeMapper getAttributeMapper(int n) {
        String string = String.valueOf(n);
        AttributeMapper attributeMapper = (AttributeMapper)mapHash.get(string);
        if (attributeMapper == null) {
            switch (n) {
                case 50064: 
                case 50138: 
                case 61109: 
                case 61171: 
                case 61172: 
                case 61185: {
                    attributeMapper = new DateMapper();
                    break;
                }
                case 61163: {
                    attributeMapper = new MoveStatusErrorMapper();
                    break;
                }
                case 50321: {
                    attributeMapper = new MoveStatusActionMapper();
                    break;
                }
                case 50166: {
                    attributeMapper = new LanguageMapper();
                    mapHash.put(string, attributeMapper);
                    break;
                }
                case 61155: {
                    attributeMapper = new DosDateMapper();
                    break;
                }
                default: {
                    attributeMapper = new BasicMapper(string);
                    mapHash.put(string, attributeMapper);
                }
            }
        }
        return attributeMapper;
    }
}

