/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.ui;

import com.novell.application.console.snapin.NConeFactory;
import com.novell.gw.admin.ui.DsuiLayout;
import com.novell.gw.admin.ui.DsuiResource;
import com.novell.gw.admin.ui.DsuiView;
import com.novell.gw.admin.widgets.GWComboBox;
import com.novell.gw.util.Debug;
import java.awt.Component;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class ChoiceEditor
extends DsuiView {
    private GWComboBox comboBox;
    private Vector valueChoices;
    private JLabel label;
    private String mapName = null;
    private Object[] mappings = null;
    private boolean useIndex = true;

    public ChoiceEditor() {
        this((DsuiLayout)null, (String)null);
    }

    public ChoiceEditor(String string) {
        this(null, string);
    }

    public ChoiceEditor(Object[] objectArray) {
        this((DsuiLayout)null);
        this.mappings = objectArray;
    }

    public ChoiceEditor(DsuiLayout dsuiLayout) {
        this(dsuiLayout, (String)null);
    }

    public ChoiceEditor(DsuiLayout dsuiLayout, String string) {
        if (dsuiLayout == null) {
            dsuiLayout = new DsuiLayout();
        }
        this.valueChoices = new Vector();
        this.setLayout(dsuiLayout);
        this.label = new JLabel();
        this.comboBox = new GWComboBox();
        this.comboBox.setLightWeightPopupEnabled(false);
        this.add((Component)this.label, DsuiLayout.LABEL);
        this.add((Component)this.comboBox, DsuiLayout.FIELD);
        this.mapName = string;
    }

    public ChoiceEditor(DsuiLayout dsuiLayout, Object[] objectArray) {
        this(dsuiLayout);
        this.mappings = objectArray;
        this.comboBox.setEditable(true);
        this.useIndex = false;
    }

    public void setLabel(String string) {
        this.label.setText(string);
        NConeFactory.makeRelation((JLabel)this.label, (JComboBox)this.comboBox);
        if (this.mappings == null) {
            this.buildList();
        } else {
            this.finishList();
        }
    }

    private void buildList() {
        String string = this.mapName == null ? this.descriptor.getAttributeName() + ".mapping" : this.mapName + ".mapping";
        try {
            String string2 = DsuiResource.getString(string);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                this.valueChoices.addElement(stringTokenizer.nextToken());
                this.comboBox.addItem(stringTokenizer.nextToken());
            }
        }
        catch (MissingResourceException missingResourceException) {
            Debug.trace((String)("ChoiceEditor.buildList> Missing Resource: " + string));
            Debug.traceException((Throwable)missingResourceException);
        }
        catch (NoSuchElementException noSuchElementException) {
            this.valueChoices.clear();
            this.comboBox.removeAllItems();
            Debug.trace((String)("ChoiceEditor.buildList> Malformed Resource: " + string));
            Debug.traceException((Throwable)noSuchElementException);
        }
    }

    private void finishList() {
        for (int i = 0; i < this.mappings.length; ++i) {
            this.valueChoices.addElement(this.mappings[i].toString());
            this.comboBox.addItem(this.mappings[i].toString());
        }
    }

    public Object getEventDispatcher() {
        return this.comboBox;
    }

    public void setValue(Object object) {
        if (object != null) {
            if (this.useIndex) {
                int n = this.valueChoices.indexOf(object.toString());
                this.comboBox.setSelectedIndex(n);
            } else {
                this.comboBox.setSelectedItem(object.toString());
            }
        }
    }

    public Object getValue() {
        String string = null;
        if (this.useIndex) {
            try {
                int n = this.comboBox.getSelectedIndex();
                Object e = this.valueChoices.elementAt(n);
                string = e.toString();
                Integer n2 = new Integer(string);
                return n2;
            }
            catch (NumberFormatException numberFormatException) {
                Debug.trace((String)("ChoiceEditor.getValue: ex= " + numberFormatException));
            }
        } else {
            string = (String)this.comboBox.getSelectedItem();
        }
        return string;
    }

    public void setEnabled(boolean bl) {
        this.comboBox.setEnabled(bl);
    }

    public void setLabelEnabled(boolean bl) {
        this.label.setEnabled(bl);
    }

    public void setLabelVisible(boolean bl) {
        this.label.setVisible(bl);
    }
}

