/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.ui;

import com.novell.gw.admin.ui.DateTimeEditor;
import com.novell.gw.admin.ui.DsuiLayout;
import com.novell.gw.util.Debug;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.JDialog;

public class DosDateEditor
extends DateTimeEditor {
    public static final int DATE_60 = 10886;
    public static final int DATE_601 = 11103;
    public static final int DATE_602 = 11534;
    public static final int DATE_65 = 11650;
    public static final String[] versionStrA = new String[]{"6.0", "6.0.1", "6.0.2", "6.5"};

    public DosDateEditor(DsuiLayout dsuiLayout, JDialog jDialog, boolean bl) {
        super(dsuiLayout, jDialog, bl);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        this.dateCtrl.setCalendar((Calendar)gregorianCalendar);
        this.dateCtrl.setDateTimeFormat(DateFormat.getDateInstance(2));
    }

    protected void setDate(int n) {
        Debug.trace((String)("DosDateEditor.setDate: dosDate= " + n));
        int n2 = ((n & 0xFE00) >> 9) + 1980;
        int n3 = ((n & 0x1E0) >> 5) - 1;
        int n4 = n & 0x1F;
        this.dateCtrl.getCalendar().set(n2, n3, n4);
        if (Debug.trace) {
            Debug.trace((String)("     dosDate= " + n));
            Debug.trace((String)("     month/day/year= " + n3 + "/" + n4 + "/" + n2));
        }
    }

    protected Integer getDate() {
        Debug.trace((String)"   DosDateEditor.getDate:");
        Calendar calendar = this.dateCtrl.getCalendar();
        int n = calendar.get(1);
        int n2 = calendar.get(2) + 1;
        int n3 = calendar.get(5);
        int n4 = (n - 1980 << 9) + (n2 << 5) + n3;
        if (Debug.trace) {
            Debug.trace((String)("     month/day/year= " + n2 + "/" + n3 + "/" + n));
            Debug.trace((String)("     dosDate= " + n4));
        }
        return new Integer(n4);
    }

    public int getIntValue() {
        Integer n = (Integer)this.getValue();
        return n;
    }

    public void setIntValue(int n, boolean bl) {
        this.setValue(new Integer(n));
        if (bl) {
            Debug.trace((String)"DateTimeEditor.setIntValue: calling updateModel");
            this.controller.updateModel();
        }
    }

    public static int getDateFromVersion(String string) {
        if (string == null || string.equals("")) {
            return 0;
        }
        if (string.equals("6.0") || string.equals("6.0.0")) {
            return 10886;
        }
        if (string.equals("6.01") || string.equals("6.0.1")) {
            return 11103;
        }
        if (string.equals("6.02") || string.equals("6.0.2")) {
            return 11534;
        }
        if (string.equals("6.5") || string.equals("6.5.0")) {
            return 11650;
        }
        Debug.trace((String)("\n  DosDateEditor.getDateFromVersion: INVALID ver= " + string));
        return 0;
    }
}

