/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.ui;

import com.novell.gw.admin.ui.DsuiAttrDescriptor;
import com.novell.gw.admin.ui.DsuiController;
import com.novell.gw.admin.ui.DsuiModel;
import com.novell.gw.admin.ui.DsuiResource;
import com.novell.gw.admin.ui.DsuiView;
import com.novell.gw.admin.ui.FocusController;
import com.novell.gw.admin.ui.ReadOnlyEditor;
import com.novell.gw.util.Debug;

public class Dsui {
    protected DsuiView view;
    protected DsuiController controller;
    protected DsuiAttrDescriptor descriptor;
    protected DsuiModel model;

    public Dsui(DsuiAttrDescriptor dsuiAttrDescriptor, DsuiModel dsuiModel) {
        this(dsuiAttrDescriptor, dsuiModel, new ReadOnlyEditor(), null);
    }

    public Dsui(DsuiAttrDescriptor dsuiAttrDescriptor, DsuiModel dsuiModel, DsuiView dsuiView) {
        this(dsuiAttrDescriptor, dsuiModel, dsuiView, null);
    }

    public Dsui(DsuiAttrDescriptor dsuiAttrDescriptor, DsuiModel dsuiModel, DsuiView dsuiView, DsuiController dsuiController) {
        this(dsuiModel, dsuiView, dsuiController);
        this.setDescriptor(dsuiAttrDescriptor);
    }

    protected Dsui(DsuiModel dsuiModel) {
        this(dsuiModel, new ReadOnlyEditor(), null);
    }

    protected Dsui(DsuiModel dsuiModel, DsuiView dsuiView) {
        this(dsuiModel, dsuiView, null);
    }

    protected Dsui(DsuiModel dsuiModel, DsuiView dsuiView, DsuiController dsuiController) {
        this.model = dsuiModel;
        this.view = dsuiView;
        if (dsuiController != null) {
            this.controller = dsuiController;
        } else {
            try {
                String string = dsuiView.getClass().getName();
                String string2 = DsuiResource.getString(string + ".controller");
                this.controller = (DsuiController)Class.forName(string2).newInstance();
            }
            catch (Exception exception) {
                this.controller = new FocusController();
            }
        }
        this.registerMVC();
    }

    public DsuiView getView() {
        return this.view;
    }

    public void setView(DsuiView dsuiView) {
        this.view = dsuiView;
        this.registerMVC();
    }

    public void setView(String string) {
        this.setView((DsuiView)Dsui.getInstance(string));
    }

    public DsuiController getController() {
        return this.controller;
    }

    public void setController(DsuiController dsuiController) {
        this.controller = dsuiController;
        this.registerMVC();
    }

    public void setController(String string) {
        this.setController((DsuiController)Dsui.getInstance(string));
    }

    public void setDescriptor(DsuiAttrDescriptor dsuiAttrDescriptor) {
        this.descriptor = dsuiAttrDescriptor;
        dsuiAttrDescriptor.updateRights(this.model);
        this.view.setAttrDescriptor(dsuiAttrDescriptor);
        this.view.updateValue();
        this.controller.setAttrDescriptor(dsuiAttrDescriptor);
        this.controller.registerViewListeners();
    }

    public void reset() {
        this.controller.setEnabled(false);
        this.view.updateValue();
        this.controller.setEnabled(true);
    }

    public void updateModel() {
        this.controller.updateModel();
    }

    public void setEnabled(boolean bl) {
        this.view.setDsuiEnabledWithRights(bl);
    }

    protected void registerMVC() {
        this.view.setModel(this.model);
        this.view.setController(this.controller);
        this.controller.setModel(this.model);
        this.controller.setView(this.view);
    }

    private static Object getInstance(String string) {
        Object obj;
        if (string == "" || string == null) {
            return null;
        }
        try {
            obj = Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            Debug.trace((String)("Dsui exception caught: " + exception));
            return null;
        }
        return obj;
    }
}

